/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletContext;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.servlet.ServletRegistration;
import org.ocpsoft.rewrite.servlet.impl.WebXmlServletRegistrationParser;
import org.ocpsoft.rewrite.servlet.spi.ServletRegistrationProvider;

public class WebXmlServletRegistrationProvider
implements ServletRegistrationProvider {
    private final Logger log = Logger.getLogger(WebXmlServletRegistrationProvider.class);

    @Override
    public int priority() {
        return 20;
    }

    @Override
    public List<ServletRegistration> getServletRegistrations(ServletContext context) {
        InputStream webXmlStream = context.getResourceAsStream("/WEB-INF/web.xml");
        if (webXmlStream != null) {
            try {
                WebXmlServletRegistrationParser parser = new WebXmlServletRegistrationParser();
                parser.parse(webXmlStream);
                return parser.getRegistrations();
            }
            catch (IOException e) {
                this.log.warn("Failed to parse web.xml to look for servlet registations", e);
            }
        }
        return null;
    }
}

