/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.ocpsoft.logging.Logger;

public class JDKLogAdapter
extends Logger {
    private final java.util.logging.Logger delegate;
    private final String name;

    public JDKLogAdapter(String name) {
        this.name = name;
        this.delegate = java.util.logging.Logger.getLogger(name);
    }

    @Override
    protected void log(Logger.Level level, String msg, Throwable t) {
        LogRecord r = new LogRecord(this.getJdkLogLevel(level), msg);
        r.setSourceClassName(this.name);
        r.setSourceMethodName(null);
        r.setThrown(t);
        this.delegate.log(r);
    }

    @Override
    protected boolean isEnabled(Logger.Level level) {
        return this.delegate.isLoggable(this.getJdkLogLevel(level));
    }

    protected final Level getJdkLogLevel(Logger.Level level) {
        switch (level) {
            case TRACE: {
                return Level.FINER;
            }
            case DEBUG: {
                return Level.FINE;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARNING;
            }
            case ERROR: {
                return Level.SEVERE;
            }
        }
        throw new IllegalArgumentException("Unsupported log level: " + (Object)((Object)level));
    }
}

