/*
 * Decompiled with CFR 0.152.
 */
package org.octopusden.releng.versions;

import java.util.Collections;
import java.util.List;
import org.octopusden.releng.versions.IVersionInfo;
import org.octopusden.releng.versions.KotlinVersionFormatter;
import org.octopusden.releng.versions.VersionNames;

public final class NumericVersion
implements IVersionInfo {
    private static final int FORTH_ITEM_INDEX = 3;
    private static final int FIFTH_ITEM_INDEX = 4;
    private final List<Integer> items;
    private final String rawVersion;
    private final boolean snapshot;
    private final boolean rcVersion;
    private final VersionNames versionNames;

    NumericVersion(VersionNames versionNames, List<Integer> items, String rawVersion, boolean snapshot, boolean rcVersion) {
        this.snapshot = snapshot;
        this.items = Collections.unmodifiableList(items);
        this.rawVersion = rawVersion;
        this.rcVersion = rcVersion;
        this.versionNames = versionNames;
    }

    public String toString() {
        return this.rawVersion;
    }

    @Override
    public int getItem(int index) {
        return this.items.size() > index ? this.items.get(index) : 0;
    }

    @Override
    public int getItemsCount() {
        return this.items.size();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NumericVersion)) {
            return false;
        }
        return this.compareTo((NumericVersion)obj) == 0;
    }

    public int hashCode() {
        return this.rawVersion.hashCode();
    }

    @Override
    public int getMajor() {
        return this.getItem(0);
    }

    @Override
    public int getMinor() {
        return this.getItem(1);
    }

    @Override
    public int getService() {
        return this.getItem(2);
    }

    @Override
    public int getFix() {
        return this.getItem(3);
    }

    @Override
    public int getBuildNumber() {
        return this.getItem(4);
    }

    @Override
    public boolean isSnapshot() {
        return this.snapshot;
    }

    @Override
    public String formatVersion(String format) {
        return new KotlinVersionFormatter(this.versionNames).format(format, this);
    }

    public boolean isRcVersion() {
        return this.rcVersion;
    }

    @Override
    public int compareTo(IVersionInfo o) {
        int maxItemsCount = Math.max(this.items.size(), o.getItemsCount());
        for (int i = 0; i < maxItemsCount; ++i) {
            if (this.getItem(i) == o.getItem(i)) continue;
            return this.getItem(i) > o.getItem(i) ? 1 : -1;
        }
        return 0;
    }
}

