/*
 * Decompiled with CFR 0.152.
 */
package org.octopusden.releng.versions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.octopusden.releng.versions.IVersionInfo;
import org.octopusden.releng.versions.NumericVersionFactory;
import org.octopusden.releng.versions.VersionNames;
import org.octopusden.releng.versions.VersionRange;

public final class VersionRangeImpl
implements VersionRange {
    private static final int MINIMUM_RANGE_LENGTH = 3;
    private final String versionRange;
    private final List<VersionRestriction> versionRestrictions = new ArrayList<VersionRestriction>();

    VersionRangeImpl(VersionNames versionNames, String versionRange) {
        this.versionRange = versionRange;
        Arrays.stream(versionRange.split("(?<=[])])\\s*,\\s*(?=[\\[(])")).map(range -> VersionRestriction.parseInternal(range, versionNames)).forEach(this.versionRestrictions::add);
        for (int i = 0; i < this.versionRestrictions.size() - 1; ++i) {
            if (this.versionRestrictions.get(i).right == null || this.versionRestrictions.get(i + 1).left == null || this.versionRestrictions.get(i).right.compareTo(this.versionRestrictions.get(i + 1).left) <= 0) continue;
            throw new IllegalArgumentException("Bad range: the previous range " + this.versionRestrictions.get(i).source + " overlaps next " + this.versionRestrictions.get(i + 1).source);
        }
    }

    @Override
    public boolean containsVersion(IVersionInfo version) {
        return this.versionRestrictions.stream().anyMatch(versionRange -> ((VersionRestriction)versionRange).containsVersion(version));
    }

    @Override
    public boolean isIntersect(VersionRange other) {
        if (other.getClass() != this.getClass()) {
            throw new IllegalArgumentException("Cannot use " + other.getClass() + " as VersionRange");
        }
        VersionRangeImpl otherRange = (VersionRangeImpl)other;
        return this.versionRestrictions.stream().anyMatch(left -> {
            if (((VersionRestriction)left).hardVersion) {
                return otherRange.versionRestrictions.stream().anyMatch(right -> ((VersionRestriction)right).containsVersion(((VersionRestriction)left).left));
            }
            return otherRange.versionRestrictions.stream().anyMatch(right -> ((VersionRestriction)right).hardVersion && ((VersionRestriction)left).containsVersion(((VersionRestriction)right).right) || (VersionRangeImpl.compareLeftLeftToRightLeft(left, right) >= 0 || VersionRangeImpl.compareLeftRightToRightLeft(left, right) >= 0) && (VersionRangeImpl.compareLeftLeftToRightRight(left, right) <= 0 || VersionRangeImpl.compareLeftRightToRightRight(left, right) <= 0));
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionRangeImpl that = (VersionRangeImpl)o;
        return this.versionRange.equals(that.versionRange);
    }

    public int hashCode() {
        return Objects.hash(this.versionRange);
    }

    public String toString() {
        return "VersionRange='" + this.versionRange + '\'';
    }

    private static int restrictedCompare(IVersionInfo left, boolean leftIncluded, IVersionInfo right, boolean rightIncluded, int restrictedValue) {
        int result = left.compareTo(right);
        if (result != 0 || leftIncluded && rightIncluded) {
            return result;
        }
        return restrictedValue;
    }

    private static int compareLeftLeftToRightLeft(VersionRestriction left, VersionRestriction right) {
        return left.left == null && right.left == null ? 0 : (left.left == null ? -1 : (right.left == null ? 1 : VersionRangeImpl.restrictedCompare(left.left, left.includeLeft, right.left, right.includeRight, -1)));
    }

    private static int compareLeftLeftToRightRight(VersionRestriction left, VersionRestriction right) {
        return left.left == null && right.right == null ? 0 : (left.left == null ? -1 : (right.right == null ? 1 : VersionRangeImpl.restrictedCompare(left.left, left.includeLeft, right.right, right.includeRight, 1)));
    }

    private static int compareLeftRightToRightLeft(VersionRestriction left, VersionRestriction right) {
        return left.right == null && right.left == null ? 0 : (left.right == null || right.left == null ? 1 : VersionRangeImpl.restrictedCompare(left.right, left.includeRight, right.left, right.includeLeft, -1));
    }

    private static int compareLeftRightToRightRight(VersionRestriction left, VersionRestriction right) {
        return left.right == null && right.right == null ? 0 : (left.right == null ? 1 : (right.right == null ? -1 : VersionRangeImpl.restrictedCompare(left.right, left.includeRight, right.right, right.includeRight, -1)));
    }

    private static final class VersionRestriction {
        private final String source;
        private final IVersionInfo left;
        private final boolean includeLeft;
        private final IVersionInfo right;
        private final boolean includeRight;
        private final boolean hardVersion;

        private VersionRestriction(String source, IVersionInfo left, boolean includeLeft, IVersionInfo right, boolean includeRight) {
            if (left == null && right == null) {
                throw new IllegalArgumentException("Bad range: no minimum, maximum allowed versions are specified " + source);
            }
            this.source = source;
            this.left = left;
            this.includeLeft = includeLeft;
            this.right = right;
            this.includeRight = includeRight;
            this.hardVersion = left != null && right != null && left.compareTo(right) == 0;
        }

        private boolean containsVersion(IVersionInfo version) {
            Objects.requireNonNull(version, "Version can't be null");
            if (this.left != null && (this.includeLeft && this.left.compareTo(version) > 0 || !this.includeLeft && this.left.compareTo(version) >= 0)) {
                return false;
            }
            return this.right == null || (!this.includeRight || this.right.compareTo(version) >= 0) && (this.includeRight || this.right.compareTo(version) > 0);
        }

        private static VersionRestriction parseInternal(String versionRange, VersionNames versionNames) {
            IVersionInfo maximum;
            String rightVersion;
            boolean includeRight;
            String leftVersion;
            boolean includeLeft;
            String[] versionRangeParts = versionRange.trim().split("\\s*,\\s*");
            if (versionRangeParts[0].length() == 0) {
                throw new IllegalArgumentException("Bad version range: there is no 'minimum' specification " + versionRange);
            }
            NumericVersionFactory numericVersionFactory = new NumericVersionFactory(versionNames);
            if (versionRangeParts.length == 1) {
                if (versionRangeParts[0].charAt(0) != '[') {
                    throw new IllegalArgumentException("Bad version range: the '[' doesn't specify hard version: " + versionRange);
                }
                if (versionRangeParts[0].length() < 3 || versionRangeParts[0].charAt(versionRangeParts[0].length() - 1) != ']') {
                    throw new IllegalArgumentException("Bad version range: the ']' doesn't specify hard version: " + versionRange);
                }
                IVersionInfo version = numericVersionFactory.create(versionRangeParts[0].substring(1, versionRangeParts[0].length() - 1));
                return new VersionRestriction(versionRange, version, true, version, true);
            }
            if (versionRangeParts.length > 2) {
                throw new IllegalArgumentException("Bad version range: too many versions " + versionRange);
            }
            if (versionRangeParts[1].length() == 0) {
                throw new IllegalArgumentException("Bad version range: there is no 'maximum' specification " + versionRange);
            }
            switch (versionRangeParts[0].charAt(0)) {
                case '[': {
                    if (versionRangeParts[0].length() == 1) {
                        throw new IllegalArgumentException("Bad version range: the '[' doesn't specify start of range: " + versionRange);
                    }
                    includeLeft = true;
                    leftVersion = versionRangeParts[0].substring(1);
                    break;
                }
                case '(': {
                    includeLeft = false;
                    leftVersion = versionRangeParts[0].length() == 1 ? null : versionRangeParts[0].substring(1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad version range: the 'soft' requirement isn't supported: " + versionRange);
                }
            }
            switch (versionRangeParts[1].charAt(versionRangeParts[1].length() - 1)) {
                case ']': {
                    if (versionRangeParts[1].length() == 1) {
                        throw new IllegalArgumentException("Bad version range: the ']' doesn't specify end of range: " + versionRange);
                    }
                    includeRight = true;
                    rightVersion = versionRangeParts[1].substring(0, versionRangeParts[1].length() - 1);
                    break;
                }
                case ')': {
                    includeRight = false;
                    rightVersion = versionRangeParts[1].length() == 1 ? null : versionRangeParts[1].substring(0, versionRangeParts[1].length() - 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad version range: the 'soft' requirement isn't supported: " + versionRange);
                }
            }
            IVersionInfo minimum = leftVersion != null ? numericVersionFactory.create(leftVersion) : null;
            IVersionInfo iVersionInfo = maximum = rightVersion != null ? numericVersionFactory.create(rightVersion) : null;
            if (minimum != null && maximum != null) {
                if (minimum.compareTo(maximum) == 0) {
                    if (!includeLeft) {
                        throw new IllegalArgumentException("Bad version range: the '[' doesn't start range: " + versionRange);
                    }
                    if (!includeRight) {
                        throw new IllegalArgumentException("Bad version range: the ']' doesn't start range: " + versionRange);
                    }
                }
                if (minimum.compareTo(maximum) > 0) {
                    throw new IllegalArgumentException("Bad version range: the left (minimal) is greater than right (maximum): " + versionRange);
                }
            }
            return new VersionRestriction(versionRange, minimum, includeLeft, maximum, includeRight);
        }

        public String toString() {
            return "VersionRange{source='" + this.source + '\'' + ", left=" + this.left + ", includeLeft=" + this.includeLeft + ", right=" + this.right + ", includeRight=" + this.includeRight + '}';
        }
    }
}

