/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractJAXBProvider;
import org.apache.cxf.jaxrs.provider.JSONUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXBUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.SimpleConverter;
import org.codehaus.jettison.mapped.TypeConverter;
import org.codehaus.jettison.util.StringIndenter;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Provider
public class JSONProvider
extends AbstractJAXBProvider {
    private static final String MAPPED_CONVENTION = "mapped";
    private static final String BADGER_FISH_CONVENTION = "badgerfish";
    private ConcurrentHashMap<String, String> namespaceMap = new ConcurrentHashMap();
    private boolean serializeAsArray;
    private List<String> arrayKeys;
    private boolean unwrapped;
    private String wrapperName;
    private Map<String, String> wrapperMap;
    private boolean dropRootElement;
    private boolean dropCollectionWrapperElement;
    private boolean ignoreMixedContent;
    private boolean writeXsiType = true;
    private boolean readXsiType = true;
    private boolean ignoreNamespaces;
    private String convention = "mapped";
    private TypeConverter typeConverter;
    private boolean attributesToElements;

    @Override
    public void setAttributesToElements(boolean value) {
        this.attributesToElements = value;
    }

    public void setConvention(String value) {
        if (!MAPPED_CONVENTION.equals(value) && !BADGER_FISH_CONVENTION.equals(value)) {
            throw new IllegalArgumentException("Unsupported convention \"" + value);
        }
        this.convention = value;
    }

    public void setConvertTypesToStrings(boolean convert) {
        if (convert) {
            this.setTypeConverter((TypeConverter)new SimpleConverter());
        }
    }

    public void setTypeConverter(TypeConverter converter) {
        this.typeConverter = converter;
    }

    public void setIgnoreNamespaces(boolean ignoreNamespaces) {
        this.ignoreNamespaces = ignoreNamespaces;
    }

    @Context
    public void setMessageContext(MessageContext mc) {
        super.setContext(mc);
    }

    public void setDropRootElement(boolean drop) {
        this.dropRootElement = drop;
    }

    public void setDropCollectionWrapperElement(boolean drop) {
        this.dropCollectionWrapperElement = drop;
    }

    public void setIgnoreMixedContent(boolean ignore) {
        this.ignoreMixedContent = ignore;
    }

    public void setSupportUnwrapped(boolean unwrap) {
        this.unwrapped = unwrap;
    }

    public void setWrapperName(String wName) {
        this.wrapperName = wName;
    }

    public void setWrapperMap(Map<String, String> map) {
        this.wrapperMap = map;
    }

    @Override
    public void setEnableBuffering(boolean enableBuf) {
        super.setEnableBuffering(enableBuf);
    }

    @Override
    public void setConsumeMediaTypes(List<String> types) {
        super.setConsumeMediaTypes(types);
    }

    @Override
    public void setProduceMediaTypes(List<String> types) {
        super.setProduceMediaTypes(types);
    }

    public void setSchemas(List<String> locations) {
        super.setSchemaLocations(locations);
    }

    public void setSchemaHandler(SchemaHandler handler) {
        super.setSchema(handler.getSchema());
    }

    public void setSerializeAsArray(boolean asArray) {
        this.serializeAsArray = asArray;
    }

    public void setArrayKeys(List<String> keys) {
        this.arrayKeys = keys;
    }

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        this.namespaceMap.putAll(namespaceMap);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        return super.isReadable(type, genericType, anns, mt) || Document.class.isAssignableFrom(type);
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            InputStream realStream = this.getInputStream(type, genericType, is);
            if (Document.class.isAssignableFrom(type)) {
                W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
                this.copyReaderToWriter(this.createReader(type, realStream, false), writer);
                return writer.getDocument();
            }
            boolean isCollection = InjectionUtils.isSupportedCollectionOrArray(type);
            Class<Object> theGenericType = isCollection ? InjectionUtils.getActualType(genericType) : type;
            Class<?> theType = this.getActualType(theGenericType, genericType, anns);
            Unmarshaller unmarshaller = this.createUnmarshaller(theType, genericType, isCollection);
            XMLStreamReader xsr = this.createReader(type, realStream, isCollection);
            Object response = null;
            response = JAXBElement.class.isAssignableFrom(type) || this.unmarshalAsJaxbElement || this.jaxbElementClassMap != null && this.jaxbElementClassMap.containsKey(theType.getName()) ? unmarshaller.unmarshal(xsr, theType) : unmarshaller.unmarshal(xsr);
            if (response instanceof JAXBElement && !JAXBElement.class.isAssignableFrom(type)) {
                response = response.getValue();
            }
            response = isCollection ? ((AbstractJAXBProvider.CollectionWrapper)response).getCollectionOrArray(theType, type, JAXBUtils.getAdapter(theGenericType, anns)) : JSONProvider.checkAdapter(response, type, anns, false);
            return response;
        }
        catch (JAXBException e) {
            JSONProvider.handleJAXBException(e, true);
        }
        catch (XMLStreamException e) {
            throw new WebApplicationException(e);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException(e);
        }
        return null;
    }

    protected XMLStreamReader createReader(Class<?> type, InputStream is, boolean isCollection) throws Exception {
        XMLStreamReader reader = this.createReader(type, is);
        return isCollection ? new AbstractJAXBProvider.JAXBCollectionWrapperReader(reader) : reader;
    }

    protected XMLStreamReader createReader(Class<?> type, InputStream is) throws Exception {
        if (BADGER_FISH_CONVENTION.equals(this.convention)) {
            return JSONUtils.createBadgerFishReader(is);
        }
        XMLStreamReader reader = JSONUtils.createStreamReader(is, this.readXsiType, this.namespaceMap);
        return this.createTransformReaderIfNeeded(reader, is);
    }

    protected InputStream getInputStream(Class<Object> cls, Type type, InputStream is) throws Exception {
        if (this.unwrapped) {
            String rootName = this.getRootName(cls, type);
            ByteArrayInputStream isBefore = new ByteArrayInputStream(rootName.getBytes());
            String after = "}";
            ByteArrayInputStream isAfter = new ByteArrayInputStream(after.getBytes());
            final InputStream[] streams = new InputStream[]{isBefore, is, isAfter};
            Enumeration<InputStream> list = new Enumeration<InputStream>(){
                private int index;

                @Override
                public boolean hasMoreElements() {
                    return this.index < streams.length;
                }

                @Override
                public InputStream nextElement() {
                    return streams[this.index++];
                }
            };
            return new SequenceInputStream((Enumeration<? extends InputStream>)list);
        }
        return is;
    }

    protected String getRootName(Class<Object> cls, Type type) throws Exception {
        QName qname;
        String name = null;
        if (this.wrapperName != null) {
            name = this.wrapperName;
        } else if (this.wrapperMap != null) {
            name = this.wrapperMap.get(cls.getName());
        }
        if (name == null && (qname = this.getQName(cls, type, null, false)) != null) {
            name = qname.getLocalPart();
            String prefix = qname.getPrefix();
            if (prefix.length() > 0) {
                name = prefix + "." + name;
            }
        }
        if (name == null) {
            throw new WebApplicationException(500);
        }
        return "{\"" + name + "\":";
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        return super.isWriteable(type, genericType, anns, mt) || Document.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(Object obj, Class<?> cls, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        if (os == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Jettison needs initialized OutputStream");
            if (this.getContext() != null && this.getContext().getContent(XMLStreamWriter.class) == null) {
                sb.append("; if you need to customize Jettison output with the custom XMLStreamWriter then extend JSONProvider or when possible configure it directly.");
            }
            throw new IOException(sb.toString());
        }
        try {
            String enc = HttpUtils.getSetEncoding(m, headers, "UTF-8");
            if (Document.class.isAssignableFrom(cls)) {
                XMLStreamWriter writer = this.createWriter(obj, cls, genericType, enc, os, false);
                this.copyReaderToWriter(StaxUtils.createXMLStreamReader((Document)obj), writer);
                return;
            }
            if (InjectionUtils.isSupportedCollectionOrArray(cls)) {
                this.marshalCollection(cls, obj, genericType, enc, os, m, anns);
            } else {
                Class<?> actualClass;
                Object actualObject = JSONProvider.checkAdapter(obj, cls, anns, true);
                Class<?> clazz = actualClass = obj != actualObject ? actualObject.getClass() : cls;
                if (cls == genericType) {
                    genericType = actualClass;
                }
                this.marshal(actualObject, actualClass, genericType, enc, os);
            }
        }
        catch (JAXBException e) {
            JSONProvider.handleJAXBException(e, false);
        }
        catch (XMLStreamException e) {
            throw new WebApplicationException(e);
        }
        catch (Exception e) {
            throw new WebApplicationException(e);
        }
    }

    protected void copyReaderToWriter(XMLStreamReader reader, XMLStreamWriter writer) throws Exception {
        writer.writeStartDocument();
        StaxUtils.copy(reader, writer);
        writer.writeEndDocument();
    }

    protected void marshalCollection(Class<?> originalCls, Object collection, Type genericType, String encoding, OutputStream os, MediaType m, Annotation[] anns) throws Exception {
        Class actualClass = InjectionUtils.getActualType(genericType);
        actualClass = this.getActualType(actualClass, genericType, anns);
        List<Object> c = originalCls.isArray() ? Arrays.asList((Object[])collection) : (List<Object>)collection;
        Iterator it = c.iterator();
        Object firstObj = it.hasNext() ? (Object)it.next() : null;
        String startTag = null;
        String endTag = null;
        if (!this.dropCollectionWrapperElement) {
            QName qname = null;
            if (firstObj instanceof JAXBElement) {
                JAXBElement el = (JAXBElement)firstObj;
                qname = el.getName();
                actualClass = el.getDeclaredType();
            } else {
                qname = this.getCollectionWrapperQName(actualClass, genericType, firstObj, false);
            }
            String prefix = "";
            if (!this.ignoreNamespaces) {
                if (this.namespaceMap.containsKey(qname.getNamespaceURI())) {
                    prefix = this.namespaceMap.get(qname.getNamespaceURI());
                    if (prefix.length() > 0) {
                        prefix = prefix + ".";
                    }
                } else if (qname.getNamespaceURI().length() > 0) {
                    prefix = "ns1.";
                }
            }
            startTag = "{\"" + prefix + qname.getLocalPart() + "\":[";
            endTag = "]}";
        } else if (this.serializeAsArray) {
            startTag = "[";
            endTag = "]";
        } else {
            startTag = "{";
            endTag = "}";
        }
        os.write(startTag.getBytes());
        if (firstObj != null) {
            XmlJavaTypeAdapter adapter = JAXBUtils.getAdapter(firstObj.getClass(), anns);
            this.marshalCollectionMember(JAXBUtils.useAdapter(firstObj, adapter, true), actualClass, genericType, encoding, os);
            while (it.hasNext()) {
                os.write(",".getBytes());
                this.marshalCollectionMember(JAXBUtils.useAdapter(it.next(), adapter, true), actualClass, genericType, encoding, os);
            }
        }
        os.write(endTag.getBytes());
    }

    protected void marshalCollectionMember(Object obj, Class<?> cls, Type genericType, String enc, OutputStream os) throws Exception {
        if ((obj = obj instanceof JAXBElement ? ((JAXBElement)obj).getValue() : this.convertToJaxbElementIfNeeded(obj, cls, genericType)) instanceof JAXBElement && cls != JAXBElement.class) {
            cls = JAXBElement.class;
        }
        Marshaller ms = this.createMarshaller(obj, cls, genericType, enc);
        this.marshal(ms, obj, cls, genericType, enc, os, true);
    }

    protected void marshal(Marshaller ms, Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os, boolean isCollection) throws Exception {
        OutputStream actualOs = os;
        MessageContext mc = this.getContext();
        if (mc != null && MessageUtils.isTrue(mc.get("jaxb.formatted.output"))) {
            actualOs = new CachedOutputStream();
        }
        XMLStreamWriter writer = this.createWriter(actualObject, actualClass, genericType, enc, actualOs, isCollection);
        ms.marshal(actualObject, writer);
        writer.close();
        if (os != actualOs) {
            StringIndenter formatter = new StringIndenter(IOUtils.newStringFromBytes(((CachedOutputStream)actualOs).getBytes()));
            OutputStreamWriter outWriter = new OutputStreamWriter(os, enc);
            IOUtils.copy(new StringReader(formatter.result()), outWriter, 2048);
            ((Writer)outWriter).close();
        }
    }

    protected XMLStreamWriter createWriter(Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os, boolean isCollection) throws Exception {
        QName qname = this.getQName(actualClass, genericType, actualObject, true);
        if (this.ignoreNamespaces && (isCollection || this.dropRootElement)) {
            qname = new QName(qname.getLocalPart());
        }
        if (BADGER_FISH_CONVENTION.equals(this.convention)) {
            return JSONUtils.createBadgerFishWriter(os);
        }
        Configuration config = JSONUtils.createConfiguration(this.namespaceMap, this.writeXsiType && !this.ignoreNamespaces, this.attributesToElements, this.typeConverter);
        XMLStreamWriter writer = JSONUtils.createStreamWriter(os, qname, this.writeXsiType && !this.ignoreNamespaces, config, this.serializeAsArray, this.arrayKeys, isCollection || this.dropRootElement);
        writer = JSONUtils.createIgnoreMixedContentWriterIfNeeded(writer, this.ignoreMixedContent);
        writer = JSONUtils.createIgnoreNsWriterIfNeeded(writer, this.ignoreNamespaces);
        return this.createTransformWriterIfNeeded(writer, os);
    }

    protected void marshal(Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os) throws Exception {
        if ((actualObject = this.convertToJaxbElementIfNeeded(actualObject, actualClass, genericType)) instanceof JAXBElement && actualClass != JAXBElement.class) {
            actualClass = JAXBElement.class;
        }
        Marshaller ms = this.createMarshaller(actualObject, actualClass, genericType, enc);
        this.marshal(ms, actualObject, actualClass, genericType, enc, os, false);
    }

    private QName getQName(Class<?> cls, Type type, Object object, boolean allocatePrefix) throws Exception {
        QName qname = this.getJaxbQName(cls, type, object, false);
        if (qname != null) {
            String prefix = this.getPrefix(qname.getNamespaceURI(), allocatePrefix);
            return new QName(qname.getNamespaceURI(), qname.getLocalPart(), prefix);
        }
        return null;
    }

    private String getPrefix(String namespace, boolean allocatePrefix) {
        String prefix = this.namespaceMap.get(namespace);
        if (prefix == null) {
            if (allocatePrefix && namespace.length() > 0) {
                prefix = "ns" + (this.namespaceMap.size() + 1);
                this.namespaceMap.put(namespace, prefix);
            } else {
                prefix = "";
            }
        }
        return prefix;
    }

    public void setWriteXsiType(boolean writeXsiType) {
        this.writeXsiType = writeXsiType;
    }

    public void setReadXsiType(boolean readXsiType) {
        this.readXsiType = readXsiType;
    }

    static {
        new SimpleConverter();
    }
}

