/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"text/html"})
@Provider
public class RequestDispatcherProvider
extends AbstractConfigurableProvider
implements MessageBodyWriter<Object> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(RequestDispatcherProvider.class);
    private static final Logger LOG = LogUtils.getL7dLogger(RequestDispatcherProvider.class);
    private static final String ABSOLUTE_PATH_PARAMETER = "absolute.path";
    private static final String BASE_PATH_PARAMETER = "base.path";
    private static final String WEBAPP_BASE_PATH_PARAMETER = "webapp.base.path";
    private static final String RELATIVE_PATH_PARAMETER = "relative.path";
    private static final String REQUEST_SCOPE = "request";
    private static final String SESSION_SCOPE = "session";
    private String servletContextPath;
    private String resourcePath;
    private Map<String, String> resourcePaths = Collections.emptyMap();
    private Map<String, String> classResources = Collections.emptyMap();
    private String scope = "request";
    private Map<String, String> beanNames = Collections.emptyMap();
    private String beanName;
    private String dispatcherName;
    private String servletPath;
    private boolean saveParametersAsAttributes;
    private boolean logRedirects;
    @Context
    private MessageContext mc;

    @Override
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        if (this.resourcePath != null || this.classResources.containsKey(type.getName())) {
            return true;
        }
        if (!this.resourcePaths.isEmpty()) {
            String path = this.getRequestPath();
            for (String requestPath : this.resourcePaths.keySet()) {
                if (!path.endsWith(requestPath)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void writeTo(Object o, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType type, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        ServletContext sc = this.getServletContext();
        String path = this.getResourcePath(clazz.getName());
        RequestDispatcher rd = this.getRequestDispatcher(sc, clazz, path);
        try {
            this.mc.put("http.request.redirected", Boolean.TRUE);
            String theServletPath = this.servletPath == null ? "/" : this.servletPath;
            HttpServletRequestFilter servletRequest = new HttpServletRequestFilter(this.mc.getHttpServletRequest(), path, theServletPath, this.saveParametersAsAttributes);
            String attributeName = this.getBeanName(o);
            if (REQUEST_SCOPE.equals(this.scope)) {
                servletRequest.setAttribute(attributeName, o);
            } else if (SESSION_SCOPE.equals(this.scope)) {
                servletRequest.getSession(true).setAttribute(attributeName, o);
            }
            this.setRequestParameters(servletRequest);
            this.logRedirection(path, attributeName, o);
            rd.forward((ServletRequest)servletRequest, (ServletResponse)this.mc.getHttpServletResponse());
        }
        catch (Throwable ex) {
            this.mc.put("http.request.redirected", Boolean.FALSE);
            ex.printStackTrace();
            throw new WebApplicationException(ex);
        }
    }

    private void logRedirection(String path, String attributeName, Object o) {
        Level level;
        Level level2 = level = this.logRedirects ? Level.INFO : Level.FINE;
        if (LOG.isLoggable(level)) {
            String message = new org.apache.cxf.common.i18n.Message("RESPONSE_REDIRECTED_TO", BUNDLE, o.getClass().getName(), attributeName, path).toString();
            LOG.log(level, message);
        }
    }

    private String getResourcePath(String clsName) {
        String clsResourcePath = this.classResources.get(clsName);
        if (clsResourcePath != null) {
            return clsResourcePath;
        }
        if (this.resourcePath != null) {
            return this.resourcePath;
        }
        String path = this.getRequestPath();
        for (String requestPath : this.resourcePaths.keySet()) {
            if (!path.endsWith(requestPath)) continue;
            return this.resourcePaths.get(requestPath);
        }
        return null;
    }

    private String getRequestPath() {
        Message inMessage = PhaseInterceptorChain.getCurrentMessage().getExchange().getInMessage();
        return (String)inMessage.get("org.apache.cxf.request.uri");
    }

    protected ServletContext getServletContext() {
        ServletContext sc = this.mc.getServletContext();
        if (this.servletContextPath != null && (sc = sc.getContext(this.servletContextPath)) == null) {
            String message = new org.apache.cxf.common.i18n.Message("RESOURCE_DISPATCH_NOT_FOUND", BUNDLE, this.servletContextPath).toString();
            LOG.severe(message);
            throw new WebApplicationException();
        }
        return sc;
    }

    protected RequestDispatcher getRequestDispatcher(ServletContext sc, Class<?> clazz, String path) {
        RequestDispatcher rd;
        RequestDispatcher requestDispatcher = rd = this.dispatcherName != null ? sc.getNamedDispatcher(this.dispatcherName) : sc.getRequestDispatcher(path);
        if (rd == null) {
            String message = new org.apache.cxf.common.i18n.Message("RESOURCE_PATH_NOT_FOUND", BUNDLE, path).toString();
            LOG.severe(message);
            throw new WebApplicationException();
        }
        return rd;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setServletContextPath(String servletContextPath) {
        this.servletContextPath = servletContextPath;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setBeanNames(Map<String, String> beanNames) {
        this.beanNames = beanNames;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setLogRedirects(String value) {
        this.logRedirects = Boolean.valueOf(value);
    }

    protected String getBeanName(Object bean) {
        if (this.beanName != null) {
            return this.beanName;
        }
        String name = this.beanNames.get(bean.getClass().getName());
        return name != null ? name : bean.getClass().getSimpleName().toLowerCase();
    }

    protected void setRequestParameters(HttpServletRequestFilter request) {
        if (this.mc != null) {
            UriInfo ui = this.mc.getUriInfo();
            MultivaluedMap<String, String> params = ui.getPathParameters();
            for (Map.Entry entry : params.entrySet()) {
                String value = (String)((List)entry.getValue()).get(0);
                int ind = value.indexOf(";");
                if (ind > 0) {
                    value = value.substring(0, ind);
                }
                request.setParameter((String)entry.getKey(), value);
            }
            List<PathSegment> segments = ui.getPathSegments();
            if (segments.size() > 0) {
                this.doSetRequestParameters(request, segments.get(segments.size() - 1).getMatrixParameters());
            }
            this.doSetRequestParameters(request, ui.getQueryParameters());
            request.setParameter(ABSOLUTE_PATH_PARAMETER, ui.getAbsolutePath().toString());
            request.setParameter(RELATIVE_PATH_PARAMETER, ui.getPath());
            request.setParameter(BASE_PATH_PARAMETER, ui.getBaseUri().toString());
            request.setParameter(WEBAPP_BASE_PATH_PARAMETER, (String)this.mc.get("http.base.path"));
        }
    }

    protected void doSetRequestParameters(HttpServletRequestFilter req, MultivaluedMap<String, String> params) {
        for (Map.Entry entry : params.entrySet()) {
            req.setParameters((String)entry.getKey(), (List)entry.getValue());
        }
    }

    public void setDispatcherName(String name) {
        this.dispatcherName = name;
    }

    public void setServletPath(String path) {
        this.servletPath = path;
    }

    public void setResourcePaths(Map<String, String> resourcePaths) {
        this.resourcePaths = resourcePaths;
    }

    public void setClassResources(Map<String, String> resources) {
        this.classResources = resources;
    }

    public void setSaveParametersAsAttributes(boolean saveParametersAsAttributes) {
        this.saveParametersAsAttributes = saveParametersAsAttributes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class HttpServletRequestFilter
    extends HttpServletRequestWrapper {
        private Map<String, String[]> params;
        private String path;
        private String servletPath;
        private boolean saveParamsAsAttributes;

        public HttpServletRequestFilter(HttpServletRequest request, String path, String servletPath, boolean saveParamsAsAttributes) {
            super(request);
            this.path = path;
            this.servletPath = servletPath;
            this.saveParamsAsAttributes = saveParamsAsAttributes;
            this.params = new HashMap<String, String[]>(request.getParameterMap());
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.path;
        }

        public String getRequestURI() {
            return this.path;
        }

        public void setParameter(String name, String value) {
            this.doSetParameters(name, new String[]{value});
        }

        public void setParameters(String name, List<String> values) {
            this.doSetParameters(name, values.toArray(new String[0]));
        }

        private void doSetParameters(String name, String[] values) {
            if (this.saveParamsAsAttributes) {
                if (values.length == 1) {
                    super.setAttribute(name, (Object)values[0]);
                }
                super.setAttribute(name + "Array", (Object)values);
            } else {
                this.params.put(name, values);
            }
        }

        public String getParameter(String name) {
            String[] values = this.params.get(name);
            if (values == null || values.length == 0) {
                return null;
            }
            return values[0];
        }

        public Map<String, String[]> getParameterMap() {
            return this.params;
        }
    }
}

