/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import java.util.ArrayList;
import java.util.List;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OLink;
import org.odata4j.core.OLinks;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.internal.InternalUtil;

public abstract class AbstractConsumerEntityPayloadRequest {
    protected final List<OProperty<?>> props = new ArrayList();
    protected final List<OLink> links = new ArrayList<OLink>();
    protected final String entitySetName;
    protected final String serviceRootUri;
    protected final EdmDataServices metadata;

    protected AbstractConsumerEntityPayloadRequest(String entitySetName, String serviceRootUri, EdmDataServices metadata) {
        this.entitySetName = entitySetName;
        this.serviceRootUri = serviceRootUri;
        this.metadata = metadata;
    }

    protected <T> T properties(T rt, OProperty<?> ... props) {
        for (OProperty<?> prop : props) {
            this.props.add(prop);
        }
        return rt;
    }

    protected <T> T properties(T rt, Iterable<OProperty<?>> props) {
        for (OProperty<?> prop : props) {
            this.props.add(prop);
        }
        return rt;
    }

    protected <T> T link(T rt, String navProperty, OEntity target) {
        return this.link(rt, navProperty, target.getEntitySet(), target.getEntityKey());
    }

    protected <T> T link(T rt, String navProperty, OEntityKey targetKey) {
        return this.link(rt, navProperty, null, targetKey);
    }

    private <T> T link(T rt, String navProperty, EdmEntitySet targetEntitySet, OEntityKey targetKey) {
        EdmEntitySet entitySet = this.metadata.getEdmEntitySet(this.entitySetName);
        EdmNavigationProperty navProp = entitySet.getType().findNavigationProperty(navProperty);
        if (navProp == null) {
            throw new IllegalArgumentException("unknown navigation property " + navProperty);
        }
        if (navProp.getToRole().getMultiplicity() == EdmMultiplicity.MANY) {
            throw new IllegalArgumentException("many associations are not supported");
        }
        StringBuilder href = new StringBuilder(this.serviceRootUri);
        if (!this.serviceRootUri.endsWith("/")) {
            href.append("/");
        }
        if (targetEntitySet == null) {
            targetEntitySet = this.metadata.getEdmEntitySet(navProp.getToRole().getType());
        }
        href.append(InternalUtil.getEntityRelId(targetEntitySet, targetKey));
        String rel = "http://schemas.microsoft.com/ado/2007/08/dataservices/related/" + navProperty;
        this.links.add(OLinks.relatedEntity(rel, navProperty, href.toString()));
        return rt;
    }
}

