/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.core;

import org.odata4j.core.NamespacedAnnotation;
import org.odata4j.core.PrefixedNamespace;

public class GenericAnnotation<T>
implements NamespacedAnnotation<T> {
    private final PrefixedNamespace namespace;
    private final String localName;
    private final Class<T> valueType;
    private final T value;

    public GenericAnnotation(String namespaceUri, String namespacePrefix, String localName, Class<T> valueType, T value) {
        this.namespace = new PrefixedNamespace(namespaceUri, namespacePrefix);
        this.localName = localName;
        this.valueType = valueType;
        this.value = value;
    }

    @Override
    public PrefixedNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.localName;
    }

    public String getFullyQualifiedName() {
        return this.namespace.getPrefix() + ":" + this.localName;
    }

    @Override
    public Class<T> getValueType() {
        return this.valueType;
    }

    @Override
    public T getValue() {
        return this.value;
    }
}

