/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.core4j.Enumerable;
import org.odata4j.core.AtomInfo;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OExtension;
import org.odata4j.core.OLink;
import org.odata4j.core.OPredicates;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmType;

public class OEntities {
    private OEntities() {
    }

    public static OEntity create(EdmEntitySet entitySet, OEntityKey entityKey, List<OProperty<?>> properties, List<OLink> links) {
        return new OEntityImpl(entitySet, null, entityKey, true, properties, links, new Object[0]);
    }

    public static OEntity create(EdmEntitySet entitySet, OEntityKey entityKey, List<OProperty<?>> properties, List<OLink> links, Object ... extensions) {
        return new OEntityImpl(entitySet, null, entityKey, true, properties, links, extensions);
    }

    public static OEntity create(EdmEntitySet entitySet, EdmEntityType entityType, OEntityKey entityKey, List<OProperty<?>> properties, List<OLink> links) {
        return new OEntityImpl(entitySet, entityType, entityKey, true, properties, links, new Object[0]);
    }

    public static OEntity createRequest(EdmEntitySet entitySet, List<OProperty<?>> properties, List<OLink> links) {
        return new OEntityImpl(entitySet, null, null, false, properties, links, new Object[0]);
    }

    public static OEntity create(EdmEntitySet entitySet, EdmEntityType entityType, OEntityKey entityKey, List<OProperty<?>> properties, List<OLink> links, String title, String categoryTerm) {
        return new OEntityAtomImpl(entitySet, entityType, entityKey, true, properties, links, title, categoryTerm);
    }

    public static OEntity createRequest(EdmEntitySet entitySet, List<OProperty<?>> properties, List<OLink> links, String title, String categoryTerm) {
        return new OEntityAtomImpl(entitySet, null, null, false, properties, links, title, categoryTerm);
    }

    private static class OEntityImpl
    implements OEntity {
        private final EdmEntitySet entitySet;
        private final EdmEntityType entityType;
        private final OEntityKey entityKey;
        private final List<OProperty<?>> properties;
        private final List<OLink> links;
        private final Collection<Object> extensions;

        OEntityImpl(EdmEntitySet entitySet, EdmEntityType entityType, OEntityKey entityKey, boolean entityKeyRequired, List<OProperty<?>> properties, List<OLink> links, Object ... extensions) {
            if (entitySet == null) {
                throw new IllegalArgumentException("entitySet cannot be null");
            }
            if (entityKeyRequired && entityKey == null) {
                throw new IllegalArgumentException("entityKey cannot be null");
            }
            this.entitySet = entitySet;
            this.entityType = entityType;
            this.entityKey = entityKey;
            this.properties = Collections.unmodifiableList(properties);
            this.links = links == null ? Collections.emptyList() : Collections.unmodifiableList(links);
            this.extensions = Arrays.asList(extensions);
        }

        public String toString() {
            return "OEntity[" + Enumerable.create(this.getProperties()).join(",") + "]";
        }

        @Override
        public EdmEntitySet getEntitySet() {
            return this.entitySet;
        }

        @Override
        public EdmEntityType getEntityType() {
            return this.entityType != null ? this.entityType : (this.entitySet != null ? this.entitySet.getType() : null);
        }

        @Override
        public String getEntitySetName() {
            return this.entitySet.getName();
        }

        @Override
        public OEntityKey getEntityKey() {
            return this.entityKey;
        }

        @Override
        public List<OProperty<?>> getProperties() {
            return this.properties;
        }

        @Override
        public OProperty<?> getProperty(String propName) {
            return Enumerable.create(this.properties).first(OPredicates.propertyNameEquals(propName));
        }

        @Override
        public <T> OProperty<T> getProperty(String propName, Class<T> propClass) {
            return this.getProperty(propName);
        }

        @Override
        public List<OLink> getLinks() {
            return this.links;
        }

        @Override
        public <T extends OLink> T getLink(String title, Class<T> linkClass) {
            for (OLink link : this.getLinks()) {
                if (!link.getTitle().equals(title)) continue;
                return (T)link;
            }
            throw new IllegalArgumentException("No link with title: " + title);
        }

        @Override
        public EdmType getType() {
            return this.entitySet.getType();
        }

        @Override
        public <TExtension extends OExtension<OEntity>> TExtension findExtension(Class<TExtension> clazz) {
            for (Object extension : this.extensions) {
                if (!clazz.isInstance(extension)) continue;
                return (TExtension)((OExtension)clazz.cast(extension));
            }
            return null;
        }
    }

    private static class OEntityAtomImpl
    extends OEntityImpl
    implements AtomInfo {
        private final String title;
        private final String categoryTerm;

        public OEntityAtomImpl(EdmEntitySet entitySet, EdmEntityType entityType, OEntityKey entityKey, boolean entityKeyRequired, List<OProperty<?>> properties, List<OLink> links, String title, String categoryTerm) {
            super(entitySet, entityType, entityKey, entityKeyRequired, properties, links, new Object[0]);
            this.title = title;
            this.categoryTerm = categoryTerm;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getCategoryTerm() {
            return this.categoryTerm;
        }
    }
}

