/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.core;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.core4j.Enumerable;
import org.core4j.Func1;
import org.odata4j.core.NamedValue;
import org.odata4j.core.NamedValues;
import org.odata4j.core.OComparators;
import org.odata4j.core.OEntityId;
import org.odata4j.core.OFuncs;
import org.odata4j.core.OPredicates;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.Expression;
import org.odata4j.expression.ExpressionParser;
import org.odata4j.expression.LiteralExpression;

public class OEntityKey {
    private final Object[] values;
    private final String keyString;
    private static final Set<Class<?>> EDM_SIMPLE_JAVA_TYPES = Enumerable.create(EdmSimpleType.ALL).selectMany(new Func1<EdmSimpleType<?>, Enumerable<Class<?>>>(){

        @Override
        public Enumerable<Class<?>> apply(EdmSimpleType<?> input) {
            return Enumerable.create(input.getJavaTypes());
        }
    }).toSet();

    private OEntityKey(Object[] values) {
        this.values = values;
        this.keyString = OEntityKey.keyString(values);
    }

    public static OEntityKey create(Object ... values) {
        if (values != null && values.length == 1 && values[0] instanceof Iterable) {
            return OEntityKey.create(Enumerable.create((Iterable)values[0]).toArray(Object.class));
        }
        if (values != null && values.length == 1 && values[0] instanceof OEntityKey) {
            return (OEntityKey)values[0];
        }
        if (values != null && values.length == 1 && values[0] instanceof OEntityId) {
            return ((OEntityId)values[0]).getEntityKey();
        }
        if (values != null && values.length > 1 && values.length % 2 == 0 && values[0] instanceof String) {
            HashMap<String, Object> rt = new HashMap<String, Object>();
            for (int i = 0; i < values.length; i += 2) {
                String name = (String)values[i];
                Object value = values[i + 1];
                rt.put(name, value);
            }
            return OEntityKey.create(rt);
        }
        Object[] v = OEntityKey.validate(values);
        return new OEntityKey(v);
    }

    public static OEntityKey create(Map<String, Object> values) {
        return OEntityKey.create(NamedValues.fromMap(values));
    }

    public static OEntityKey infer(EdmEntitySet entitySet, List<OProperty<?>> props) {
        String idProp;
        if (entitySet == null) {
            throw new IllegalArgumentException("EdmEntitySet cannot be null");
        }
        if (props == null) {
            throw new IllegalArgumentException("props cannot be null");
        }
        EdmEntityType eet = entitySet.getType();
        if (eet == null) {
            throw new IllegalArgumentException("EdmEntityType cannot be null");
        }
        List<String> keys = eet.getKeys();
        if (keys.size() == 0 && (idProp = Enumerable.create(eet.getProperties()).select(OFuncs.name(EdmProperty.class)).firstOrNull(OPredicates.equalsIgnoreCase("id"))) != null) {
            keys.add(idProp);
        }
        Object[] v = new Object[keys.size()];
        for (int i = 0; i < v.length; ++i) {
            String keyPropertyName = keys.get(i);
            v[i] = OEntityKey.getProp(props, keyPropertyName);
        }
        v = OEntityKey.validate(v);
        return new OEntityKey(v);
    }

    public static OEntityKey parse(String keyString) {
        if (keyString == null) {
            throw new IllegalArgumentException("keyString cannot be null");
        }
        if ((keyString = keyString.trim()).startsWith("(") && keyString.endsWith(")")) {
            keyString = keyString.substring(1, keyString.length() - 1);
        }
        if ((keyString = keyString.trim()).length() == 0) {
            throw new IllegalArgumentException("keyString cannot be blank");
        }
        String[] tokens = OEntityKey.tokens(keyString, ',');
        ArrayList<NamedValue<Object>> values = new ArrayList<NamedValue<Object>>(tokens.length);
        for (String token : tokens) {
            String[] nv = OEntityKey.tokens(token, '=');
            if (nv.length != 1 && nv.length != 2) {
                throw new IllegalArgumentException("bad keyString: " + keyString);
            }
            String valueString = nv.length == 1 ? nv[0] : nv[1];
            try {
                CommonExpression expr = ExpressionParser.parse(valueString);
                LiteralExpression literal = (LiteralExpression)expr;
                NamedValue<Object> value = Expression.literalValue(literal);
                values.add(nv.length == 1 ? value : NamedValues.create(nv[0], value));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("bad valueString [%s] as part of keyString [%s]", valueString, keyString), e);
            }
        }
        return OEntityKey.create(values);
    }

    private static String[] tokens(String ks, char sep) {
        ArrayList<String> rt = new ArrayList<String>();
        boolean inString = false;
        int start = 0;
        for (int i = 0; i < ks.length(); ++i) {
            char next;
            char c = ks.charAt(i);
            if (c == sep && !inString) {
                rt.add(ks.substring(start, i));
                start = i + 1;
                continue;
            }
            if (c != '\'') continue;
            if (!inString) {
                inString = true;
                continue;
            }
            if (i < ks.length() - 1 && (next = ks.charAt(i + 1)) == '\'') {
                ++i;
                continue;
            }
            inString = false;
        }
        rt.add(ks.substring(start, ks.length()));
        return rt.toArray(new String[rt.size()]);
    }

    public String toString() {
        return this.toKeyString();
    }

    public String toKeyString() {
        return this.keyString;
    }

    public String toKeyStringWithoutParentheses() {
        String keyString = this.keyString;
        if (keyString.startsWith("(") && keyString.endsWith(")")) {
            keyString = keyString.substring(1, keyString.length() - 1);
        }
        return keyString;
    }

    public int hashCode() {
        return this.keyString.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof OEntityKey && ((OEntityKey)obj).keyString.equals(this.keyString);
    }

    public Object asSingleValue() {
        if (this.values.length > 1) {
            throw new RuntimeException("Complex key cannot be represented as a single value");
        }
        return this.values[0];
    }

    public Set<NamedValue<?>> asComplexValue() {
        this.assertComplex();
        return OEntityKey.toSortedSet(Enumerable.create(this.values).cast(NamedValue.class), OComparators.namedValueByNameRaw());
    }

    public Set<OProperty<?>> asComplexProperties() {
        this.assertComplex();
        return OEntityKey.toSortedSet(Enumerable.create(this.values).cast(NamedValue.class).select(OFuncs.namedValueToPropertyRaw()), OComparators.propertyByName());
    }

    private static <T> SortedSet<T> toSortedSet(Enumerable<T> enumerable, Comparator<T> comparator) {
        TreeSet<T> rt = new TreeSet<T>(comparator);
        rt.addAll(enumerable.toSet());
        return rt;
    }

    private void assertComplex() {
        if (this.values.length == 1) {
            throw new RuntimeException("Single-valued key cannot be represented as a complex value");
        }
    }

    public KeyType getKeyType() {
        return this.values.length == 1 ? KeyType.SINGLE : KeyType.COMPLEX;
    }

    private static OProperty<?> getProp(List<OProperty<?>> props, String name) {
        for (OProperty<?> prop : props) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        throw new IllegalArgumentException(String.format("Property %s not found in %s", name, props));
    }

    private static Object[] validate(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("Key values cannot be null");
        }
        for (Object value : values) {
            if (value != null) continue;
            throw new IllegalArgumentException("Key values cannot be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Key values cannot be empty");
        }
        if (values.length == 1) {
            Object o = values[0];
            if (o instanceof NamedValue) {
                o = ((NamedValue)o).getValue();
            }
            OEntityKey.assertSimple(o);
            return new Object[]{o};
        }
        Object[] v = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object o = values[i];
            if (!(o instanceof NamedValue)) {
                throw new IllegalArgumentException("Complex key values must be named");
            }
            NamedValue nv = (NamedValue)o;
            if (nv.getName() == null || nv.getName().length() == 0) {
                throw new IllegalArgumentException("Complex key values must be named");
            }
            if (nv.getValue() == null) {
                throw new IllegalArgumentException("Complex key values cannot be null");
            }
            OEntityKey.assertSimple(nv.getValue());
            v[i] = NamedValues.copy(nv);
        }
        return v;
    }

    private static void assertSimple(Object o) {
        if (!EDM_SIMPLE_JAVA_TYPES.contains(o.getClass())) {
            throw new IllegalArgumentException("Key value must be a simple type, found: " + o.getClass().getName());
        }
    }

    private static String keyString(Object[] values) {
        String keyValue = values.length == 1 ? OEntityKey.keyString(values[0], false) : Enumerable.create(values).select(new Func1<Object, String>(){

            @Override
            public String apply(Object input) {
                return OEntityKey.keyString(input, true);
            }
        }).orderBy().join(",");
        return "(" + keyValue + ")";
    }

    private static String keyString(Object keyValue, boolean includePropName) {
        if (keyValue instanceof NamedValue) {
            NamedValue namedValue = (NamedValue)keyValue;
            String value = OEntityKey.keyString(namedValue.getValue(), false);
            if (includePropName) {
                return namedValue.getName() + "=" + value;
            }
            return value;
        }
        LiteralExpression expr = Expression.literal(keyValue);
        return Expression.asFilterString(expr);
    }

    public static enum KeyType {
        SINGLE,
        COMPLEX;

    }
}

