/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.core;

import java.math.BigDecimal;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.odata4j.core.Guid;
import org.odata4j.core.OSimpleObject;
import org.odata4j.core.UnsignedByte;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.internal.InternalUtil;
import org.odata4j.internal.TypeConverter;
import org.odata4j.repack.org.apache.commons.codec.binary.Base64;
import org.odata4j.repack.org.apache.commons.codec.binary.Hex;

public class OSimpleObjects {
    private OSimpleObjects() {
    }

    public static <T> OSimpleObject<T> create(EdmSimpleType<T> type, Object value) {
        if (type == EdmSimpleType.STRING) {
            String sValue = null;
            if (value != null) {
                sValue = value instanceof Character ? value.toString() : (String)value;
            }
            return Impl.create(EdmSimpleType.STRING, sValue);
        }
        if (type == EdmSimpleType.BOOLEAN) {
            Boolean bValue = (Boolean)value;
            return Impl.create(EdmSimpleType.BOOLEAN, bValue);
        }
        if (type == EdmSimpleType.INT16) {
            Short sValue = (Short)value;
            return Impl.create(EdmSimpleType.INT16, sValue);
        }
        if (type == EdmSimpleType.INT32) {
            Integer iValue = (Integer)value;
            return Impl.create(EdmSimpleType.INT32, iValue);
        }
        if (type == EdmSimpleType.INT64) {
            Long iValue = (Long)value;
            return Impl.create(EdmSimpleType.INT64, iValue);
        }
        if (type == EdmSimpleType.BYTE) {
            UnsignedByte bValue = (UnsignedByte)value;
            return Impl.create(EdmSimpleType.BYTE, bValue);
        }
        if (type == EdmSimpleType.SBYTE) {
            Byte bValue = (Byte)value;
            return Impl.create(EdmSimpleType.SBYTE, bValue);
        }
        if (type == EdmSimpleType.DECIMAL) {
            BigDecimal dValue = (BigDecimal)value;
            return Impl.create(EdmSimpleType.DECIMAL, dValue);
        }
        if (type == EdmSimpleType.DATETIME) {
            LocalDateTime ldtValue = TypeConverter.convert(value, LocalDateTime.class);
            return Impl.create(EdmSimpleType.DATETIME, ldtValue);
        }
        if (type == EdmSimpleType.TIME) {
            LocalTime ltValue = TypeConverter.convert(value, LocalTime.class);
            return Impl.create(EdmSimpleType.TIME, ltValue);
        }
        if (type == EdmSimpleType.BINARY) {
            byte[] bValue = (byte[])value;
            return Impl.create(EdmSimpleType.BINARY, bValue);
        }
        if (type == EdmSimpleType.DOUBLE) {
            Double dValue = (Double)value;
            return Impl.create(EdmSimpleType.DOUBLE, dValue);
        }
        if (type == EdmSimpleType.SINGLE) {
            Float fValue = (Float)value;
            return Impl.create(EdmSimpleType.SINGLE, fValue);
        }
        if (type == EdmSimpleType.GUID) {
            Guid gValue = TypeConverter.convert(value, Guid.class);
            return Impl.create(EdmSimpleType.GUID, gValue);
        }
        if (type == EdmSimpleType.DATETIMEOFFSET) {
            DateTime dtValue = (DateTime)value;
            return Impl.create(EdmSimpleType.DATETIMEOFFSET, dtValue);
        }
        throw new UnsupportedOperationException("Implement " + type);
    }

    public static <V> OSimpleObject<V> parse(EdmSimpleType<V> type, String value) {
        if (EdmSimpleType.GUID.equals(type)) {
            Guid uValue = value == null ? null : Guid.fromString(value);
            return Impl.create(EdmSimpleType.GUID, uValue);
        }
        if (EdmSimpleType.BOOLEAN.equals(type)) {
            Boolean bValue = value == null ? null : Boolean.valueOf(Boolean.parseBoolean(value));
            return Impl.create(EdmSimpleType.BOOLEAN, bValue);
        }
        if (EdmSimpleType.BYTE.equals(type)) {
            UnsignedByte bValue = value == null ? null : UnsignedByte.parseUnsignedByte(value);
            return Impl.create(EdmSimpleType.BYTE, bValue);
        }
        if (EdmSimpleType.SBYTE.equals(type)) {
            Byte bValue = value == null ? null : Byte.valueOf(Byte.parseByte(value));
            return Impl.create(EdmSimpleType.SBYTE, bValue);
        }
        if (EdmSimpleType.INT16.equals(type)) {
            Short sValue = value == null ? null : Short.valueOf(Short.parseShort(value));
            return Impl.create(EdmSimpleType.INT16, sValue);
        }
        if (EdmSimpleType.INT32.equals(type)) {
            Integer iValue = value == null ? null : Integer.valueOf(Integer.parseInt(value));
            return Impl.create(EdmSimpleType.INT32, iValue);
        }
        if (EdmSimpleType.INT64.equals(type)) {
            Long lValue = value == null ? null : Long.valueOf(Long.parseLong(value));
            return Impl.create(EdmSimpleType.INT64, lValue);
        }
        if (EdmSimpleType.SINGLE.equals(type)) {
            Float fValue = value == null ? null : Float.valueOf(Float.parseFloat(value));
            return Impl.create(EdmSimpleType.SINGLE, fValue);
        }
        if (EdmSimpleType.DOUBLE.equals(type)) {
            Double dValue = value == null ? null : Double.valueOf(Double.parseDouble(value));
            return Impl.create(EdmSimpleType.DOUBLE, dValue);
        }
        if (EdmSimpleType.DECIMAL.equals(type)) {
            BigDecimal dValue = value == null ? null : new BigDecimal(value);
            return Impl.create(EdmSimpleType.DECIMAL, dValue);
        }
        if (EdmSimpleType.BINARY.equals(type)) {
            byte[] bValue = new Base64().decode(value);
            return Impl.create(EdmSimpleType.BINARY, bValue);
        }
        if (EdmSimpleType.DATETIME.equals(type)) {
            LocalDateTime dValue = value == null ? null : new LocalDateTime((Object)InternalUtil.parseDateTime(value));
            return Impl.create(EdmSimpleType.DATETIME, dValue);
        }
        if (EdmSimpleType.DATETIMEOFFSET.equals(type)) {
            return Impl.create(EdmSimpleType.DATETIMEOFFSET, InternalUtil.parseDateTime(value));
        }
        if (EdmSimpleType.TIME.equals(type)) {
            LocalTime tValue = value == null ? null : InternalUtil.parseTime(value);
            return Impl.create(EdmSimpleType.TIME, tValue);
        }
        if (EdmSimpleType.STRING.equals(type)) {
            return Impl.create(EdmSimpleType.STRING, value);
        }
        throw new UnsupportedOperationException("type:" + type);
    }

    public static String getValueDisplayString(Object value) {
        if (value instanceof byte[]) {
            value = "0x" + Hex.encodeHexString((byte[])value);
        }
        return value == null ? "null" : value.toString();
    }

    private static class Impl<V>
    implements OSimpleObject<V> {
        private final EdmSimpleType<V> type;
        private final V value;

        private Impl(EdmSimpleType<V> type, V value) {
            this.type = type;
            this.value = value;
        }

        private static <V> Impl<V> create(EdmSimpleType<V> type, V value) {
            return new Impl<V>(type, value);
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public EdmSimpleType<V> getType() {
            return this.type;
        }

        public String toString() {
            return OSimpleObjects.getValueDisplayString(this.value);
        }
    }
}

