/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.cxf.consumer;

import java.net.URLDecoder;
import java.util.Iterator;
import org.apache.http.HttpResponse;
import org.core4j.Enumerable;
import org.core4j.Func;
import org.core4j.Func1;
import org.core4j.ReadOnlyIterator;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.core.ODataVersion;
import org.odata4j.cxf.consumer.CxfConsumerQueryRequestBase;
import org.odata4j.cxf.consumer.ODataCxfClient;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.format.Entry;
import org.odata4j.format.Feed;
import org.odata4j.format.FormatParser;
import org.odata4j.format.FormatParserFactory;
import org.odata4j.format.FormatType;
import org.odata4j.format.Settings;
import org.odata4j.internal.FeedCustomizationMapping;
import org.odata4j.internal.InternalUtil;

class CxFConsumerQueryEntitiesRequest<T>
extends CxfConsumerQueryRequestBase<T> {
    private final Class<T> entityType;
    private final FeedCustomizationMapping fcMapping;

    CxFConsumerQueryEntitiesRequest(FormatType formatType, Class<T> entityType, String serviceRootUri, EdmDataServices metadata, String entitySetName, FeedCustomizationMapping fcMapping) {
        super(formatType, serviceRootUri, metadata, entitySetName);
        this.entityType = entityType;
        this.fcMapping = fcMapping;
    }

    @Override
    public Enumerable<T> execute() {
        ODataClientRequest request = this.buildRequest(null);
        Enumerable<Entry> entries = this.getEntries(request);
        return entries.select(new Func1<Entry, T>(){

            @Override
            public T apply(Entry input) {
                return InternalUtil.toEntity(CxFConsumerQueryEntitiesRequest.this.entityType, input.getEntity());
            }
        }).cast(this.entityType);
    }

    private Enumerable<Entry> getEntries(final ODataClientRequest request) {
        return Enumerable.createFromIterator(new Func<Iterator<Entry>>(){

            @Override
            public Iterator<Entry> apply() {
                return new EntryIterator(request, CxFConsumerQueryEntitiesRequest.this.getFormatType());
            }
        });
    }

    private class EntryIterator
    extends ReadOnlyIterator<Entry> {
        private FormatType formatType;
        private ODataClientRequest request;
        private FormatParser<Feed> parser;
        private Feed feed;
        private Iterator<Entry> feedEntries;
        private int feedEntryCount;

        public EntryIterator(ODataClientRequest request, FormatType formatType) {
            this.request = request;
            this.formatType = formatType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ReadOnlyIterator.IterationResult<Entry> advance() throws Exception {
            ODataCxfClient client = new ODataCxfClient(this.formatType);
            try {
                ReadOnlyIterator.IterationResult<Entry> response;
                if (this.feed == null) {
                    response = client.getEntities(this.request);
                    ODataVersion version = InternalUtil.getDataServiceVersion(response.getFirstHeader("DataServiceVersion").getValue());
                    this.parser = FormatParserFactory.getParser(Feed.class, client.getFormatType(), new Settings(version, CxFConsumerQueryEntitiesRequest.this.getMetadata(), CxFConsumerQueryEntitiesRequest.this.getLastSegment(), null, CxFConsumerQueryEntitiesRequest.this.fcMapping));
                    this.feed = this.parser.parse(client.getFeedReader((HttpResponse)((Object)response)));
                    this.feedEntries = this.feed.getEntries().iterator();
                    this.feedEntryCount = 0;
                }
                if (this.feedEntries.hasNext()) {
                    ++this.feedEntryCount;
                    response = ReadOnlyIterator.IterationResult.next(this.feedEntries.next());
                    return response;
                }
                if (this.request.getQueryParams().containsKey("$page") && this.request.getQueryParams().containsKey("$itemsPerPage")) {
                    if (this.feedEntryCount == 0) {
                        response = ReadOnlyIterator.IterationResult.done();
                        return response;
                    }
                    int page = Integer.parseInt(this.request.getQueryParams().get("$page"));
                    this.request = this.request.queryParam("$page", Integer.toString(page + 1));
                } else {
                    if (this.feed.getNext() == null) {
                        ReadOnlyIterator.IterationResult<Entry> page = ReadOnlyIterator.IterationResult.done();
                        return page;
                    }
                    int skipTokenIndex = this.feed.getNext().indexOf("$skiptoken=");
                    if (skipTokenIndex > -1) {
                        String skiptoken = this.feed.getNext().substring(skipTokenIndex + "$skiptoken=".length());
                        skiptoken = URLDecoder.decode(skiptoken, "UTF-8");
                        this.request = this.request.queryParam("$skiptoken", skiptoken);
                    } else if (this.feed.getNext().toLowerCase().startsWith("http")) {
                        this.request = ODataClientRequest.get(this.feed.getNext());
                    } else {
                        throw new UnsupportedOperationException();
                    }
                }
                this.feed = null;
                ReadOnlyIterator.IterationResult<Entry> iterationResult = this.advance();
                return iterationResult;
            }
            finally {
                client.shuttdown();
            }
        }
    }
}

