/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.cxf.consumer;

import java.util.Arrays;
import org.apache.http.HttpResponse;
import org.odata4j.consumer.AbstractConsumerEntityPayloadRequest;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.core.OCreateRequest;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OLinks;
import org.odata4j.core.OProperty;
import org.odata4j.core.Throwables;
import org.odata4j.cxf.consumer.ODataCxfClient;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.format.Entry;
import org.odata4j.format.FormatParser;
import org.odata4j.format.FormatParserFactory;
import org.odata4j.format.FormatType;
import org.odata4j.format.Settings;
import org.odata4j.internal.FeedCustomizationMapping;
import org.odata4j.internal.InternalUtil;

class CxfConsumerCreateEntityRequest<T>
extends AbstractConsumerEntityPayloadRequest
implements OCreateRequest<T> {
    private final FormatType formatType;
    private OEntity parent;
    private String navProperty;
    private final FeedCustomizationMapping fcMapping;

    CxfConsumerCreateEntityRequest(FormatType formatType, String serviceRootUri, EdmDataServices metadata, String entitySetName, FeedCustomizationMapping fcMapping) {
        super(entitySetName, serviceRootUri, metadata);
        this.formatType = formatType;
        this.fcMapping = fcMapping;
    }

    @Override
    public T execute() {
        ODataCxfClient client = new ODataCxfClient(this.formatType);
        try {
            EdmEntitySet ees = this.metadata.getEdmEntitySet(this.entitySetName);
            Entry entry = client.createRequestEntry(ees, null, this.props, this.links);
            StringBuilder url = new StringBuilder(this.serviceRootUri);
            if (this.parent != null) {
                url.append(InternalUtil.getEntityRelId(this.parent)).append("/").append(this.navProperty);
            } else {
                url.append(this.entitySetName);
            }
            ODataClientRequest request = ODataClientRequest.post(url.toString(), entry);
            HttpResponse response = client.createEntity(request);
            ODataVersion version = InternalUtil.getDataServiceVersion(response.getFirstHeader("DataServiceVersion").getValue());
            FormatParser<Entry> parser = FormatParserFactory.getParser(Entry.class, client.getFormatType(), new Settings(version, this.metadata, this.entitySetName, null, this.fcMapping));
            entry = parser.parse(client.getFeedReader(response));
            OEntity oEntity = entry.getEntity();
            return (T)oEntity;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
        finally {
            client.shuttdown();
        }
    }

    @Override
    public T get() {
        EdmEntitySet entitySet = this.metadata.getEdmEntitySet(this.entitySetName);
        return (T)OEntities.createRequest(entitySet, this.props, this.links);
    }

    @Override
    public OCreateRequest<T> properties(OProperty<?> ... props) {
        return super.properties(this, props);
    }

    @Override
    public OCreateRequest<T> properties(Iterable<OProperty<?>> props) {
        return super.properties(this, props);
    }

    @Override
    public OCreateRequest<T> link(String navProperty, OEntity target) {
        return super.link(this, navProperty, target);
    }

    @Override
    public OCreateRequest<T> link(String navProperty, OEntityKey targetKey) {
        return super.link(this, navProperty, targetKey);
    }

    @Override
    public OCreateRequest<T> addToRelation(OEntity parent, String navProperty) {
        if (parent == null || navProperty == null) {
            throw new IllegalArgumentException("please provide the parent and the navProperty");
        }
        this.parent = parent;
        this.navProperty = navProperty;
        return this;
    }

    @Override
    public OCreateRequest<T> inline(String navProperty, OEntity ... entities) {
        EdmEntitySet entitySet = this.metadata.getEdmEntitySet(this.entitySetName);
        EdmNavigationProperty navProp = entitySet.getType().findNavigationProperty(navProperty);
        if (navProp == null) {
            throw new IllegalArgumentException("unknown navigation property " + navProperty);
        }
        String rel = "http://schemas.microsoft.com/ado/2007/08/dataservices/related/" + navProperty;
        String href = this.entitySetName + "/" + navProperty;
        if (navProp.getToRole().getMultiplicity() == EdmMultiplicity.MANY) {
            this.links.add(OLinks.relatedEntitiesInline(rel, navProperty, href, Arrays.asList(entities)));
        } else {
            if (entities.length > 1) {
                throw new IllegalArgumentException("only one entity is allowed for this navigation property " + navProperty);
            }
            this.links.add(OLinks.relatedEntityInline(rel, navProperty, href, entities.length > 0 ? entities[0] : null));
        }
        return this;
    }
}

