/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.cxf.consumer;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.core4j.Enumerable;
import org.core4j.Func;
import org.core4j.ReadOnlyIterator;
import org.joda.time.LocalDateTime;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.core.Guid;
import org.odata4j.core.OCollection;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OFunctionParameter;
import org.odata4j.core.OFunctionParameters;
import org.odata4j.core.OFunctionRequest;
import org.odata4j.core.OObject;
import org.odata4j.core.OSimpleObject;
import org.odata4j.core.OSimpleObjects;
import org.odata4j.core.UnsignedByte;
import org.odata4j.cxf.consumer.CxfConsumerQueryRequestBase;
import org.odata4j.cxf.consumer.ODataCxfClient;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.expression.Expression;
import org.odata4j.expression.LiteralExpression;
import org.odata4j.format.FormatParser;
import org.odata4j.format.FormatParserFactory;
import org.odata4j.format.FormatType;
import org.odata4j.format.Settings;
import org.odata4j.internal.InternalUtil;

class CxfConsumerFunctionCallRequest<T extends OObject>
extends CxfConsumerQueryRequestBase<T>
implements OFunctionRequest<T> {
    private final List<OFunctionParameter> params = new LinkedList<OFunctionParameter>();
    private final EdmFunctionImport function;

    CxfConsumerFunctionCallRequest(FormatType formatType, String serviceRootUri, EdmDataServices metadata, String lastSegment) {
        super(formatType, serviceRootUri, metadata, lastSegment);
        this.function = metadata.findEdmFunctionImport(lastSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumerable<T> execute() {
        final ODataCxfClient client = new ODataCxfClient(this.getFormatType());
        try {
            Enumerable<OObject> results;
            for (OFunctionParameter p : this.params) {
                this.custom(p.getName(), CxfConsumerFunctionCallRequest.toUriString(p));
            }
            final ODataClientRequest request = this.buildRequest(null);
            Enumerable<OObject> enumerable = results = Enumerable.createFromIterator(new Func<Iterator<OObject>>(){

                @Override
                public Iterator<OObject> apply() {
                    return new FunctionResultsIterator(client, request);
                }
            });
            return enumerable;
        }
        finally {
            client.shuttdown();
        }
    }

    private static String toUriString(OFunctionParameter p) {
        OObject obj = (OObject)p.getValue();
        if (obj instanceof OSimpleObject) {
            OSimpleObject simple = (OSimpleObject)obj;
            LiteralExpression le = Expression.literal(simple.getType(), simple.getValue());
            return Expression.asFilterString(le);
        }
        throw new UnsupportedOperationException("type not supported: " + obj.getType().getFullyQualifiedTypeName());
    }

    @Override
    public CxfConsumerFunctionCallRequest<T> parameter(String name, OObject value) {
        this.params.add(OFunctionParameters.create(name, value));
        return this;
    }

    @Override
    public OFunctionRequest<T> pBoolean(String name, boolean value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.BOOLEAN, value));
    }

    @Override
    public OFunctionRequest<T> pByte(String name, UnsignedByte value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.BYTE, value));
    }

    @Override
    public OFunctionRequest<T> pSByte(String name, byte value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.SBYTE, value));
    }

    @Override
    public OFunctionRequest<T> pDateTime(String name, Calendar value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.DATETIME, value));
    }

    @Override
    public OFunctionRequest<T> pDateTime(String name, Date value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.DATETIME, value));
    }

    @Override
    public OFunctionRequest<T> pDateTime(String name, LocalDateTime value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.DATETIME, value));
    }

    @Override
    public OFunctionRequest<T> pDecimal(String name, BigDecimal value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.DECIMAL, value));
    }

    @Override
    public OFunctionRequest<T> pDouble(String name, double value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.DOUBLE, value));
    }

    @Override
    public OFunctionRequest<T> pGuid(String name, Guid value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.GUID, value));
    }

    @Override
    public OFunctionRequest<T> pInt16(String name, short value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.INT16, value));
    }

    @Override
    public OFunctionRequest<T> pInt32(String name, int value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.INT32, value));
    }

    @Override
    public OFunctionRequest<T> pInt64(String name, long value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.INT64, value));
    }

    @Override
    public OFunctionRequest<T> pSingle(String name, float value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.SINGLE, Float.valueOf(value)));
    }

    @Override
    public OFunctionRequest<T> pTime(String name, Calendar value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.TIME, value));
    }

    @Override
    public OFunctionRequest<T> pTime(String name, Date value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.TIME, value));
    }

    @Override
    public OFunctionRequest<T> pTime(String name, LocalDateTime value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.TIME, value));
    }

    @Override
    public OFunctionRequest<T> pString(String name, String value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.STRING, value));
    }

    private class FunctionResultsIterator
    extends ReadOnlyIterator<OObject> {
        private ODataCxfClient client;
        private ODataClientRequest request;
        private FormatParser<? extends OObject> parser;
        private OObject current = null;
        private Iterator<OObject> iter = null;
        private boolean done = false;
        private int count = 0;

        public FunctionResultsIterator(ODataCxfClient client, ODataClientRequest request) {
            this.client = client;
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ReadOnlyIterator.IterationResult<OObject> advance() throws Exception {
            try {
                ReadOnlyIterator.IterationResult<OObject> iterationResult;
                if (this.done || CxfConsumerFunctionCallRequest.this.function.getReturnType() == null) {
                    ReadOnlyIterator.IterationResult<OObject> iterationResult2 = ReadOnlyIterator.IterationResult.done();
                    return iterationResult2;
                }
                if (this.current == null) {
                    HttpResponse response = this.client.callFunction(this.request);
                    ODataVersion version = InternalUtil.getDataServiceVersion(response.getFirstHeader("DataServiceVersion").getValue());
                    this.parser = FormatParserFactory.getParser(EdmType.getInstanceType(CxfConsumerFunctionCallRequest.this.function.getReturnType()), this.client.getFormatType(), new Settings(version, CxfConsumerFunctionCallRequest.this.getMetadata(), CxfConsumerFunctionCallRequest.this.getLastSegment(), null, null, true, CxfConsumerFunctionCallRequest.this.function.getReturnType()));
                    this.current = this.parser.parse(this.client.getFeedReader(response));
                    if (CxfConsumerFunctionCallRequest.this.function.getReturnType() instanceof EdmCollectionType) {
                        this.iter = ((OCollection)this.current).iterator();
                    } else {
                        this.done = true;
                        ReadOnlyIterator.IterationResult<OObject> iterationResult3 = ReadOnlyIterator.IterationResult.next(this.current);
                        return iterationResult3;
                    }
                }
                if (this.iter.hasNext()) {
                    ++this.count;
                    iterationResult = ReadOnlyIterator.IterationResult.next(this.iter.next());
                    return iterationResult;
                }
                this.done = true;
                iterationResult = ReadOnlyIterator.IterationResult.done();
                return iterationResult;
            }
            finally {
                this.client.shuttdown();
            }
        }
    }
}

