/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.cxf.producer.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.apache.cxf.jaxrs.servlet.CXFNonSpringJaxrsServlet;
import org.core4j.Enumerable;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.odata4j.core.Throwables;
import org.odata4j.producer.server.ODataServer;

public class CxfJettyServer
implements ODataServer {
    private String appBaseUri;
    private Class<? extends Application> odataApp;
    private Class<? extends Application> rootApp;
    private final List<Handler> jettyRequestHandlers = new ArrayList<Handler>();
    private Server server;

    public CxfJettyServer(String appBaseUri) {
        this.appBaseUri = appBaseUri;
    }

    public CxfJettyServer(String appBaseUri, Class<? extends Application> odataApp, Class<? extends Application> rootApp) {
        this.appBaseUri = appBaseUri;
        this.odataApp = odataApp;
        this.rootApp = rootApp;
    }

    @Override
    public ODataServer setODataApplication(Class<? extends Application> odataApp) {
        this.odataApp = odataApp;
        return this;
    }

    @Override
    public ODataServer setRootApplication(Class<? extends Application> rootApp) {
        this.rootApp = rootApp;
        return this;
    }

    public CxfJettyServer addJettyRequestHandler(Handler handler) {
        this.jettyRequestHandlers.add(handler);
        return this;
    }

    @Override
    public ODataServer start() {
        URL url;
        if (this.odataApp == null) {
            throw new RuntimeException("ODataApplication not set");
        }
        try {
            url = new URL(this.appBaseUri);
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate(e);
        }
        CXFNonSpringJaxrsServlet odataServlet = new CXFNonSpringJaxrsServlet();
        ServletHolder odataServletHolder = new ServletHolder((Servlet)odataServlet);
        odataServletHolder.setInitParameter("javax.ws.rs.Application", this.odataApp.getCanonicalName());
        ServletContextHandler contextHandler = new ServletContextHandler(1);
        contextHandler.addServlet(odataServletHolder, CxfJettyServer.normalizePath(url.getPath()) + "/*");
        if (this.rootApp != null) {
            CXFNonSpringJaxrsServlet rootServlet = new CXFNonSpringJaxrsServlet();
            ServletHolder rootServletHolder = new ServletHolder((Servlet)rootServlet);
            rootServletHolder.setInitParameter("javax.ws.rs.Application", this.rootApp.getCanonicalName());
            contextHandler.addServlet(rootServletHolder, "/*");
        }
        this.server = new Server(url.getPort());
        this.server.setHandler((Handler)this.getHandlerCollection(contextHandler));
        try {
            this.server.start();
            return this;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public ODataServer stop() {
        try {
            this.server.stop();
            return this;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    private static String normalizePath(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private HandlerCollection getHandlerCollection(ServletContextHandler contextHandler) {
        List<Handler> handlers = this.jettyRequestHandlers;
        handlers.add((Handler)contextHandler);
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(Enumerable.create(handlers).toArray(Handler.class));
        return handlerCollection;
    }
}

