/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmItem;
import org.odata4j.edm.EdmPropertyBase;

public class EdmNavigationProperty
extends EdmPropertyBase {
    private final EdmAssociation relationship;
    private final EdmAssociationEnd fromRole;
    private final EdmAssociationEnd toRole;

    private EdmNavigationProperty(String name, EdmAssociation relationship, EdmAssociationEnd fromRole, EdmAssociationEnd toRole) {
        super(null, null, name);
        this.relationship = relationship;
        this.fromRole = fromRole;
        this.toRole = toRole;
    }

    public EdmAssociation getRelationship() {
        return this.relationship;
    }

    public EdmAssociationEnd getFromRole() {
        return this.fromRole;
    }

    public EdmAssociationEnd getToRole() {
        return this.toRole;
    }

    public String toString() {
        return String.format("EdmNavigationProperty[%s,rel=%s,from=%s,to=%s]", this.getName(), this.relationship, this.fromRole, this.toRole);
    }

    public static Builder newBuilder(String name) {
        return new Builder(name);
    }

    static Builder newBuilder(EdmNavigationProperty navigationProperty, EdmItem.BuilderContext context) {
        return context.newBuilder(navigationProperty, new Builder(navigationProperty.getName()));
    }

    public static class Builder
    extends EdmPropertyBase.Builder<EdmNavigationProperty, Builder> {
        private EdmAssociation.Builder relationship;
        private String relationshipName;
        private EdmAssociationEnd.Builder fromRole;
        private String fromRoleName;
        private EdmAssociationEnd.Builder toRole;
        private String toRoleName;

        private Builder(String name) {
            super(name);
        }

        @Override
        Builder newBuilder(EdmNavigationProperty navigationProperty, EdmItem.BuilderContext context) {
            this.relationship = EdmAssociation.newBuilder(navigationProperty.relationship, context);
            this.fromRole = EdmAssociationEnd.newBuilder(navigationProperty.fromRole, context);
            this.toRole = EdmAssociationEnd.newBuilder(navigationProperty.toRole, context);
            return this;
        }

        public Builder setRelationship(EdmAssociation.Builder relationship) {
            this.relationship = relationship;
            return this;
        }

        public Builder setFromTo(EdmAssociationEnd.Builder fromRole, EdmAssociationEnd.Builder toRole) {
            this.fromRole = fromRole;
            this.toRole = toRole;
            return this;
        }

        public EdmNavigationProperty build() {
            return new EdmNavigationProperty(this.getName(), this.relationship.build(), this.fromRole.build(), this.toRole.build());
        }

        public String getRelationshipName() {
            return this.relationshipName;
        }

        public String getFromRoleName() {
            return this.fromRoleName;
        }

        public String getToRoleName() {
            return this.toRoleName;
        }

        public Builder setRelationshipName(String relationshipName) {
            this.relationshipName = relationshipName;
            return this;
        }

        public Builder setFromToName(String fromRoleName, String toRoleName) {
            this.fromRoleName = fromRoleName;
            this.toRoleName = toRoleName;
            return this;
        }
    }
}

