/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.core4j.Enumerable;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.odata4j.core.Guid;
import org.odata4j.core.UnsignedByte;
import org.odata4j.edm.EdmItem;
import org.odata4j.edm.EdmType;

public class EdmSimpleType<V>
extends EdmType {
    private static Set<EdmSimpleType<?>> all = new HashSet();
    public static final EdmSimpleType<byte[]> BINARY = EdmSimpleType.newSimple("Edm.Binary", byte[].class, Byte[].class);
    public static final EdmSimpleType<Boolean> BOOLEAN = EdmSimpleType.newSimple("Edm.Boolean", Boolean.class, Boolean.TYPE);
    public static final EdmSimpleType<UnsignedByte> BYTE = EdmSimpleType.newSimple("Edm.Byte", UnsignedByte.class, new Class[0]);
    public static final EdmSimpleType<Byte> SBYTE = EdmSimpleType.newSimple("Edm.SByte", Byte.class, Byte.TYPE);
    public static final EdmSimpleType<LocalDateTime> DATETIME = EdmSimpleType.newSimple("Edm.DateTime", LocalDateTime.class, new Class[0]);
    public static final EdmSimpleType<DateTime> DATETIMEOFFSET = EdmSimpleType.newSimple("Edm.DateTimeOffset", DateTime.class, new Class[0]);
    public static final EdmSimpleType<BigDecimal> DECIMAL = EdmSimpleType.newSimple("Edm.Decimal", BigDecimal.class, new Class[0]);
    public static final EdmSimpleType<Double> DOUBLE = EdmSimpleType.newSimple("Edm.Double", Double.class, Double.TYPE);
    public static final EdmSimpleType<Guid> GUID = EdmSimpleType.newSimple("Edm.Guid", Guid.class, UUID.class);
    public static final EdmSimpleType<Short> INT16 = EdmSimpleType.newSimple("Edm.Int16", Short.class, Short.TYPE);
    public static final EdmSimpleType<Integer> INT32 = EdmSimpleType.newSimple("Edm.Int32", Integer.class, Integer.TYPE);
    public static final EdmSimpleType<Long> INT64 = EdmSimpleType.newSimple("Edm.Int64", Long.class, Long.TYPE);
    public static final EdmSimpleType<Float> SINGLE = EdmSimpleType.newSimple("Edm.Single", Float.class, Float.TYPE);
    public static final EdmSimpleType<String> STRING = EdmSimpleType.newSimple("Edm.String", String.class, Character.TYPE, Character.class);
    public static final EdmSimpleType<LocalTime> TIME = EdmSimpleType.newSimple("Edm.Time", LocalTime.class, new Class[0]);
    public static final Set<EdmSimpleType<?>> ALL = Collections.unmodifiableSet(all);
    private final Class<V> canonicalJavaType;
    private final Set<Class<?>> javaTypes;

    private static <V> EdmSimpleType<V> newSimple(String typeString, Class<V> canonicalJavaType, Class<?> ... alternateJavaTypes) {
        EdmSimpleType<V> rt = new EdmSimpleType<V>(typeString, canonicalJavaType, alternateJavaTypes);
        all.add(rt);
        return rt;
    }

    private EdmSimpleType(String fullyQualifiedTypeName, Class<V> canonicalJavaType, Class<?> ... alternateJavaTypes) {
        super(fullyQualifiedTypeName);
        this.canonicalJavaType = canonicalJavaType;
        this.javaTypes = Enumerable.create(canonicalJavaType).concat(alternateJavaTypes).toSet();
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    public Class<V> getCanonicalJavaType() {
        return this.canonicalJavaType;
    }

    public Set<Class<?>> getJavaTypes() {
        return this.javaTypes;
    }

    public static <V> EdmSimpleType<V> forJavaType(Class<?> javaType) {
        for (EdmSimpleType<?> simple : ALL) {
            if (!simple.getJavaTypes().contains(javaType)) continue;
            return simple;
        }
        return null;
    }

    public static EdmType.Builder<?, ?> newBuilder(EdmType type) {
        return new Builder(type);
    }

    private static class Builder
    extends EdmType.Builder<EdmType, Builder> {
        private Builder(EdmType type) {
            super(type);
        }

        @Override
        Builder newBuilder(EdmType type, EdmItem.BuilderContext context) {
            return new Builder(type);
        }

        @Override
        public EdmType build() {
            return this._build();
        }

        @Override
        protected EdmType buildImpl() {
            return null;
        }
    }
}

