/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.expression;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.core4j.Enumerable;
import org.core4j.Func1;
import org.core4j.Func2;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.odata4j.core.Guid;
import org.odata4j.core.Throwables;
import org.odata4j.expression.AggregateAnyFunction;
import org.odata4j.expression.AggregateBoolFunction;
import org.odata4j.expression.BoolCommonExpression;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.Expression;
import org.odata4j.expression.OrderByExpression;
import org.odata4j.expression.StringLiteral;
import org.odata4j.internal.InternalUtil;
import org.odata4j.repack.org.apache.commons.codec.DecoderException;
import org.odata4j.repack.org.apache.commons.codec.binary.Hex;

public class ExpressionParser {
    private static Set<String> METHODS = Enumerable.create("cast", "isof", "endswith", "startswith", "substringof", "indexof", "replace", "tolower", "toupper", "trim", "substring", "concat", "length", "year", "month", "day", "hour", "minute", "second", "round", "floor", "ceiling").toSet();
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormat.forPattern((String)"HH:mm:ss");
    public static boolean DUMP_EXPRESSION_INFO = false;

    public static CommonExpression parse(String value) {
        List<Token> tokens = ExpressionParser.tokenize(value);
        CommonExpression rt = ExpressionParser.readExpression(tokens);
        if (DUMP_EXPRESSION_INFO) {
            ExpressionParser.dump(value, tokens, rt);
        }
        return rt;
    }

    public static List<OrderByExpression> parseOrderBy(String value) {
        List<Token> tokens = ExpressionParser.tokenize(value);
        List<CommonExpression> expressions = ExpressionParser.readExpressions(tokens);
        if (DUMP_EXPRESSION_INFO) {
            ExpressionParser.dump(value, tokens, Enumerable.create(expressions).toArray(CommonExpression.class));
        }
        return Enumerable.create(expressions).select(new Func1<CommonExpression, OrderByExpression>(){

            @Override
            public OrderByExpression apply(CommonExpression input) {
                if (input instanceof OrderByExpression) {
                    return (OrderByExpression)input;
                }
                return Expression.orderBy(input, OrderByExpression.Direction.ASCENDING);
            }
        }).toList();
    }

    private static void dump(String value, List<Token> tokens, CommonExpression ... expressions) {
        String msg = "[" + value + "] -> " + Enumerable.create(tokens).join("");
        if (expressions != null) {
            msg = msg + " -> " + Enumerable.create(expressions).select(new Func1<CommonExpression, String>(){

                @Override
                public String apply(CommonExpression input) {
                    return Expression.asPrintString(input);
                }
            }).join(",");
        }
        System.out.println(msg);
    }

    public static List<EntitySimpleProperty> parseExpand(String value) {
        List<Token> tokens = ExpressionParser.tokenize(value);
        List<CommonExpression> expressions = ExpressionParser.readExpressions(tokens);
        return Enumerable.create(expressions).select(new Func1<CommonExpression, EntitySimpleProperty>(){

            @Override
            public EntitySimpleProperty apply(CommonExpression input) {
                if (input instanceof EntitySimpleProperty) {
                    return (EntitySimpleProperty)input;
                }
                return null;
            }
        }).toList();
    }

    private static CommonExpression processBinaryExpression(List<Token> tokens, String op, Func2<CommonExpression, CommonExpression, CommonExpression> fn) {
        int ts = tokens.size();
        for (int i = 0; i < ts; ++i) {
            Token t = tokens.get(i);
            if (i >= ts - 2 || t.type != TokenType.WHITESPACE || tokens.get((int)(i + 2)).type != TokenType.WHITESPACE || tokens.get((int)(i + 1)).type != TokenType.WORD) continue;
            Token wordToken = tokens.get(i + 1);
            if (!wordToken.value.equals(op)) continue;
            CommonExpression lhs = ExpressionParser.readExpression(tokens.subList(0, i));
            CommonExpression rhs = ExpressionParser.readExpression(tokens.subList(i + 3, ts));
            return fn.apply(lhs, rhs);
        }
        return null;
    }

    private static CommonExpression processUnaryExpression(List<Token> tokens, String op, boolean whitespaceRequired, Func1<CommonExpression, CommonExpression> fn) {
        int ts = tokens.size();
        for (int i = 0; i < ts; ++i) {
            Token t = tokens.get(i);
            if (i >= ts - 1 || t.type != TokenType.WORD && t.type != TokenType.SYMBOL || whitespaceRequired && tokens.get((int)(i + 1)).type != TokenType.WHITESPACE) continue;
            Token wordToken = t;
            if (!wordToken.value.equals(op)) continue;
            CommonExpression expression = ExpressionParser.readExpression(tokens.subList(i + (whitespaceRequired ? 2 : 1), ts));
            return fn.apply(expression);
        }
        return null;
    }

    private static CommonExpression methodCall(String methodName, List<CommonExpression> methodArguments) {
        if (methodName.equals("cast") && methodArguments.size() == 1) {
            CommonExpression arg = methodArguments.get(0);
            ExpressionParser.assertType(arg, StringLiteral.class);
            String type = ((StringLiteral)arg).getValue();
            return Expression.cast(type);
        }
        if (methodName.equals("cast") && methodArguments.size() == 2) {
            CommonExpression arg1 = methodArguments.get(0);
            CommonExpression arg2 = methodArguments.get(1);
            ExpressionParser.assertType(arg2, StringLiteral.class);
            String type = ((StringLiteral)arg2).getValue();
            return Expression.cast(arg1, type);
        }
        if (methodName.equals("isof") && methodArguments.size() == 1) {
            CommonExpression arg = methodArguments.get(0);
            ExpressionParser.assertType(arg, StringLiteral.class);
            String type = ((StringLiteral)arg).getValue();
            return Expression.isof(type);
        }
        if (methodName.equals("isof") && methodArguments.size() == 2) {
            CommonExpression arg1 = methodArguments.get(0);
            CommonExpression arg2 = methodArguments.get(1);
            ExpressionParser.assertType(arg2, StringLiteral.class);
            String type = ((StringLiteral)arg2).getValue();
            return Expression.isof(arg1, type);
        }
        if (methodName.equals("endswith") && methodArguments.size() == 2) {
            CommonExpression arg1 = methodArguments.get(0);
            CommonExpression arg2 = methodArguments.get(1);
            return Expression.endsWith(arg1, arg2);
        }
        if (methodName.equals("startswith") && methodArguments.size() == 2) {
            CommonExpression arg1 = methodArguments.get(0);
            CommonExpression arg2 = methodArguments.get(1);
            return Expression.startsWith(arg1, arg2);
        }
        if (methodName.equals("substringof") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.substringOf(arg1);
        }
        if (methodName.equals("substringof") && methodArguments.size() == 2) {
            CommonExpression arg1 = methodArguments.get(0);
            CommonExpression arg2 = methodArguments.get(1);
            return Expression.substringOf(arg1, arg2);
        }
        if (methodName.equals("indexof") && methodArguments.size() == 2) {
            CommonExpression arg1 = methodArguments.get(0);
            CommonExpression arg2 = methodArguments.get(1);
            return Expression.indexOf(arg1, arg2);
        }
        if (methodName.equals("replace") && methodArguments.size() == 3) {
            CommonExpression arg1 = methodArguments.get(0);
            CommonExpression arg2 = methodArguments.get(1);
            CommonExpression arg3 = methodArguments.get(2);
            return Expression.replace(arg1, arg2, arg3);
        }
        if (methodName.equals("tolower") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.toLower(arg1);
        }
        if (methodName.equals("toupper") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.toUpper(arg1);
        }
        if (methodName.equals("trim") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.trim(arg1);
        }
        if (methodName.equals("substring") && methodArguments.size() == 2) {
            CommonExpression arg1 = methodArguments.get(0);
            CommonExpression arg2 = methodArguments.get(1);
            return Expression.substring(arg1, arg2);
        }
        if (methodName.equals("substring") && methodArguments.size() == 3) {
            CommonExpression arg1 = methodArguments.get(0);
            CommonExpression arg2 = methodArguments.get(1);
            CommonExpression arg3 = methodArguments.get(2);
            return Expression.substring(arg1, arg2, arg3);
        }
        if (methodName.equals("concat") && methodArguments.size() == 2) {
            CommonExpression arg1 = methodArguments.get(0);
            CommonExpression arg2 = methodArguments.get(1);
            return Expression.concat(arg1, arg2);
        }
        if (methodName.equals("length") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.length(arg1);
        }
        if (methodName.equals("year") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.year(arg1);
        }
        if (methodName.equals("month") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.month(arg1);
        }
        if (methodName.equals("day") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.day(arg1);
        }
        if (methodName.equals("hour") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.hour(arg1);
        }
        if (methodName.equals("minute") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.minute(arg1);
        }
        if (methodName.equals("second") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.second(arg1);
        }
        if (methodName.equals("ceiling") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.ceiling(arg1);
        }
        if (methodName.equals("floor") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.floor(arg1);
        }
        if (methodName.equals("round") && methodArguments.size() == 1) {
            CommonExpression arg1 = methodArguments.get(0);
            return Expression.round(arg1);
        }
        throw new RuntimeException("Implement method " + methodName);
    }

    private static List<CommonExpression> readExpressions(List<Token> tokens) {
        ArrayList<CommonExpression> rt = new ArrayList<CommonExpression>();
        int stack = 0;
        int start = 0;
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.get(i);
            if (token.type == TokenType.OPENPAREN) {
                ++stack;
                continue;
            }
            if (token.type == TokenType.CLOSEPAREN) {
                --stack;
                continue;
            }
            if (stack == 0 && token.type == TokenType.SYMBOL && token.value.equals(",")) {
                List<Token> tokensInsideComma = tokens.subList(start, i);
                CommonExpression expressionInsideComma = ExpressionParser.readExpression(tokensInsideComma);
                rt.add(expressionInsideComma);
                start = i + 1;
                continue;
            }
            if (i != tokens.size() - 1) continue;
            List<Token> tokensInside = tokens.subList(start, i + 1);
            CommonExpression expressionInside = ExpressionParser.readExpression(tokensInside);
            rt.add(expressionInside);
        }
        return rt;
    }

    public static List<Token> processParentheses(List<Token> tokens) {
        ArrayList<Token> rt = new ArrayList<Token>();
        for (int i = 0; i < tokens.size(); ++i) {
            Token openToken = tokens.get(i);
            if (openToken.type == TokenType.OPENPAREN) {
                int k;
                int afterParenIdx = i + 1;
                String methodName = null;
                String aggregateSource = null;
                String aggregateVariable = null;
                AggregateFunction aggregateFunction = AggregateFunction.none;
                for (k = i - 1; k > 0 && tokens.get((int)k).type == TokenType.WHITESPACE; --k) {
                }
                if (k >= 0) {
                    Token methodNameToken = tokens.get(k);
                    if (methodNameToken.type == TokenType.WORD) {
                        if (METHODS.contains(methodNameToken.value)) {
                            methodName = methodNameToken.value;
                        } else if (methodNameToken.value.endsWith("/any") || methodNameToken.value.endsWith("/all")) {
                            Token ntoken;
                            aggregateSource = methodNameToken.value.substring(0, methodNameToken.value.length() - 4);
                            aggregateFunction = Enum.valueOf(AggregateFunction.class, methodNameToken.value.substring(methodNameToken.value.length() - 3));
                            int ni = i + 1;
                            Token token = ntoken = ni < tokens.size() ? tokens.get(ni) : null;
                            if (ntoken == null || aggregateFunction == AggregateFunction.all && ntoken.type != TokenType.WORD || aggregateFunction == AggregateFunction.any && ntoken.type != TokenType.WORD && ntoken.type != TokenType.CLOSEPAREN) {
                                throw new RuntimeException("unexpected token: " + (ntoken == null ? "eof" : ntoken.toString()));
                            }
                            if (ntoken.type == TokenType.WORD) {
                                aggregateVariable = ntoken.value;
                                Token token2 = ntoken = ++ni < tokens.size() ? tokens.get(ni) : null;
                                if (ntoken == null || ntoken.type != TokenType.SYMBOL || !ntoken.value.equals(":")) {
                                    throw new RuntimeException("expected ':', found: " + (ntoken == null ? "eof" : ntoken.toString()));
                                }
                                afterParenIdx = ni + 1;
                            } else {
                                List<Token> tokensIncludingParens = tokens.subList(k, ni + 1);
                                AggregateAnyFunction any = Expression.any(Expression.simpleProperty(aggregateSource));
                                ExpressionToken et = new ExpressionToken(any, tokensIncludingParens);
                                rt.subList(rt.size() - (i - k), rt.size()).clear();
                                rt.add(et);
                                return rt;
                            }
                        }
                    }
                }
                int stack = 0;
                int start = i;
                ArrayList<CommonExpression> methodArguments = new ArrayList<CommonExpression>();
                for (int j = afterParenIdx; j < tokens.size(); ++j) {
                    ExpressionToken et;
                    CommonExpression expressionInsideParens;
                    List<Token> tokensInsideParens;
                    List<Token> tokensIncludingParens;
                    Token closeToken = tokens.get(j);
                    if (closeToken.type == TokenType.OPENPAREN) {
                        ++stack;
                        continue;
                    }
                    if (methodName != null && stack == 0 && closeToken.type == TokenType.SYMBOL && closeToken.value.equals(",")) {
                        List<Token> tokensInsideComma = tokens.subList(start + 1, j);
                        CommonExpression expressionInsideComma = ExpressionParser.readExpression(tokensInsideComma);
                        methodArguments.add(expressionInsideComma);
                        start = j;
                        continue;
                    }
                    if (closeToken.type != TokenType.CLOSEPAREN) continue;
                    if (stack > 0) {
                        --stack;
                        continue;
                    }
                    if (methodName != null) {
                        tokensIncludingParens = tokens.subList(k, j + 1);
                        tokensInsideParens = tokens.subList(start + 1, j);
                        expressionInsideParens = ExpressionParser.readExpression(tokensInsideParens);
                        methodArguments.add(expressionInsideParens);
                        CommonExpression methodCall = ExpressionParser.methodCall(methodName, methodArguments);
                        et = new ExpressionToken(methodCall, tokensIncludingParens);
                        rt.subList(rt.size() - (i - k), rt.size()).clear();
                        rt.add(et);
                    } else if (aggregateVariable != null) {
                        tokensIncludingParens = tokens.subList(k, j + 1);
                        tokensInsideParens = tokens.subList(afterParenIdx, j);
                        expressionInsideParens = ExpressionParser.readExpression(tokensInsideParens);
                        if (!(expressionInsideParens instanceof BoolCommonExpression)) {
                            throw new RuntimeException("illegal any predicate");
                        }
                        AggregateBoolFunction any = Expression.aggregate(aggregateFunction, Expression.simpleProperty(aggregateSource), aggregateVariable, (BoolCommonExpression)expressionInsideParens);
                        et = new ExpressionToken(any, tokensIncludingParens);
                        rt.subList(rt.size() - (i - k), rt.size()).clear();
                        rt.add(et);
                    } else {
                        tokensIncludingParens = tokens.subList(i, j + 1);
                        tokensInsideParens = tokens.subList(i + 1, j);
                        expressionInsideParens = ExpressionParser.readExpression(tokensInsideParens);
                        CommonExpression exp = null;
                        exp = expressionInsideParens instanceof BoolCommonExpression ? Expression.boolParen(expressionInsideParens) : Expression.paren(expressionInsideParens);
                        et = new ExpressionToken(exp, tokensIncludingParens);
                        rt.add(et);
                    }
                    i = j;
                }
                continue;
            }
            rt.add(openToken);
        }
        return rt;
    }

    private static <T extends CommonExpression> void assertType(CommonExpression expression, Class<T> type) {
        if (!type.isAssignableFrom(expression.getClass())) {
            throw new RuntimeException("Expected " + type.getSimpleName());
        }
    }

    private static CommonExpression readExpression(List<Token> tokens) {
        BigDecimal decimalValue;
        int e;
        CommonExpression rt = null;
        tokens = ExpressionParser.trimWhitespace(tokens);
        Token lastToken = tokens.get(tokens.size() - 1);
        if (lastToken.type == TokenType.WORD && (lastToken.value.equals("asc") || lastToken.value.equals("desc"))) {
            return Expression.orderBy(ExpressionParser.readExpression(tokens.subList(0, tokens.size() - 1)), lastToken.value.equals("asc") ? OrderByExpression.Direction.ASCENDING : OrderByExpression.Direction.DESCENDING);
        }
        if ((tokens = ExpressionParser.processParentheses(tokens)).size() == 2 && tokens.get((int)0).type == TokenType.WORD && tokens.get((int)1).type == TokenType.QUOTED_STRING) {
            String word = tokens.get((int)0).value;
            String value = ExpressionParser.unquote(tokens.get((int)1).value);
            if (word.equals("datetime")) {
                DateTime dt = InternalUtil.parseDateTime(value);
                return Expression.dateTime(new LocalDateTime((Object)dt));
            }
            if (word.equals("time")) {
                LocalTime t = InternalUtil.parseTime(value);
                return Expression.time(t);
            }
            if (word.equals("datetimeoffset")) {
                DateTime dt = InternalUtil.parseDateTime(value);
                return Expression.dateTimeOffset(dt);
            }
            if (word.equals("guid")) {
                return Expression.guid(Guid.fromString(value));
            }
            if (word.equals("decimal")) {
                return Expression.decimal(new BigDecimal(value));
            }
            if (word.equals("X") || word.equals("binary")) {
                try {
                    byte[] bValue = Hex.decodeHex(value.toCharArray());
                    return Expression.binary(bValue);
                }
                catch (DecoderException e2) {
                    throw Throwables.propagate(e2);
                }
            }
        }
        if (tokens.size() == 2 && tokens.get((int)0).type == TokenType.NUMBER && tokens.get((int)1).type == TokenType.WORD && tokens.get((int)1).value.equals("L")) {
            long longValue = Long.parseLong(tokens.get((int)0).value);
            return Expression.int64(longValue);
        }
        if (tokens.size() == 2 && tokens.get((int)0).type == TokenType.NUMBER && tokens.get((int)1).type == TokenType.WORD && tokens.get((int)1).value.equals("f")) {
            float floatValue = Float.parseFloat(tokens.get((int)0).value);
            return Expression.single(floatValue);
        }
        if (tokens.size() == 4 && tokens.get((int)0).type == TokenType.NUMBER && tokens.get((int)1).type == TokenType.SYMBOL && tokens.get((int)1).value.equals(".") && tokens.get((int)2).type == TokenType.NUMBER && tokens.get((int)3).value.equals("f")) {
            float floatValue = Float.parseFloat(tokens.get((int)0).value + "." + tokens.get((int)2).value);
            return Expression.single(floatValue);
        }
        if (tokens.size() == 3 && tokens.get((int)0).type == TokenType.NUMBER && tokens.get((int)1).type == TokenType.SYMBOL && tokens.get((int)1).value.equals(".") && tokens.get((int)2).type == TokenType.NUMBER) {
            double doubleValue = Double.parseDouble(tokens.get((int)0).value + "." + tokens.get((int)2).value);
            return Expression.double_(doubleValue);
        }
        if (tokens.size() == 4 && tokens.get((int)0).type == TokenType.NUMBER && tokens.get((int)1).type == TokenType.WORD && tokens.get((int)1).value.equals("E") && tokens.get((int)2).type == TokenType.SYMBOL && tokens.get((int)2).value.equals("+") && tokens.get((int)3).type == TokenType.NUMBER) {
            double doubleValue = Double.parseDouble(tokens.get((int)0).value + "E+" + tokens.get((int)3).value);
            return Expression.double_(doubleValue);
        }
        if (tokens.size() == 3 && tokens.get((int)0).type == TokenType.NUMBER && tokens.get((int)1).type == TokenType.WORD && tokens.get((int)1).value.equals("E") && tokens.get((int)2).type == TokenType.NUMBER && (e = Integer.parseInt(tokens.get((int)2).value)) < 1) {
            double doubleValue = Double.parseDouble(tokens.get((int)0).value + "E" + tokens.get((int)2).value);
            return Expression.double_(doubleValue);
        }
        if (tokens.size() == 6 && tokens.get((int)0).type == TokenType.NUMBER && tokens.get((int)1).type == TokenType.SYMBOL && tokens.get((int)1).value.equals(".") && tokens.get((int)2).type == TokenType.NUMBER && tokens.get((int)3).type == TokenType.WORD && tokens.get((int)3).value.equals("E") && tokens.get((int)4).type == TokenType.SYMBOL && tokens.get((int)4).value.equals("+") && tokens.get((int)5).type == TokenType.NUMBER) {
            double doubleValue = Double.parseDouble(tokens.get((int)0).value + "." + tokens.get((int)2).value + "E+" + tokens.get((int)5).value);
            return Expression.double_(doubleValue);
        }
        if (tokens.size() == 5 && tokens.get((int)0).type == TokenType.NUMBER && tokens.get((int)1).type == TokenType.SYMBOL && tokens.get((int)1).value.equals(".") && tokens.get((int)2).type == TokenType.NUMBER && tokens.get((int)3).type == TokenType.WORD && tokens.get((int)3).value.equals("E") && tokens.get((int)4).type == TokenType.NUMBER && (e = Integer.parseInt(tokens.get((int)4).value)) < 1) {
            double doubleValue = Double.parseDouble(tokens.get((int)0).value + "." + tokens.get((int)2).value + "E" + tokens.get((int)4).value);
            return Expression.double_(doubleValue);
        }
        if (tokens.size() == 2 && tokens.get((int)0).type == TokenType.NUMBER && tokens.get((int)1).type == TokenType.WORD && tokens.get((int)1).value.equalsIgnoreCase("M")) {
            decimalValue = new BigDecimal(tokens.get((int)0).value);
            return Expression.decimal(decimalValue);
        }
        if (tokens.size() == 4 && tokens.get((int)0).type == TokenType.NUMBER && tokens.get((int)1).type == TokenType.SYMBOL && tokens.get((int)1).value.equals(".") && tokens.get((int)2).type == TokenType.NUMBER && tokens.get((int)3).value.equalsIgnoreCase("m")) {
            decimalValue = new BigDecimal(tokens.get((int)0).value + "." + tokens.get((int)2).value);
            return Expression.decimal(decimalValue);
        }
        if (tokens.size() == 1) {
            Token token = tokens.get(0);
            if (token.type == TokenType.QUOTED_STRING) {
                return Expression.string(ExpressionParser.unquote(token.value));
            }
            if (token.type == TokenType.WORD) {
                if (token.value.equals("null")) {
                    return Expression.null_();
                }
                if (token.value.equals("true")) {
                    return Expression.boolean_(true);
                }
                if (token.value.equals("false")) {
                    return Expression.boolean_(false);
                }
                return Expression.simpleProperty(token.value);
            }
            if (token.type == TokenType.NUMBER) {
                try {
                    int value = Integer.parseInt(token.value);
                    return Expression.integral(value);
                }
                catch (NumberFormatException e3) {
                    long value = Long.parseLong(token.value);
                    return Expression.int64(value);
                }
            }
            if (token.type == TokenType.EXPRESSION) {
                return ((ExpressionToken)token).expression;
            }
            throw new RuntimeException("Unexpected");
        }
        rt = ExpressionParser.processBinaryExpression(tokens, "or", new Func2<CommonExpression, CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression lhs, CommonExpression rhs) {
                ExpressionParser.assertType(lhs, BoolCommonExpression.class);
                ExpressionParser.assertType(rhs, BoolCommonExpression.class);
                return Expression.or((BoolCommonExpression)lhs, (BoolCommonExpression)rhs);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processBinaryExpression(tokens, "and", new Func2<CommonExpression, CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression lhs, CommonExpression rhs) {
                ExpressionParser.assertType(lhs, BoolCommonExpression.class);
                ExpressionParser.assertType(rhs, BoolCommonExpression.class);
                return Expression.and((BoolCommonExpression)lhs, (BoolCommonExpression)rhs);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processBinaryExpression(tokens, "eq", new Func2<CommonExpression, CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression lhs, CommonExpression rhs) {
                return Expression.eq(lhs, rhs);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processBinaryExpression(tokens, "ne", new Func2<CommonExpression, CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression lhs, CommonExpression rhs) {
                return Expression.ne(lhs, rhs);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processBinaryExpression(tokens, "lt", new Func2<CommonExpression, CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression lhs, CommonExpression rhs) {
                return Expression.lt(lhs, rhs);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processBinaryExpression(tokens, "gt", new Func2<CommonExpression, CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression lhs, CommonExpression rhs) {
                return Expression.gt(lhs, rhs);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processBinaryExpression(tokens, "le", new Func2<CommonExpression, CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression lhs, CommonExpression rhs) {
                return Expression.le(lhs, rhs);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processBinaryExpression(tokens, "ge", new Func2<CommonExpression, CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression lhs, CommonExpression rhs) {
                return Expression.ge(lhs, rhs);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processBinaryExpression(tokens, "add", new Func2<CommonExpression, CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression lhs, CommonExpression rhs) {
                return Expression.add(lhs, rhs);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processBinaryExpression(tokens, "sub", new Func2<CommonExpression, CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression lhs, CommonExpression rhs) {
                return Expression.sub(lhs, rhs);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processBinaryExpression(tokens, "mul", new Func2<CommonExpression, CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression lhs, CommonExpression rhs) {
                return Expression.mul(lhs, rhs);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processBinaryExpression(tokens, "div", new Func2<CommonExpression, CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression lhs, CommonExpression rhs) {
                return Expression.div(lhs, rhs);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processBinaryExpression(tokens, "mod", new Func2<CommonExpression, CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression lhs, CommonExpression rhs) {
                return Expression.mod(lhs, rhs);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processUnaryExpression(tokens, "not", true, new Func1<CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression expression) {
                return Expression.not(expression);
            }
        });
        if (rt != null) {
            return rt;
        }
        rt = ExpressionParser.processUnaryExpression(tokens, "-", false, new Func1<CommonExpression, CommonExpression>(){

            @Override
            public CommonExpression apply(CommonExpression expression) {
                return Expression.negate(expression);
            }
        });
        if (rt != null) {
            return rt;
        }
        throw new RuntimeException("Unable to read expression with tokens: " + tokens);
    }

    private static String unquote(String singleQuotedValue) {
        return singleQuotedValue.substring(1, singleQuotedValue.length() - 1).replace("''", "'");
    }

    private static List<Token> trimWhitespace(List<Token> tokens) {
        int start = 0;
        while (tokens.get((int)start).type == TokenType.WHITESPACE) {
            ++start;
        }
        int end = tokens.size() - 1;
        while (tokens.get((int)end).type == TokenType.WHITESPACE) {
            --end;
        }
        return tokens.subList(start, end + 1);
    }

    public static List<Token> tokenize(String value) {
        ArrayList<Token> rt = new ArrayList<Token>();
        int current = 0;
        int end = 0;
        while (true) {
            if (current == value.length()) {
                return rt;
            }
            char c = value.charAt(current);
            if (Character.isWhitespace(c)) {
                end = ExpressionParser.readWhitespace(value, current);
                rt.add(new Token(TokenType.WHITESPACE, value.substring(current, end)));
                current = end;
                continue;
            }
            if (c == '\'') {
                end = ExpressionParser.readQuotedString(value, current + 1);
                rt.add(new Token(TokenType.QUOTED_STRING, value.substring(current, end)));
                current = end;
                continue;
            }
            if (Character.isLetter(c)) {
                end = ExpressionParser.readWord(value, current + 1);
                rt.add(new Token(TokenType.WORD, value.substring(current, end)));
                current = end;
                continue;
            }
            if (Character.isDigit(c)) {
                end = ExpressionParser.readDigits(value, current + 1);
                rt.add(new Token(TokenType.NUMBER, value.substring(current, end)));
                current = end;
                continue;
            }
            if (c == '(') {
                rt.add(new Token(TokenType.OPENPAREN, Character.toString(c)));
                ++current;
                continue;
            }
            if (c == ')') {
                rt.add(new Token(TokenType.CLOSEPAREN, Character.toString(c)));
                ++current;
                continue;
            }
            if (c == '-') {
                if (Character.isDigit(value.charAt(current + 1))) {
                    end = ExpressionParser.readDigits(value, current + 1);
                    rt.add(new Token(TokenType.NUMBER, value.substring(current, end)));
                    current = end;
                    continue;
                }
                rt.add(new Token(TokenType.SYMBOL, Character.toString(c)));
                ++current;
                continue;
            }
            if (",.+=:".indexOf(c) <= -1) break;
            rt.add(new Token(TokenType.SYMBOL, Character.toString(c)));
            ++current;
        }
        ExpressionParser.dumpTokens(rt);
        throw new RuntimeException("Unable to tokenize: " + value + " current: " + current + " rem: " + value.substring(current));
    }

    public static void dumpTokens(List<Token> tokens) {
        for (Token t : tokens) {
            System.out.println(t.type.toString() + t.toString());
        }
    }

    private static int readDigits(String value, int start) {
        int rt;
        for (rt = start; rt < value.length() && Character.isDigit(value.charAt(rt)); ++rt) {
        }
        return rt;
    }

    private static int readWord(String value, int start) {
        int rt;
        for (rt = start; rt < value.length() && (Character.isLetterOrDigit(value.charAt(rt)) || value.charAt(rt) == '/' || value.charAt(rt) == '_'); ++rt) {
        }
        return rt;
    }

    private static int readQuotedString(String value, int start) {
        int rt = start;
        while (value.charAt(rt) != '\'' || rt < value.length() - 1 && value.charAt(rt + 1) == '\'') {
            if (value.charAt(rt) != '\'') {
                ++rt;
                continue;
            }
            rt += 2;
        }
        return ++rt;
    }

    private static int readWhitespace(String value, int start) {
        int rt;
        for (rt = start; rt < value.length() && Character.isWhitespace(value.charAt(rt)); ++rt) {
        }
        return rt;
    }

    private static class ExpressionToken
    extends Token {
        public final CommonExpression expression;
        private final List<Token> tokens;

        public ExpressionToken(CommonExpression expression, List<Token> tokens) {
            super(TokenType.EXPRESSION, null);
            this.expression = expression;
            this.tokens = tokens;
        }

        @Override
        public String toString() {
            return Enumerable.create(this.tokens).join("");
        }
    }

    public static class Token {
        public final TokenType type;
        public final String value;

        public Token(TokenType type, String value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return "[" + this.value + "]";
        }
    }

    public static enum TokenType {
        UNKNOWN,
        WHITESPACE,
        QUOTED_STRING,
        WORD,
        SYMBOL,
        NUMBER,
        OPENPAREN,
        CLOSEPAREN,
        EXPRESSION;

    }

    public static enum AggregateFunction {
        none,
        any,
        all;

    }

    private static class Methods {
        public static final String CAST = "cast";
        public static final String ISOF = "isof";
        public static final String ENDSWITH = "endswith";
        public static final String STARTSWITH = "startswith";
        public static final String SUBSTRINGOF = "substringof";
        public static final String INDEXOF = "indexof";
        public static final String REPLACE = "replace";
        public static final String TOLOWER = "tolower";
        public static final String TOUPPER = "toupper";
        public static final String TRIM = "trim";
        public static final String SUBSTRING = "substring";
        public static final String CONCAT = "concat";
        public static final String LENGTH = "length";
        public static final String YEAR = "year";
        public static final String MONTH = "month";
        public static final String DAY = "day";
        public static final String HOUR = "hour";
        public static final String MINUTE = "minute";
        public static final String SECOND = "second";
        public static final String ROUND = "round";
        public static final String FLOOR = "floor";
        public static final String CEILING = "ceiling";

        private Methods() {
        }
    }
}

