/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format;

public enum FormatType {
    ATOM("application/xml", "application/atom+xml"),
    JSON("application/json");

    private final String[] mediaTypes;

    private FormatType(String ... mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public String[] getAcceptableMediaTypes() {
        return this.mediaTypes;
    }

    public static FormatType parse(String format) {
        if ("json".equalsIgnoreCase(format)) {
            return JSON;
        }
        if ("atom".equalsIgnoreCase(format)) {
            return ATOM;
        }
        throw new UnsupportedOperationException("Unsupported format " + format);
    }
}

