/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format;

import java.util.List;
import javax.ws.rs.core.MediaType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.format.Entry;
import org.odata4j.format.FormatType;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.SingleLink;
import org.odata4j.format.SingleLinks;
import org.odata4j.format.json.JsonCollectionFormatWriter;
import org.odata4j.format.json.JsonComplexObjectFormatWriter;
import org.odata4j.format.json.JsonEntryFormatWriter;
import org.odata4j.format.json.JsonFeedFormatWriter;
import org.odata4j.format.json.JsonPropertyFormatWriter;
import org.odata4j.format.json.JsonRequestEntryFormatWriter;
import org.odata4j.format.json.JsonServiceDocumentFormatWriter;
import org.odata4j.format.json.JsonSingleLinkFormatWriter;
import org.odata4j.format.json.JsonSingleLinksFormatWriter;
import org.odata4j.format.xml.AtomEntryFormatWriter;
import org.odata4j.format.xml.AtomFeedFormatWriter;
import org.odata4j.format.xml.AtomRequestEntryFormatWriter;
import org.odata4j.format.xml.AtomServiceDocumentFormatWriter;
import org.odata4j.format.xml.AtomSingleLinkFormatWriter;
import org.odata4j.format.xml.AtomSingleLinksFormatWriter;
import org.odata4j.format.xml.XmlPropertyFormatWriter;
import org.odata4j.producer.CollectionResponse;
import org.odata4j.producer.ComplexObjectResponse;
import org.odata4j.producer.EntitiesResponse;
import org.odata4j.producer.EntityResponse;
import org.odata4j.producer.PropertyResponse;
import org.odata4j.producer.exceptions.NotImplementedException;

public class FormatWriterFactory {
    public static <T> FormatWriter<T> getFormatWriter(Class<T> targetType, List<MediaType> acceptTypes, String format, String callback) {
        FormatWriters formatWriters;
        FormatType type = null;
        if (format != null) {
            type = FormatType.parse(format);
        }
        if (type == null && acceptTypes != null) {
            for (MediaType acceptType : acceptTypes) {
                if (!acceptType.equals(MediaType.APPLICATION_JSON_TYPE)) continue;
                type = FormatType.JSON;
                break;
            }
        }
        if (type == null) {
            type = FormatType.ATOM;
        }
        FormatWriters formatWriters2 = formatWriters = type.equals((Object)FormatType.JSON) ? new JsonWriters(callback) : new AtomWriters();
        if (targetType.equals(EdmDataServices.class)) {
            return formatWriters.getServiceDocumentFormatWriter();
        }
        if (targetType.equals(EntitiesResponse.class)) {
            return formatWriters.getFeedFormatWriter();
        }
        if (targetType.equals(EntityResponse.class)) {
            return formatWriters.getEntryFormatWriter();
        }
        if (targetType.equals(PropertyResponse.class)) {
            return formatWriters.getPropertyFormatWriter();
        }
        if (Entry.class.isAssignableFrom(targetType)) {
            return formatWriters.getRequestEntryFormatWriter();
        }
        if (SingleLink.class.isAssignableFrom(targetType)) {
            return formatWriters.getSingleLinkFormatWriter();
        }
        if (SingleLinks.class.isAssignableFrom(targetType)) {
            return formatWriters.getSingleLinksFormatWriter();
        }
        if (targetType.equals(ComplexObjectResponse.class)) {
            return formatWriters.getComplexObjectFormatWriter();
        }
        if (targetType.equals(CollectionResponse.class)) {
            return formatWriters.getCollectionFormatWriter();
        }
        throw new IllegalArgumentException("Unable to locate format writer for " + targetType.getName() + " and format " + (Object)((Object)type));
    }

    public static class AtomWriters
    implements FormatWriters {
        @Override
        public FormatWriter<EdmDataServices> getServiceDocumentFormatWriter() {
            return new AtomServiceDocumentFormatWriter();
        }

        @Override
        public FormatWriter<EntitiesResponse> getFeedFormatWriter() {
            return new AtomFeedFormatWriter();
        }

        @Override
        public FormatWriter<EntityResponse> getEntryFormatWriter() {
            return new AtomEntryFormatWriter();
        }

        @Override
        public FormatWriter<PropertyResponse> getPropertyFormatWriter() {
            return new XmlPropertyFormatWriter();
        }

        @Override
        public FormatWriter<Entry> getRequestEntryFormatWriter() {
            return new AtomRequestEntryFormatWriter();
        }

        @Override
        public FormatWriter<SingleLink> getSingleLinkFormatWriter() {
            return new AtomSingleLinkFormatWriter();
        }

        @Override
        public FormatWriter<SingleLinks> getSingleLinksFormatWriter() {
            return new AtomSingleLinksFormatWriter();
        }

        @Override
        public FormatWriter<ComplexObjectResponse> getComplexObjectFormatWriter() {
            throw new NotImplementedException();
        }

        @Override
        public FormatWriter<CollectionResponse<?>> getCollectionFormatWriter() {
            throw new NotImplementedException();
        }
    }

    public static class JsonWriters
    implements FormatWriters {
        private final String callback;

        public JsonWriters(String callback) {
            this.callback = callback;
        }

        @Override
        public FormatWriter<EdmDataServices> getServiceDocumentFormatWriter() {
            return new JsonServiceDocumentFormatWriter(this.callback);
        }

        @Override
        public FormatWriter<EntitiesResponse> getFeedFormatWriter() {
            return new JsonFeedFormatWriter(this.callback);
        }

        @Override
        public FormatWriter<EntityResponse> getEntryFormatWriter() {
            return new JsonEntryFormatWriter(this.callback);
        }

        @Override
        public FormatWriter<PropertyResponse> getPropertyFormatWriter() {
            return new JsonPropertyFormatWriter(this.callback);
        }

        @Override
        public FormatWriter<Entry> getRequestEntryFormatWriter() {
            return new JsonRequestEntryFormatWriter(this.callback);
        }

        @Override
        public FormatWriter<SingleLink> getSingleLinkFormatWriter() {
            return new JsonSingleLinkFormatWriter(this.callback);
        }

        @Override
        public FormatWriter<SingleLinks> getSingleLinksFormatWriter() {
            return new JsonSingleLinksFormatWriter(this.callback);
        }

        @Override
        public FormatWriter<ComplexObjectResponse> getComplexObjectFormatWriter() {
            return new JsonComplexObjectFormatWriter(this.callback);
        }

        @Override
        public FormatWriter<CollectionResponse<?>> getCollectionFormatWriter() {
            return new JsonCollectionFormatWriter(this.callback);
        }
    }

    private static interface FormatWriters {
        public FormatWriter<EdmDataServices> getServiceDocumentFormatWriter();

        public FormatWriter<EntitiesResponse> getFeedFormatWriter();

        public FormatWriter<EntityResponse> getEntryFormatWriter();

        public FormatWriter<PropertyResponse> getPropertyFormatWriter();

        public FormatWriter<Entry> getRequestEntryFormatWriter();

        public FormatWriter<SingleLink> getSingleLinkFormatWriter();

        public FormatWriter<SingleLinks> getSingleLinksFormatWriter();

        public FormatWriter<ComplexObjectResponse> getComplexObjectFormatWriter();

        public FormatWriter<CollectionResponse<?>> getCollectionFormatWriter();
    }
}

