/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.json;

import java.io.Reader;
import org.odata4j.core.OCollection;
import org.odata4j.core.OCollections;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OObject;
import org.odata4j.core.OSimpleObjects;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.format.FormatParser;
import org.odata4j.format.FormatParserFactory;
import org.odata4j.format.FormatType;
import org.odata4j.format.Settings;
import org.odata4j.format.json.JsonComplexObjectFormatParser;
import org.odata4j.format.json.JsonFormatParser;
import org.odata4j.format.json.JsonStreamReaderFactory;
import org.odata4j.producer.exceptions.NotImplementedException;

public class JsonCollectionFormatParser
extends JsonFormatParser
implements FormatParser<OCollection<? extends OObject>> {
    private final EdmCollectionType returnType;

    public JsonCollectionFormatParser(Settings s) {
        super(s);
        this.returnType = (EdmCollectionType)(s == null ? null : s.parseType);
    }

    public JsonCollectionFormatParser(EdmCollectionType collectionType, EdmDataServices md) {
        super(null);
        this.metadata = md;
        this.returnType = collectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCollection<? extends OObject> parse(Reader reader) {
        JsonStreamReaderFactory.JsonStreamReader jsr = JsonStreamReaderFactory.createJsonStreamReader(reader);
        try {
            if (this.isResponse) {
                this.ensureNext(jsr);
                this.ensureStartObject(jsr.nextEvent());
                this.ensureNext(jsr);
                this.ensureStartProperty(jsr.nextEvent(), "d");
                if (this.version.compareTo(ODataVersion.V1) > 0) {
                    this.ensureNext(jsr);
                    this.ensureStartObject(jsr.nextEvent());
                    this.ensureNext(jsr);
                    this.ensureStartProperty(jsr.nextEvent(), "results");
                }
            }
            OCollection<? extends OObject> o = this.parseCollection(jsr);
            if (this.isResponse) {
                this.ensureNext(jsr);
                this.ensureEndProperty(jsr.nextEvent());
                if (this.version.compareTo(ODataVersion.V1) > 0) {
                    this.ensureNext(jsr);
                    this.ensureEndObject(jsr.nextEvent());
                    this.ensureNext(jsr);
                    this.ensureEndProperty(jsr.nextEvent());
                }
                this.ensureNext(jsr);
                this.ensureEndObject(jsr.nextEvent());
            }
            OCollection<? extends OObject> oCollection = o;
            return oCollection;
        }
        finally {
            jsr.close();
        }
    }

    protected OCollection<? extends OObject> parseCollection(JsonStreamReaderFactory.JsonStreamReader jsr) {
        this.ensureNext(jsr);
        this.ensureStartArray(jsr.nextEvent());
        OCollection.Builder<OObject> c = this.newCollectionBuilder();
        if (this.returnType.getItemType().isSimple()) {
            this.parseCollectionOfSimple(c, jsr);
        } else {
            FormatParser<? extends OObject> parser = this.createItemParser(this.returnType.getItemType());
            while (jsr.hasNext()) {
                if (parser instanceof JsonComplexObjectFormatParser) {
                    OComplexObject obj = ((JsonComplexObjectFormatParser)parser).parseSingleObject(jsr);
                    if (null == obj) break;
                    c = c.add(obj);
                    continue;
                }
                throw new NotImplementedException("collections of type: " + this.returnType.getItemType().getFullyQualifiedTypeName() + " not implemented");
            }
        }
        this.ensureEndArray(jsr.previousEvent());
        return c.build();
    }

    protected void parseCollectionOfSimple(OCollection.Builder<OObject> builder, JsonStreamReaderFactory.JsonStreamReader jsr) {
        while (jsr.hasNext()) {
            JsonStreamReaderFactory.JsonStreamReader.JsonEvent e = jsr.nextEvent();
            if (e.isValue()) {
                JsonStreamReaderFactory.JsonStreamReader.JsonValueEvent ve = e.asValue();
                builder.add(OSimpleObjects.parse((EdmSimpleType)this.returnType.getItemType(), ve.getValue()));
                continue;
            }
            if (e.isEndArray()) break;
            throw new RuntimeException("invalid JSON content");
        }
    }

    protected OCollection.Builder<OObject> newCollectionBuilder() {
        return OCollections.newBuilder(this.returnType.getItemType());
    }

    protected FormatParser<? extends OObject> createItemParser(EdmType edmType) {
        Settings s = new Settings(this.version, this.metadata, this.entitySetName, this.entityKey, null, false, edmType);
        return FormatParserFactory.getParser(EdmType.getInstanceType(edmType), FormatType.JSON, s);
    }
}

