/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.json;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.OComplexObjects;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.format.FormatParser;
import org.odata4j.format.Settings;
import org.odata4j.format.json.JsonFormatParser;
import org.odata4j.format.json.JsonStreamReaderFactory;
import org.odata4j.format.json.JsonTypeConverter;

public class JsonComplexObjectFormatParser
extends JsonFormatParser
implements FormatParser<OComplexObject> {
    private EdmComplexType returnType = null;

    public JsonComplexObjectFormatParser(Settings s) {
        super(s);
        this.returnType = (EdmComplexType)(s == null ? null : s.parseType);
    }

    public JsonComplexObjectFormatParser(EdmComplexType type) {
        super(null);
        this.returnType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OComplexObject parse(Reader reader) {
        JsonStreamReaderFactory.JsonStreamReader jsr = JsonStreamReaderFactory.createJsonStreamReader(reader);
        try {
            if (this.isResponse) {
                this.ensureNext(jsr);
                this.ensureStartObject(jsr.nextEvent());
                this.ensureNext(jsr);
                this.ensureStartProperty(jsr.nextEvent(), "d");
                if (this.version.compareTo(ODataVersion.V1) > 0) {
                    this.ensureNext(jsr);
                    this.ensureStartObject(jsr.nextEvent());
                    this.ensureNext(jsr);
                    this.ensureStartProperty(jsr.nextEvent(), "results");
                }
            }
            OComplexObject o = this.parseSingleObject(jsr);
            if (this.isResponse) {
                this.ensureNext(jsr);
                this.ensureEndProperty(jsr.nextEvent());
                if (this.version.compareTo(ODataVersion.V1) > 0) {
                    this.ensureNext(jsr);
                    this.ensureEndObject(jsr.nextEvent());
                    this.ensureNext(jsr);
                    this.ensureEndProperty(jsr.nextEvent());
                }
                this.ensureNext(jsr);
                this.ensureEndObject(jsr.nextEvent());
            }
            OComplexObject oComplexObject = o;
            return oComplexObject;
        }
        finally {
            jsr.close();
        }
    }

    public OComplexObject parseSingleObject(JsonStreamReaderFactory.JsonStreamReader jsr) {
        this.ensureNext(jsr);
        JsonStreamReaderFactory.JsonStreamReader.JsonEvent event = jsr.nextEvent();
        if (event.isStartObject()) {
            ArrayList props = new ArrayList();
            return this.eatProps(props, jsr);
        }
        return null;
    }

    public OComplexObject parseSingleObject(JsonStreamReaderFactory.JsonStreamReader jsr, JsonStreamReaderFactory.JsonStreamReader.JsonEvent startPropertyEvent) {
        ArrayList props = new ArrayList();
        this.addProperty(props, startPropertyEvent.asStartProperty().getName(), jsr);
        return this.eatProps(props, jsr);
    }

    private OComplexObject eatProps(List<OProperty<?>> props, JsonStreamReaderFactory.JsonStreamReader jsr) {
        this.ensureNext(jsr);
        while (jsr.hasNext()) {
            JsonStreamReaderFactory.JsonStreamReader.JsonEvent event = jsr.nextEvent();
            if (event.isStartProperty()) {
                this.addProperty(props, event.asStartProperty().getName(), jsr);
                continue;
            }
            if (event.isEndObject()) break;
            throw new JsonStreamReaderFactory.JsonParseException("unexpected parse event: " + event.toString());
        }
        return OComplexObjects.create(this.returnType, props);
    }

    protected void addProperty(List<OProperty<?>> props, String name, JsonStreamReaderFactory.JsonStreamReader jsr) {
        EdmProperty ep;
        JsonStreamReaderFactory.JsonStreamReader.JsonEvent event = jsr.nextEvent();
        if (event.isEndProperty()) {
            ep = this.returnType.findProperty(name);
            if (ep == null) {
                throw new IllegalArgumentException("unknown property " + name + " for " + this.returnType.getFullyQualifiedTypeName());
            }
            if (!ep.getType().isSimple()) {
                throw new UnsupportedOperationException("Only simple properties supported");
            }
        } else {
            throw new JsonStreamReaderFactory.JsonParseException("expecting endproperty, got: " + event.toString());
        }
        props.add(JsonTypeConverter.parse(name, (EdmSimpleType)ep.getType(), event.asEndProperty().getValue()));
    }
}

