/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.json;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OLink;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.format.Entry;
import org.odata4j.format.Feed;
import org.odata4j.format.FormatParser;
import org.odata4j.format.Settings;
import org.odata4j.format.json.JsonFormatParser;
import org.odata4j.format.json.JsonStreamReaderFactory;

public class JsonFeedFormatParser
extends JsonFormatParser
implements FormatParser<Feed> {
    public JsonFeedFormatParser(Settings settings) {
        super(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonFeed parse(Reader reader) {
        JsonStreamReaderFactory.JsonStreamReader jsr = JsonStreamReaderFactory.createJsonStreamReader(reader);
        try {
            JsonFeed feed;
            JsonStreamReaderFactory.JsonStreamReader.JsonEvent event;
            this.ensureStartObject(jsr.nextEvent());
            this.ensureStartProperty(jsr.nextEvent(), "d");
            if (this.version.compareTo(ODataVersion.V1) > 0) {
                this.ensureStartObject(jsr.nextEvent());
                this.ensureStartProperty(jsr.nextEvent(), "results");
            }
            if ((event = jsr.nextEvent()).isStartArray()) {
                feed = this.parseFeed(this.metadata.getEdmEntitySet(this.entitySetName), jsr);
            } else {
                feed = new JsonFeed();
                feed.entries = new ArrayList<Entry>();
                feed.entries.add(this.parseEntry(this.metadata.getEdmEntitySet(this.entitySetName), jsr));
            }
            if (this.version.compareTo(ODataVersion.V1) > 0) {
                this.ensureEndProperty(jsr.nextEvent());
            }
            event = jsr.nextEvent();
            while (event.isStartProperty()) {
                String pname = event.asStartProperty().getName();
                this.ensureNext(jsr);
                event = jsr.nextEvent();
                this.ensureEndProperty(event);
                if ("__next".equals(pname)) {
                    feed.next = event.asEndProperty().getValue();
                } else if ("__count".equals(pname)) {
                    feed.inlineCount = Integer.parseInt(event.asEndProperty().getValue());
                }
                this.ensureNext(jsr);
                event = jsr.nextEvent();
            }
            if (this.version.compareTo(ODataVersion.V1) > 0) {
                this.ensureEndObject(event);
                this.ensureEndProperty(jsr.nextEvent());
            }
            this.ensureEndObject(jsr.nextEvent());
            if (jsr.hasNext()) {
                throw new IllegalArgumentException("garbage after the feed");
            }
            JsonFeed jsonFeed = feed;
            return jsonFeed;
        }
        finally {
            jsr.close();
        }
    }

    static class JsonEntry
    implements Entry {
        private EdmEntitySet entitySet;
        private EdmEntityType entityType;
        JsonFormatParser.JsonEntryMetaData jemd;
        List<OProperty<?>> properties;
        List<OLink> links;
        OEntity oentity;

        public JsonEntry(EdmEntitySet eset) {
            this(eset, null);
        }

        public JsonEntry(EdmEntitySet eset, JsonFormatParser.JsonEntryMetaData jemd) {
            this.entitySet = eset;
            this.entityType = null != eset ? eset.getType() : null;
            this.jemd = jemd;
        }

        public String getContentType() {
            return "application/json";
        }

        public JsonFormatParser.JsonEntryMetaData getJemd() {
            return this.jemd;
        }

        public EdmEntitySet getEntitySet() {
            return this.entitySet;
        }

        public EdmEntityType getEntityType() {
            return this.entityType;
        }

        public void setEntityType(EdmEntityType value) {
            this.entityType = value;
        }

        @Override
        public String getUri() {
            return this.jemd == null ? null : this.jemd.uri;
        }

        @Override
        public String getETag() {
            return this.jemd == null ? null : this.jemd.etag;
        }

        @Override
        public OEntity getEntity() {
            return this.oentity;
        }

        public OEntityKey getEntityKey() {
            String uri = this.getUri();
            if (uri == null) {
                return null;
            }
            return OEntityKey.parse(uri.substring(uri.lastIndexOf(40)));
        }
    }

    static class JsonFeed
    implements Feed {
        List<Entry> entries;
        String next;
        Integer inlineCount;

        JsonFeed() {
        }

        @Override
        public String getNext() {
            return this.next;
        }

        @Override
        public Iterable<Entry> getEntries() {
            return this.entries;
        }
    }
}

