/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.json;

import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.odata4j.core.OEntity;
import org.odata4j.format.json.JsonFormatWriter;
import org.odata4j.format.json.JsonWriter;
import org.odata4j.producer.EntitiesResponse;

public class JsonFeedFormatWriter
extends JsonFormatWriter<EntitiesResponse> {
    public JsonFeedFormatWriter(String jsonpCallback) {
        super(jsonpCallback);
    }

    @Override
    public void writeContent(UriInfo uriInfo, JsonWriter jw, EntitiesResponse target) {
        jw.startObject();
        jw.writeName("results");
        jw.startArray();
        boolean isFirst = true;
        for (OEntity oe : target.getEntities()) {
            if (isFirst) {
                isFirst = false;
            } else {
                jw.writeSeparator();
            }
            this.writeOEntity(uriInfo, jw, oe, target.getEntitySet(), true);
        }
        jw.endArray();
        if (target.getInlineCount() != null) {
            jw.writeSeparator();
            jw.writeName("__count");
            jw.writeString(target.getInlineCount().toString());
        }
        if (target.getSkipToken() != null) {
            String tops = uriInfo.getQueryParameters().getFirst("$top");
            int top = -1;
            if (null != tops) {
                top = Integer.parseInt(tops);
                top -= target.getEntities().size();
            }
            UriBuilder uri = uriInfo.getRequestUriBuilder();
            if (top > 0) {
                uri.replaceQueryParam("$top", top);
            } else {
                uri.replaceQueryParam("$top", new Object[0]);
            }
            String nextHref = uri.replaceQueryParam("$skiptoken", target.getSkipToken()).replaceQueryParam("$skip", new Object[0]).build(new Object[0]).toString();
            jw.writeSeparator();
            jw.writeName("__next");
            jw.writeString(nextHref);
        }
        jw.endObject();
    }
}

