/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.json;

import java.io.Reader;
import org.odata4j.format.json.JsonStreamReaderImpl;
import org.odata4j.format.json.JsonStreamTokenizerImpl;

public class JsonStreamReaderFactory {
    public static JsonStreamReader createJsonStreamReader(Reader reader) {
        return new JsonStreamReaderImpl(reader);
    }

    public static JsonStreamTokenizer createJsonStreamTokenizer(Reader reader) {
        return new JsonStreamTokenizerImpl(reader);
    }

    public static interface JsonStreamTokenizer {
        public boolean hasNext();

        public JsonToken nextToken();

        public void close();

        public static class JsonToken {
            public final JsonTokenType type;
            public final String value;

            public JsonToken(JsonTokenType type) {
                this(type, null);
            }

            public JsonToken(JsonTokenType type, String value) {
                this.type = type;
                this.value = value;
            }

            public String toString() {
                StringBuilder bld = new StringBuilder();
                bld.append((Object)this.type);
                if (this.value != null) {
                    bld.append("(").append(this.value).append(")");
                }
                return bld.toString();
            }
        }

        public static enum JsonTokenType {
            LEFT_CURLY_BRACKET,
            RIGHT_CURLY_BRACKET,
            LEFT_BRACKET,
            RIGHT_BRACKET,
            COMMA,
            COLON,
            TRUE,
            FALSE,
            NULL,
            NUMBER,
            STRING;

        }
    }

    public static interface JsonStreamReader {
        public boolean hasNext();

        public JsonEvent nextEvent();

        public JsonEvent previousEvent();

        public void close();

        public static interface JsonValueEvent
        extends JsonEvent {
            public String getValue();
        }

        public static interface JsonEndPropertyEvent
        extends JsonEvent {
            public String getValue();
        }

        public static interface JsonStartPropertyEvent
        extends JsonEvent {
            public String getName();
        }

        public static interface JsonEvent {
            public boolean isStartObject();

            public boolean isEndObject();

            public boolean isStartProperty();

            public boolean isEndProperty();

            public boolean isStartArray();

            public boolean isEndArray();

            public boolean isValue();

            public JsonStartPropertyEvent asStartProperty();

            public JsonEndPropertyEvent asEndProperty();

            public JsonValueEvent asValue();
        }
    }

    public static class JsonParseException
    extends RuntimeException {
        private static final long serialVersionUID = 2362481232045271688L;

        public JsonParseException() {
        }

        public JsonParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public JsonParseException(String message) {
            super(message);
        }

        public JsonParseException(Throwable cause) {
            super(cause);
        }
    }
}

