/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.xml;

import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.core4j.Enumerable;
import org.core4j.Func1;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OLink;
import org.odata4j.core.OLinks;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmType;
import org.odata4j.format.Entry;
import org.odata4j.format.Feed;
import org.odata4j.format.FormatParser;
import org.odata4j.format.xml.XmlFormatParser;
import org.odata4j.internal.FeedCustomizationMapping;
import org.odata4j.internal.InternalUtil;
import org.odata4j.stax2.Attribute2;
import org.odata4j.stax2.QName2;
import org.odata4j.stax2.StartElement2;
import org.odata4j.stax2.XMLEvent2;
import org.odata4j.stax2.XMLEventReader2;
import org.odata4j.stax2.XMLEventWriter2;
import org.odata4j.stax2.XMLFactoryProvider2;

public class AtomFeedFormatParser
extends XmlFormatParser
implements FormatParser<Feed> {
    protected EdmDataServices metadata;
    protected String entitySetName;
    protected OEntityKey entityKey;
    protected FeedCustomizationMapping fcMapping;
    private static final Pattern ENTITY_SET_NAME = Pattern.compile("\\/([^\\/\\(]+)\\(");

    public AtomFeedFormatParser(EdmDataServices metadata, String entitySetName, OEntityKey entityKey, FeedCustomizationMapping fcMapping) {
        this.metadata = metadata;
        this.entitySetName = entitySetName;
        this.entityKey = entityKey;
        this.fcMapping = fcMapping;
    }

    @Override
    public AtomFeed parse(Reader reader) {
        return this.parseFeed(InternalUtil.newXMLEventReader(reader));
    }

    AtomFeed parseFeed(XMLEventReader2 reader) {
        AtomFeed feed = new AtomFeed();
        ArrayList<AtomEntry> rt = new ArrayList<AtomEntry>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (AtomFeedFormatParser.isStartElement(event, ATOM_ENTRY)) {
                rt.add(this.parseEntry(reader, event.asStartElement()));
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_LINK)) {
                if (!"next".equals(event.asStartElement().getAttributeByName(new QName2("rel")).getValue())) continue;
                feed.next = event.asStartElement().getAttributeByName(new QName2("href")).getValue();
                continue;
            }
            if (!AtomFeedFormatParser.isEndElement(event, ATOM_FEED)) continue;
            break;
        }
        feed.entries = Enumerable.create(rt).cast(Entry.class);
        return feed;
    }

    public static Iterable<OProperty<?>> parseProperties(XMLEventReader2 reader, StartElement2 propertiesElement, EdmDataServices metadata) {
        ArrayList rt = new ArrayList();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(propertiesElement.getName())) {
                return rt;
            }
            if (!event.isStartElement() || !event.asStartElement().getName().getNamespaceUri().equals("http://schemas.microsoft.com/ado/2007/08/dataservices")) continue;
            String name = event.asStartElement().getName().getLocalPart();
            Attribute2 typeAttribute = event.asStartElement().getAttributeByName(M_TYPE);
            Attribute2 nullAttribute = event.asStartElement().getAttributeByName(M_NULL);
            boolean isNull = nullAttribute != null && "true".equals(nullAttribute.getValue());
            OProperty<Object> op = null;
            String type = null;
            EdmType et = null;
            if (typeAttribute != null && (et = metadata.resolveType(type = typeAttribute.getValue())) == null) {
                throw new RuntimeException("unknown property type: " + type);
            }
            op = null != et && !et.isSimple() ? OProperties.complex(name, (EdmComplexType)et, isNull ? null : Enumerable.create(AtomFeedFormatParser.parseProperties(reader, event.asStartElement(), metadata)).toList()) : OProperties.parseSimple(name, type, isNull ? null : reader.getElementText());
            rt.add(op);
        }
        throw new RuntimeException();
    }

    private AtomLink parseAtomLink(XMLEventReader2 reader, StartElement2 linkElement) {
        XMLEvent2 event;
        AtomLink rt = new AtomLink();
        rt.relation = AtomFeedFormatParser.getAttributeValueIfExists(linkElement, "rel");
        rt.type = AtomFeedFormatParser.getAttributeValueIfExists(linkElement, "type");
        rt.title = AtomFeedFormatParser.getAttributeValueIfExists(linkElement, "title");
        rt.href = AtomFeedFormatParser.getAttributeValueIfExists(linkElement, "href");
        rt.inlineContentExpected = false;
        while (!(!reader.hasNext() || (event = reader.nextEvent()).isEndElement() && event.asEndElement().getName().equals(linkElement.getName()))) {
            if (AtomFeedFormatParser.isStartElement(event, XmlFormatParser.M_INLINE)) {
                rt.inlineContentExpected = true;
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_FEED)) {
                rt.inlineFeed = this.parseFeed(reader);
                continue;
            }
            if (!AtomFeedFormatParser.isStartElement(event, ATOM_ENTRY)) continue;
            rt.inlineEntry = this.parseEntry(reader, event.asStartElement());
        }
        return rt;
    }

    private DataServicesAtomEntry parseDSAtomEntry(String etag, XMLEventReader2 reader, XMLEvent2 event) {
        DataServicesAtomEntry dsae = new DataServicesAtomEntry();
        dsae.etag = etag;
        dsae.properties = Enumerable.create(AtomFeedFormatParser.parseProperties(reader, event.asStartElement(), this.metadata)).toList();
        return dsae;
    }

    private static String innerText(XMLEventReader2 reader, StartElement2 element) {
        StringWriter sw = new StringWriter();
        XMLEventWriter2 writer = XMLFactoryProvider2.getInstance().newXMLOutputFactory2().createXMLEventWriter(sw);
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(element.getName())) {
                return sw.toString();
            }
            writer.add(event);
        }
        throw new RuntimeException();
    }

    public static String parseEntitySetName(String atomEntryId) {
        Matcher m = ENTITY_SET_NAME.matcher(atomEntryId);
        if (!m.find()) {
            throw new RuntimeException("Unable to parse the entity-set name from atom entry id: " + atomEntryId);
        }
        return m.group(1);
    }

    public static OEntityKey parseEntityKey(String atomEntryId) {
        Matcher m = ENTITY_SET_NAME.matcher(atomEntryId);
        if (!m.find()) {
            throw new RuntimeException("Unable to parse the entity-key from atom entry id: " + atomEntryId);
        }
        return OEntityKey.parse(atomEntryId.substring(m.end() - 1));
    }

    private AtomEntry parseEntry(XMLEventReader2 reader, StartElement2 entryElement) {
        String id = null;
        String categoryTerm = null;
        String categoryScheme = null;
        String title = null;
        String summary = null;
        String updated = null;
        String contentType = null;
        ArrayList<AtomLink> atomLinks = new ArrayList<AtomLink>();
        String etag = AtomFeedFormatParser.getAttributeValueIfExists(entryElement, M_ETAG);
        AtomEntry rt = null;
        block0: while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().equals(entryElement.getName())) {
                rt.id = id;
                rt.title = title;
                rt.summary = summary;
                rt.updated = updated;
                rt.categoryScheme = categoryScheme;
                rt.categoryTerm = categoryTerm;
                rt.contentType = contentType;
                rt.atomLinks = atomLinks;
                if (rt instanceof DataServicesAtomEntry) {
                    EdmFunctionImport efi;
                    EdmEntitySet ees;
                    DataServicesAtomEntry dsae = rt;
                    String entitySetName = this.entitySetName;
                    if (rt.id != null && rt.id.endsWith(")")) {
                        entitySetName = AtomFeedFormatParser.parseEntitySetName(rt.id);
                    }
                    if ((ees = this.metadata.findEdmEntitySet(entitySetName)) == null && (efi = this.metadata.findEdmFunctionImport(entitySetName)) != null) {
                        ees = efi.getEntitySet();
                    }
                    if (ees == null) {
                        throw new RuntimeException("Could not derive the entity-set for entry: " + rt.id);
                    }
                    dsae.setOEntity(this.entityFromAtomEntry(this.metadata, ees, dsae, this.fcMapping));
                }
                return rt;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_ID)) {
                id = reader.getElementText();
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_TITLE)) {
                title = reader.getElementText();
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_SUMMARY)) {
                summary = reader.getElementText();
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_UPDATED)) {
                updated = reader.getElementText();
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_CATEGORY)) {
                categoryTerm = AtomFeedFormatParser.getAttributeValueIfExists(event.asStartElement(), "term");
                categoryScheme = AtomFeedFormatParser.getAttributeValueIfExists(event.asStartElement(), "scheme");
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, ATOM_LINK)) {
                AtomLink link = this.parseAtomLink(reader, event.asStartElement());
                atomLinks.add(link);
                continue;
            }
            if (AtomFeedFormatParser.isStartElement(event, M_PROPERTIES)) {
                rt = this.parseDSAtomEntry(etag, reader, event);
                continue;
            }
            if (!AtomFeedFormatParser.isStartElement(event, ATOM_CONTENT)) continue;
            contentType = AtomFeedFormatParser.getAttributeValueIfExists(event.asStartElement(), "type");
            if ("application/xml".equals(contentType)) {
                StartElement2 contentElement = event.asStartElement();
                StartElement2 valueElement = null;
                while (reader.hasNext()) {
                    XMLEvent2 event2 = reader.nextEvent();
                    if (valueElement == null && event2.isStartElement()) {
                        valueElement = event2.asStartElement();
                        if (AtomFeedFormatParser.isStartElement(event2, M_PROPERTIES)) {
                            rt = this.parseDSAtomEntry(etag, reader, event2);
                        } else {
                            BasicAtomEntry bae = new BasicAtomEntry();
                            bae.content = AtomFeedFormatParser.innerText(reader, event2.asStartElement());
                            rt = bae;
                        }
                    }
                    if (!event2.isEndElement() || !event2.asEndElement().getName().equals(contentElement.getName())) continue;
                    continue block0;
                }
                continue;
            }
            BasicAtomEntry bae = new BasicAtomEntry();
            bae.content = AtomFeedFormatParser.innerText(reader, event.asStartElement());
            rt = bae;
        }
        throw new RuntimeException();
    }

    private OEntity entityFromAtomEntry(EdmDataServices metadata, EdmEntitySet entitySet, DataServicesAtomEntry dsae, FeedCustomizationMapping mapping) {
        OEntityKey key;
        List<OProperty<?>> props = dsae.properties;
        if (mapping != null) {
            Enumerable<OProperty<?>> properties = Enumerable.create(dsae.properties);
            if (mapping.titlePropName != null) {
                properties = properties.concat(OProperties.string(mapping.titlePropName, dsae.title));
            }
            if (mapping.summaryPropName != null) {
                properties = properties.concat(OProperties.string(mapping.summaryPropName, dsae.summary));
            }
            props = properties.toList();
        }
        EdmEntityType entityType = entitySet.getType();
        if (null != dsae.categoryTerm && (entityType = (EdmEntityType)metadata.findEdmEntityType(dsae.categoryTerm)) == null) {
            throw new RuntimeException("Unable to resolve entity type " + dsae.categoryTerm);
        }
        OEntityKey oEntityKey = dsae.id != null ? (dsae.id.endsWith(")") ? AtomFeedFormatParser.parseEntityKey(dsae.id) : OEntityKey.infer(entitySet, props)) : (key = null);
        if (key == null) {
            key = this.entityKey;
        }
        if (key == null) {
            return OEntities.createRequest(entitySet, props, this.toOLinks(metadata, entitySet, dsae.atomLinks, mapping), dsae.title, dsae.categoryTerm);
        }
        return OEntities.create(entitySet, entityType, key, props, this.toOLinks(metadata, entitySet, dsae.atomLinks, mapping), dsae.title, dsae.categoryTerm);
    }

    private List<OLink> toOLinks(final EdmDataServices metadata, EdmEntitySet fromRoleEntitySet, List<AtomLink> links, final FeedCustomizationMapping mapping) {
        ArrayList<OLink> rt = new ArrayList<OLink>(links.size());
        for (AtomLink link : links) {
            EdmEntitySet toRoleEntitySet;
            EdmNavigationProperty navProperty;
            if (!link.relation.startsWith("http://schemas.microsoft.com/ado/2007/08/dataservices/related/")) continue;
            if (link.type.equals("application/atom+xml;type=feed")) {
                if (link.inlineContentExpected) {
                    List<OEntity> relatedEntities = null;
                    if (link.inlineFeed != null && link.inlineFeed.entries != null) {
                        navProperty = fromRoleEntitySet != null ? fromRoleEntitySet.getType().findNavigationProperty(link.title) : null;
                        toRoleEntitySet = metadata != null && navProperty != null ? metadata.getEdmEntitySet(navProperty.getToRole().getType()) : null;
                        relatedEntities = Enumerable.create(link.inlineFeed.entries).cast(DataServicesAtomEntry.class).select(new Func1<DataServicesAtomEntry, OEntity>(){

                            @Override
                            public OEntity apply(DataServicesAtomEntry input) {
                                return AtomFeedFormatParser.this.entityFromAtomEntry(metadata, toRoleEntitySet, input, mapping);
                            }
                        }).toList();
                    }
                    rt.add(OLinks.relatedEntitiesInline(link.relation, link.title, link.href, relatedEntities));
                    continue;
                }
                rt.add(OLinks.relatedEntities(link.relation, link.title, link.href));
                continue;
            }
            if (!link.type.equals("application/atom+xml;type=entry")) continue;
            if (link.inlineContentExpected) {
                OEntity relatedEntity = null;
                if (null != link.inlineEntry) {
                    navProperty = fromRoleEntitySet != null ? fromRoleEntitySet.getType().findNavigationProperty(link.title) : null;
                    toRoleEntitySet = metadata != null && navProperty != null ? metadata.getEdmEntitySet(navProperty.getToRole().getType()) : null;
                    relatedEntity = this.entityFromAtomEntry(metadata, toRoleEntitySet, (DataServicesAtomEntry)link.inlineEntry, mapping);
                }
                rt.add(OLinks.relatedEntityInline(link.relation, link.title, link.href, relatedEntity));
                continue;
            }
            rt.add(OLinks.relatedEntity(link.relation, link.title, link.href));
        }
        return rt;
    }

    public static class DataServicesAtomEntry
    extends AtomEntry {
        public String etag;
        public List<OProperty<?>> properties;
        public List<OLink> links;
        private OEntity oentity;

        public String toString() {
            return InternalUtil.reflectionToString(this);
        }

        @Override
        public OEntity getEntity() {
            return this.oentity;
        }

        void setOEntity(OEntity oentity) {
            this.oentity = oentity;
        }
    }

    static class BasicAtomEntry
    extends AtomEntry {
        public String content;

        BasicAtomEntry() {
        }

        public String toString() {
            return InternalUtil.reflectionToString(this);
        }

        @Override
        public OEntity getEntity() {
            return null;
        }
    }

    static class AtomLink {
        public String relation;
        public String title;
        public String type;
        public String href;
        public AtomFeed inlineFeed;
        public AtomEntry inlineEntry;
        public boolean inlineContentExpected;

        AtomLink() {
        }
    }

    static abstract class AtomEntry
    implements Entry {
        public String id;
        public String title;
        public String summary;
        public String updated;
        public String categoryTerm;
        public String categoryScheme;
        public String contentType;
        public List<AtomLink> atomLinks;

        AtomEntry() {
        }

        @Override
        public String getUri() {
            return null;
        }

        @Override
        public String getETag() {
            return null;
        }

        public String getType() {
            return "application/atom+xml";
        }
    }

    public static class AtomFeed
    implements Feed {
        public String next;
        public Iterable<Entry> entries;

        @Override
        public Iterable<Entry> getEntries() {
            return this.entries;
        }

        @Override
        public String getNext() {
            return this.next;
        }
    }
}

