/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.core4j.Enumerable;
import org.core4j.Func1;
import org.core4j.Predicate1;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OPredicates;
import org.odata4j.core.PrefixedNamespace;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmAssociationSet;
import org.odata4j.edm.EdmAssociationSetEnd;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmFunctionParameter;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmType;
import org.odata4j.format.xml.XmlFormatParser;
import org.odata4j.stax2.Attribute2;
import org.odata4j.stax2.QName2;
import org.odata4j.stax2.StartElement2;
import org.odata4j.stax2.XMLEvent2;
import org.odata4j.stax2.XMLEventReader2;

public class EdmxFormatParser
extends XmlFormatParser {
    private final EdmDataServices.Builder dataServices = EdmDataServices.newBuilder();

    public EdmDataServices parseMetadata(XMLEventReader2 reader) {
        ArrayList<EdmSchema.Builder> schemas = new ArrayList<EdmSchema.Builder>();
        List<PrefixedNamespace> namespaces = null;
        ODataVersion version = null;
        boolean foundDataServices = false;
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            boolean shouldReturn = false;
            if (EdmxFormatParser.isStartElement(event, XmlFormatParser.EDMX_EDMX)) {
                // empty if block
            }
            if (EdmxFormatParser.isStartElement(event, EDMX_DATASERVICES)) {
                foundDataServices = true;
                String str = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), new QName2("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "DataServiceVersion"));
                ODataVersion oDataVersion = version = str != null ? ODataVersion.parse(str) : null;
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_SCHEMA, EDM2007_SCHEMA, EDM2008_SCHEMA, EDM2009_SCHEMA)) {
                schemas.add(this.parseEdmSchema(reader, event.asStartElement()));
                if (!foundDataServices) {
                    shouldReturn = true;
                }
            }
            if (EdmxFormatParser.isEndElement(event, EDMX_DATASERVICES)) {
                shouldReturn = true;
            }
            if (!shouldReturn) continue;
            this.dataServices.setVersion(version).addSchemas(schemas).addNamespaces(namespaces);
            this.resolve();
            return this.dataServices.build();
        }
        throw new UnsupportedOperationException();
    }

    private void resolve() {
        Map<String, EdmEntityType.Builder> allEetsByFQName = Enumerable.create(this.dataServices.getEntityTypes()).toMap(new Func1<EdmEntityType.Builder, String>(){

            @Override
            public String apply(EdmEntityType.Builder input) {
                return input.getFQAliasName() != null ? input.getFQAliasName() : input.getFullyQualifiedTypeName();
            }
        });
        Map<String, EdmAssociation.Builder> allEasByFQName = Enumerable.create(this.dataServices.getAssociations()).toMap(new Func1<EdmAssociation.Builder, String>(){

            @Override
            public String apply(EdmAssociation.Builder input) {
                return input.getFQAliasName() != null ? input.getFQAliasName() : input.getFQNamespaceName();
            }
        });
        for (EdmSchema.Builder edmSchema : this.dataServices.getSchemas()) {
            for (int i = 0; i < edmSchema.getAssociations().size(); ++i) {
                EdmAssociation.Builder builder = edmSchema.getAssociations().get(i);
                builder.getEnd1().setType(allEetsByFQName.get(builder.getEnd1().getTypeName()));
                builder.getEnd2().setType(allEetsByFQName.get(builder.getEnd2().getTypeName()));
            }
            for (EdmEntityType.Builder builder : edmSchema.getEntityTypes()) {
                List<EdmNavigationProperty.Builder> navProps = builder.getNavigationProperties();
                for (int i = 0; i < navProps.size(); ++i) {
                    EdmNavigationProperty.Builder tmp = navProps.get(i);
                    final EdmAssociation.Builder ea = allEasByFQName.get(tmp.getRelationshipName());
                    List<EdmAssociationEnd.Builder> finalEnds = Enumerable.create(tmp.getFromRoleName(), tmp.getToRoleName()).select(new Func1<String, EdmAssociationEnd.Builder>(){

                        @Override
                        public EdmAssociationEnd.Builder apply(String input) {
                            if (ea.getEnd1().getRole().equals(input)) {
                                return ea.getEnd1();
                            }
                            if (ea.getEnd2().getRole().equals(input)) {
                                return ea.getEnd2();
                            }
                            throw new IllegalArgumentException("Invalid role name " + input);
                        }
                    }).toList();
                    tmp.setRelationship(ea).setFromTo(finalEnds.get(0), finalEnds.get(1));
                }
            }
            for (EdmEntityContainer.Builder builder : edmSchema.getEntityContainers()) {
                for (int i = 0; i < builder.getEntitySets().size(); ++i) {
                    EdmEntitySet.Builder tmpEes = builder.getEntitySets().get(i);
                    EdmEntityType.Builder eet = allEetsByFQName.get(tmpEes.getEntityTypeName());
                    if (eet == null) {
                        throw new IllegalArgumentException("Invalid entity type " + tmpEes.getEntityTypeName());
                    }
                    builder.getEntitySets().set(i, EdmEntitySet.newBuilder().setName(tmpEes.getName()).setEntityType(eet));
                }
            }
            for (final EdmEntityContainer.Builder builder : edmSchema.getEntityContainers()) {
                for (int i = 0; i < builder.getAssociationSets().size(); ++i) {
                    EdmAssociationSet.Builder tmpEas = builder.getAssociationSets().get(i);
                    final EdmAssociation.Builder ea = allEasByFQName.get(tmpEas.getAssociationName());
                    List<EdmAssociationSetEnd.Builder> finalEnds = Enumerable.create(tmpEas.getEnd1(), tmpEas.getEnd2()).select(new Func1<EdmAssociationSetEnd.Builder, EdmAssociationSetEnd.Builder>(){

                        @Override
                        public EdmAssociationSetEnd.Builder apply(EdmAssociationSetEnd.Builder input) {
                            EdmAssociationEnd.Builder eae;
                            EdmAssociationEnd.Builder builder2 = ea.getEnd1().getRole().equals(input.getRoleName()) ? ea.getEnd1() : (eae = ea.getEnd2().getRole().equals(input.getRoleName()) ? ea.getEnd2() : null);
                            if (eae == null) {
                                throw new IllegalArgumentException("Invalid role name " + input.getRoleName());
                            }
                            EdmEntitySet.Builder ees = Enumerable.create(builder.getEntitySets()).first(OPredicates.nameEquals(EdmEntitySet.Builder.class, input.getEntitySetName()));
                            return EdmAssociationSetEnd.newBuilder().setRole(eae).setEntitySet(ees);
                        }
                    }).toList();
                    tmpEas.setAssociation(ea).setEnds(finalEnds.get(0), finalEnds.get(1));
                }
            }
            for (EdmEntityContainer.Builder builder : edmSchema.getEntityContainers()) {
                for (int i = 0; i < builder.getFunctionImports().size(); ++i) {
                    final EdmFunctionImport.Builder tmpEfi = builder.getFunctionImports().get(i);
                    EdmEntitySet.Builder ees = Enumerable.create(builder.getEntitySets()).firstOrNull(new Predicate1<EdmEntitySet.Builder>(){

                        @Override
                        public boolean apply(EdmEntitySet.Builder input) {
                            return input.getName().equals(tmpEfi.getEntitySetName());
                        }
                    });
                    EdmCollectionType.Builder typeBuilder = null;
                    if (tmpEfi.getReturnTypeName() != null) {
                        typeBuilder = this.dataServices.resolveType(tmpEfi.getReturnTypeName());
                        if (typeBuilder == null) {
                            throw new RuntimeException("Edm-type not found: " + tmpEfi.getReturnTypeName());
                        }
                        if (tmpEfi.isCollection()) {
                            typeBuilder = EdmCollectionType.newBuilder().setKind(EdmProperty.CollectionKind.Collection).setCollectionType(typeBuilder);
                        }
                    }
                    builder.getFunctionImports().set(i, EdmFunctionImport.newBuilder().setName(tmpEfi.getName()).setEntitySet(ees).setReturnType(typeBuilder).setHttpMethod(tmpEfi.getHttpMethod()).addParameters(tmpEfi.getParameters()));
                }
            }
            for (Map.Entry entry : allEetsByFQName.entrySet()) {
                String baseTypeName = ((EdmEntityType.Builder)entry.getValue()).getFQBaseTypeName();
                if (null == baseTypeName) continue;
                EdmEntityType.Builder baseType = allEetsByFQName.get(baseTypeName);
                if (baseType == null) {
                    throw new IllegalArgumentException("Invalid baseType: " + baseTypeName);
                }
                ((EdmEntityType.Builder)entry.getValue()).setBaseType(baseType);
            }
        }
    }

    private EdmSchema.Builder parseEdmSchema(XMLEventReader2 reader, StartElement2 schemaElement) {
        String schemaNamespace = schemaElement.getAttributeByName(new QName2("Namespace")).getValue();
        String schemaAlias = EdmxFormatParser.getAttributeValueIfExists(schemaElement, new QName2("Alias"));
        ArrayList<EdmEntityType.Builder> edmEntityTypes = new ArrayList<EdmEntityType.Builder>();
        ArrayList<EdmComplexType.Builder> edmComplexTypes = new ArrayList<EdmComplexType.Builder>();
        ArrayList<EdmAssociation.Builder> edmAssociations = new ArrayList<EdmAssociation.Builder>();
        ArrayList<EdmEntityContainer.Builder> edmEntityContainers = new ArrayList<EdmEntityContainer.Builder>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_ENTITYTYPE, EDM2007_ENTITYTYPE, EDM2008_ENTITYTYPE, EDM2009_ENTITYTYPE)) {
                EdmEntityType.Builder edmEntityType = this.parseEdmEntityType(reader, schemaNamespace, schemaAlias, event.asStartElement());
                edmEntityTypes.add(edmEntityType);
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_ASSOCIATION, EDM2007_ASSOCIATION, EDM2008_ASSOCIATION, EDM2009_ASSOCIATION)) {
                EdmAssociation.Builder edmAssociation = this.parseEdmAssociation(reader, schemaNamespace, schemaAlias, event.asStartElement());
                edmAssociations.add(edmAssociation);
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_COMPLEXTYPE, EDM2007_COMPLEXTYPE, EDM2008_COMPLEXTYPE, EDM2009_COMPLEXTYPE)) {
                EdmComplexType.Builder edmComplexType = this.parseEdmComplexType(reader, schemaNamespace, event.asStartElement());
                edmComplexTypes.add(edmComplexType);
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_ENTITYCONTAINER, EDM2007_ENTITYCONTAINER, EDM2008_ENTITYCONTAINER, EDM2009_ENTITYCONTAINER)) {
                EdmEntityContainer.Builder edmEntityContainer = this.parseEdmEntityContainer(reader, schemaNamespace, event.asStartElement());
                edmEntityContainers.add(edmEntityContainer);
            }
            if (!EdmxFormatParser.isEndElement(event, schemaElement.getName())) continue;
            return EdmSchema.newBuilder().setNamespace(schemaNamespace).setAlias(schemaAlias).addEntityTypes(edmEntityTypes).addComplexTypes(edmComplexTypes).addAssociations(edmAssociations).addEntityContainers(edmEntityContainers);
        }
        throw new UnsupportedOperationException();
    }

    private EdmEntityContainer.Builder parseEdmEntityContainer(XMLEventReader2 reader, String schemaNamespace, StartElement2 entityContainerElement) {
        String name = entityContainerElement.getAttributeByName("Name").getValue();
        boolean isDefault = "true".equals(EdmxFormatParser.getAttributeValueIfExists(entityContainerElement, new QName2("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "IsDefaultEntityContainer")));
        String lazyLoadingEnabledValue = EdmxFormatParser.getAttributeValueIfExists(entityContainerElement, new QName2("http://schemas.microsoft.com/ado/2009/02/edm/annotation", "LazyLoadingEnabled"));
        Boolean lazyLoadingEnabled = lazyLoadingEnabledValue == null ? null : Boolean.valueOf(lazyLoadingEnabledValue.equals("true"));
        ArrayList<EdmEntitySet.Builder> edmEntitySets = new ArrayList<EdmEntitySet.Builder>();
        ArrayList<EdmAssociationSet.Builder> edmAssociationSets = new ArrayList<EdmAssociationSet.Builder>();
        ArrayList<EdmFunctionImport.Builder> edmFunctionImports = new ArrayList<EdmFunctionImport.Builder>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_ENTITYSET, EDM2007_ENTITYSET, EDM2008_ENTITYSET, EDM2009_ENTITYSET)) {
                edmEntitySets.add(EdmEntitySet.newBuilder().setName(EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), "Name")).setEntityTypeName(EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), "EntityType")));
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_ASSOCIATIONSET, EDM2007_ASSOCIATIONSET, EDM2008_ASSOCIATIONSET, EDM2009_ASSOCIATIONSET)) {
                edmAssociationSets.add(this.parseEdmAssociationSet(reader, schemaNamespace, event.asStartElement()));
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_FUNCTIONIMPORT, EDM2007_FUNCTIONIMPORT, EDM2008_FUNCTIONIMPORT, EDM2009_FUNCTIONIMPORT)) {
                edmFunctionImports.add(this.parseEdmFunctionImport(reader, schemaNamespace, event.asStartElement()));
            }
            if (!EdmxFormatParser.isEndElement(event, entityContainerElement.getName())) continue;
            return EdmEntityContainer.newBuilder().setName(name).setIsDefault(isDefault).setLazyLoadingEnabled(lazyLoadingEnabled).addEntitySets(edmEntitySets).addAssociationSets(edmAssociationSets).addFunctionImports(edmFunctionImports);
        }
        throw new UnsupportedOperationException();
    }

    private EdmFunctionImport.Builder parseEdmFunctionImport(XMLEventReader2 reader, String schemaNamespace, StartElement2 functionImportElement) {
        boolean isCollection;
        String name = functionImportElement.getAttributeByName("Name").getValue();
        String entitySet = EdmxFormatParser.getAttributeValueIfExists(functionImportElement, "EntitySet");
        Attribute2 returnTypeAttr = functionImportElement.getAttributeByName("ReturnType");
        String returnType = returnTypeAttr != null ? returnTypeAttr.getValue() : null;
        boolean bl = isCollection = null != returnType && returnType.matches("^Collection\\(.*\\)$");
        if (isCollection) {
            returnType = returnType.substring(11, returnType.length() - 1);
        }
        String httpMethod = EdmxFormatParser.getAttributeValueIfExists(functionImportElement, new QName2("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HttpMethod"));
        ArrayList<EdmFunctionParameter.Builder> parameters = new ArrayList<EdmFunctionParameter.Builder>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_PARAMETER, EDM2007_PARAMETER, EDM2008_PARAMETER, EDM2009_PARAMETER)) {
                Attribute2 modeAttribute = event.asStartElement().getAttributeByName("Mode");
                parameters.add(EdmFunctionParameter.newBuilder().setName(event.asStartElement().getAttributeByName("Name").getValue()).setType(EdmType.newDeferredBuilder(event.asStartElement().getAttributeByName("Type").getValue(), this.dataServices)).setMode(modeAttribute != null ? EdmFunctionParameter.Mode.valueOf(modeAttribute.getValue()) : null));
            }
            if (!EdmxFormatParser.isEndElement(event, functionImportElement.getName())) continue;
            return EdmFunctionImport.newBuilder().setName(name).setEntitySetName(entitySet).setReturnTypeName(returnType).setIsCollection(isCollection).setHttpMethod(httpMethod).addParameters(parameters);
        }
        throw new UnsupportedOperationException();
    }

    private EdmAssociationSet.Builder parseEdmAssociationSet(XMLEventReader2 reader, String schemaNamespace, StartElement2 associationSetElement) {
        String name = associationSetElement.getAttributeByName("Name").getValue();
        String associationName = associationSetElement.getAttributeByName("Association").getValue();
        ArrayList<EdmAssociationSetEnd.Builder> ends = new ArrayList<EdmAssociationSetEnd.Builder>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_END, EDM2007_END, EDM2008_END, EDM2009_END)) {
                ends.add(EdmAssociationSetEnd.newBuilder().setRoleName(event.asStartElement().getAttributeByName("Role").getValue()).setEntitySetName(event.asStartElement().getAttributeByName("EntitySet").getValue()));
            }
            if (!EdmxFormatParser.isEndElement(event, associationSetElement.getName())) continue;
            return EdmAssociationSet.newBuilder().setName(name).setAssociationName(associationName).setEnds((EdmAssociationSetEnd.Builder)ends.get(0), (EdmAssociationSetEnd.Builder)ends.get(1));
        }
        throw new UnsupportedOperationException();
    }

    private EdmAssociation.Builder parseEdmAssociation(XMLEventReader2 reader, String schemaNamespace, String schemaAlias, StartElement2 associationElement) {
        String name = associationElement.getAttributeByName("Name").getValue();
        ArrayList<EdmAssociationEnd.Builder> ends = new ArrayList<EdmAssociationEnd.Builder>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_END, EDM2007_END, EDM2008_END, EDM2009_END)) {
                ends.add(EdmAssociationEnd.newBuilder().setRole(event.asStartElement().getAttributeByName("Role").getValue()).setTypeName(event.asStartElement().getAttributeByName("Type").getValue()).setMultiplicity(EdmMultiplicity.fromSymbolString(event.asStartElement().getAttributeByName("Multiplicity").getValue())));
            }
            if (!EdmxFormatParser.isEndElement(event, associationElement.getName())) continue;
            return EdmAssociation.newBuilder().setNamespace(schemaNamespace).setAlias(schemaAlias).setName(name).setEnds((EdmAssociationEnd.Builder)ends.get(0), (EdmAssociationEnd.Builder)ends.get(1));
        }
        throw new UnsupportedOperationException();
    }

    private EdmProperty.Builder parseEdmProperty(XMLEvent2 event) {
        String propertyName = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), "Name");
        String propertyType = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), "Type");
        String propertyNullable = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), "Nullable");
        String maxLength = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), "MaxLength");
        String unicode = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), "Unicode");
        String fixedLength = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), "FixedLength");
        String collectionKindS = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), "CollectionKind");
        EdmProperty.CollectionKind ckind = EdmProperty.CollectionKind.NONE;
        if (null != collectionKindS) {
            ckind = Enum.valueOf(EdmProperty.CollectionKind.class, collectionKindS);
        }
        String defaultValue = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), "DefaultValue");
        String precision = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), "Precision");
        String scale = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), "Scale");
        String storeGeneratedPattern = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), new QName2("http://schemas.microsoft.com/ado/2009/02/edm/annotation", "StoreGeneratedPattern"));
        String fcTargetPath = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), M_FC_TARGETPATH);
        String fcContentKind = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), M_FC_CONTENTKIND);
        String fcKeepInContent = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), M_FC_KEEPINCONTENT);
        String fcEpmContentKind = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), M_FC_EPMCONTENTKIND);
        String fcEpmKeepInContent = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), M_FC_EPMKEEPINCONTENT);
        return EdmProperty.newBuilder(propertyName).setType(EdmType.newDeferredBuilder(propertyType, this.dataServices)).setNullable("false".equals(propertyNullable)).setMaxLength(maxLength == null ? null : Integer.valueOf(maxLength.equals("Max") ? Integer.MAX_VALUE : Integer.parseInt(maxLength))).setUnicode("false".equals(unicode)).setFixedLength("false".equals(fixedLength)).setStoreGeneratedPattern(storeGeneratedPattern).setFcTargetPath(fcTargetPath).setFcContentKind(fcContentKind).setFcKeepInContent(fcKeepInContent).setFcEpmContentKind(fcEpmContentKind).setFcEpmKeepInContent(fcEpmKeepInContent).setCollectionKind(ckind).setDefaultValue(defaultValue).setPrecision(precision == null ? null : Integer.valueOf(Integer.parseInt(precision))).setScale(scale == null ? null : Integer.valueOf(Integer.parseInt(scale)));
    }

    private EdmComplexType.Builder parseEdmComplexType(XMLEventReader2 reader, String schemaNamespace, StartElement2 complexTypeElement) {
        String name = complexTypeElement.getAttributeByName("Name").getValue();
        String isAbstractS = EdmxFormatParser.getAttributeValueIfExists(complexTypeElement, "Abstract");
        ArrayList<EdmProperty.Builder> edmProperties = new ArrayList<EdmProperty.Builder>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_PROPERTY, EDM2007_PROPERTY, EDM2008_PROPERTY, EDM2009_PROPERTY)) {
                edmProperties.add(this.parseEdmProperty(event));
            }
            if (!EdmxFormatParser.isEndElement(event, complexTypeElement.getName())) continue;
            EdmComplexType.Builder complexType = (EdmComplexType.Builder)((EdmComplexType.Builder)((EdmComplexType.Builder)EdmComplexType.newBuilder().setNamespace(schemaNamespace)).setName(name)).addProperties(edmProperties);
            if (isAbstractS != null) {
                complexType.setIsAbstract("true".equals(isAbstractS));
            }
            return complexType;
        }
        throw new UnsupportedOperationException();
    }

    private EdmEntityType.Builder parseEdmEntityType(XMLEventReader2 reader, String schemaNamespace, String schemaAlias, StartElement2 entityTypeElement) {
        String name = entityTypeElement.getAttributeByName("Name").getValue();
        String hasStreamValue = EdmxFormatParser.getAttributeValueIfExists(entityTypeElement, new QName2("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HasStream"));
        Boolean hasStream = hasStreamValue == null ? null : Boolean.valueOf(hasStreamValue.equals("true"));
        String baseType = EdmxFormatParser.getAttributeValueIfExists(entityTypeElement, "BaseType");
        String isAbstractS = EdmxFormatParser.getAttributeValueIfExists(entityTypeElement, "Abstract");
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<EdmProperty.Builder> edmProperties = new ArrayList<EdmProperty.Builder>();
        ArrayList<EdmNavigationProperty.Builder> edmNavigationProperties = new ArrayList<EdmNavigationProperty.Builder>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_PROPERTYREF, EDM2007_PROPERTYREF, EDM2008_PROPERTYREF, EDM2009_PROPERTYREF)) {
                keys.add(event.asStartElement().getAttributeByName("Name").getValue());
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_PROPERTY, EDM2007_PROPERTY, EDM2008_PROPERTY, EDM2009_PROPERTY)) {
                edmProperties.add(this.parseEdmProperty(event));
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_NAVIGATIONPROPERTY, EDM2007_NAVIGATIONPROPERTY, EDM2008_NAVIGATIONPROPERTY, EDM2009_NAVIGATIONPROPERTY)) {
                String associationName = event.asStartElement().getAttributeByName("Name").getValue();
                String relationshipName = event.asStartElement().getAttributeByName("Relationship").getValue();
                String fromRoleName = event.asStartElement().getAttributeByName("FromRole").getValue();
                String toRoleName = event.asStartElement().getAttributeByName("ToRole").getValue();
                edmNavigationProperties.add(EdmNavigationProperty.newBuilder(associationName).setRelationshipName(relationshipName).setFromToName(fromRoleName, toRoleName));
            }
            if (!EdmxFormatParser.isEndElement(event, entityTypeElement.getName())) continue;
            return (EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setNamespace(schemaNamespace)).setAlias(schemaAlias).setName(name)).setHasStream(hasStream).addKeys(keys).addProperties(edmProperties)).addNavigationProperties(edmNavigationProperties).setBaseType(baseType).setIsAbstract(isAbstractS == null ? null : Boolean.valueOf("true".equals(isAbstractS)));
        }
        throw new UnsupportedOperationException();
    }
}

