/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.odata4j.core.OCollection;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityId;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.producer.CollectionResponse;
import org.odata4j.producer.ComplexObjectResponse;
import org.odata4j.producer.CountResponse;
import org.odata4j.producer.EntitiesResponse;
import org.odata4j.producer.EntityIdResponse;
import org.odata4j.producer.EntityResponse;
import org.odata4j.producer.PropertyResponse;

public class Responses {
    private Responses() {
    }

    public static EntitiesResponse entities(final List<OEntity> entities, final EdmEntitySet entitySet, final Integer inlineCount, final String skipToken) {
        return new EntitiesResponse(){

            @Override
            public List<OEntity> getEntities() {
                return entities;
            }

            @Override
            public EdmEntitySet getEntitySet() {
                return entitySet;
            }

            @Override
            public Integer getInlineCount() {
                return inlineCount;
            }

            @Override
            public String getSkipToken() {
                return skipToken;
            }
        };
    }

    public static CountResponse count(final long count) {
        return new CountResponse(){

            @Override
            public long getCount() {
                return count;
            }
        };
    }

    public static EntityResponse entity(final OEntity entity) {
        return new EntityResponse(){

            @Override
            public OEntity getEntity() {
                return entity;
            }
        };
    }

    public static PropertyResponse property(final OProperty<?> property) {
        return new PropertyResponse(){

            @Override
            public OProperty<?> getProperty() {
                return property;
            }
        };
    }

    public static <T extends OEntityId> EntityIdResponse singleId(T entityId) {
        final ArrayList<T> entities = new ArrayList<T>();
        entities.add(entityId);
        return new EntityIdResponse(){

            @Override
            public EdmMultiplicity getMultiplicity() {
                return EdmMultiplicity.ONE;
            }

            @Override
            public Collection<OEntityId> getEntities() {
                return entities;
            }
        };
    }

    public static <T extends OEntityId> EntityIdResponse multipleIds(Iterable<T> entityIds) {
        final ArrayList<OEntityId> entities = new ArrayList<OEntityId>();
        for (OEntityId entityId : entityIds) {
            entities.add(entityId);
        }
        return new EntityIdResponse(){

            @Override
            public EdmMultiplicity getMultiplicity() {
                return EdmMultiplicity.MANY;
            }

            @Override
            public Collection<OEntityId> getEntities() {
                return entities;
            }
        };
    }

    public static ComplexObjectResponse complexObject(final OComplexObject complexObject) {
        return new ComplexObjectResponse(){

            @Override
            public OComplexObject getObject() {
                return complexObject;
            }
        };
    }

    public static <T extends OObject> CollectionResponse<?> collection(final OCollection<T> collection) {
        return new CollectionResponse<T>(){

            @Override
            public OCollection<T> getCollection() {
                return collection;
            }
        };
    }
}

