/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmAssociationSet;
import org.odata4j.edm.EdmAssociationSetEnd;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmDecorator;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmGenerator;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.format.xml.XmlFormatParser;
import org.odata4j.producer.edm.Edm;

public class MetadataEdmGenerator
implements EdmGenerator {
    private EdmDecorator decorator = null;
    private EdmSchema.Builder schema = null;
    private EdmEntityContainer.Builder container = null;
    private EdmComplexType.Builder entityKeyType = null;
    private EdmComplexType.Builder documentationType = null;
    private List<EdmAssociation.Builder> assocs = new LinkedList<EdmAssociation.Builder>();
    private List<EdmComplexType.Builder> ctypes = new LinkedList<EdmComplexType.Builder>();
    private List<EdmEntityType.Builder> etypes = new LinkedList<EdmEntityType.Builder>();
    private List<EdmEntitySet.Builder> esets = new LinkedList<EdmEntitySet.Builder>();
    private List<EdmAssociationSet.Builder> asets = new LinkedList<EdmAssociationSet.Builder>();

    @Override
    public EdmDataServices.Builder generateEdm(EdmDecorator decorator) {
        this.createComplexTypes();
        this.createEntityTypes();
        this.container = EdmEntityContainer.newBuilder().setName("EdmContainer").setIsDefault(true).setLazyLoadingEnabled(Boolean.TRUE).addEntitySets(this.esets).addAssociationSets(this.asets);
        this.schema = EdmSchema.newBuilder().setNamespace("com.microsoft.schemas.ado._2008._09.edm").addEntityTypes(this.etypes).addComplexTypes(this.ctypes).addAssociations(this.assocs).addEntityContainers(this.container);
        return EdmDataServices.newBuilder().addSchemas(this.schema);
    }

    private void createComplexTypes() {
        ArrayList<EdmProperty.Builder> props = new ArrayList<EdmProperty.Builder>();
        EdmProperty.Builder ep = EdmProperty.newBuilder("Name").setType(EdmSimpleType.STRING);
        props.add(ep);
        EdmComplexType.Builder propertyRef = (EdmComplexType.Builder)((EdmComplexType.Builder)((EdmComplexType.Builder)EdmComplexType.newBuilder().setNamespace("com.microsoft.schemas.ado._2008._09.edm")).setName(XmlFormatParser.EDM2008_PROPERTYREF.getLocalPart())).addProperties(props);
        this.ctypes.add(propertyRef);
        props = new ArrayList();
        ep = EdmProperty.newBuilder("Keys").setType(propertyRef).setCollectionKind(EdmProperty.CollectionKind.List);
        props.add(ep);
        this.entityKeyType = (EdmComplexType.Builder)((EdmComplexType.Builder)((EdmComplexType.Builder)EdmComplexType.newBuilder().setNamespace("com.microsoft.schemas.ado._2008._09.edm")).setName(Edm.EntityKey.name())).addProperties(props);
        this.ctypes.add(this.entityKeyType);
        props = new ArrayList();
        ep = EdmProperty.newBuilder("Summary").setType(EdmSimpleType.STRING).setNullable(true);
        props.add(ep);
        ep = EdmProperty.newBuilder("LongDescription").setType(EdmSimpleType.STRING).setNullable(true);
        props.add(ep);
        this.documentationType = (EdmComplexType.Builder)((EdmComplexType.Builder)((EdmComplexType.Builder)EdmComplexType.newBuilder().setNamespace("com.microsoft.schemas.ado._2008._09.edm")).setName(Edm.Documentation.name())).addProperties(props);
        this.ctypes.add(this.documentationType);
    }

    private void createEntityTypes() {
        List<EdmProperty.Builder> props = new ArrayList<EdmProperty.Builder>();
        ArrayList<EdmNavigationProperty.Builder> navprops = new ArrayList<EdmNavigationProperty.Builder>();
        EdmProperty.Builder ep = null;
        ep = EdmProperty.newBuilder("Namespace").setType(EdmSimpleType.STRING);
        props.add(ep);
        ep = EdmProperty.newBuilder("Alias").setType(EdmSimpleType.STRING).setNullable(true);
        props.add(ep);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("Namespace");
        EdmEntityType.Builder schemaType = ((EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setNamespace("com.microsoft.schemas.ado._2008._09.edm")).setName(Edm.Schema.name())).addKeys(keys).addProperties(props)).addNavigationProperties(navprops);
        if (this.decorator != null) {
            schemaType.setDocumentation(this.decorator.getDocumentationForEntityType("com.microsoft.schemas.ado._2008._09.edm", Edm.Schema.name()));
            schemaType.setAnnotations((List)this.decorator.getAnnotationsForEntityType("com.microsoft.schemas.ado._2008._09.edm", Edm.Schema.name()));
        }
        this.etypes.add(schemaType);
        EdmEntitySet.Builder schemaSet = EdmEntitySet.newBuilder().setName("Schemas").setEntityType(schemaType);
        this.esets.add(schemaSet);
        props = new ArrayList();
        navprops = new ArrayList();
        ep = EdmProperty.newBuilder("Namespace").setType(EdmSimpleType.STRING);
        props.add(ep);
        ep = EdmProperty.newBuilder("Name").setType(EdmSimpleType.STRING);
        props.add(ep);
        ep = EdmProperty.newBuilder("BaseType").setType(EdmSimpleType.STRING).setNullable(true);
        props.add(ep);
        ep = EdmProperty.newBuilder("Abstract").setType(EdmSimpleType.BOOLEAN).setNullable(true);
        props.add(ep);
        keys = new ArrayList();
        keys.add("Namespace");
        keys.add("Name");
        EdmEntityType.Builder structuralType = ((EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setNamespace("com.microsoft.schemas.ado._2008._09.edm")).setName(Edm.StructuralType.name())).addKeys(keys).addProperties(props)).addNavigationProperties(navprops);
        if (this.decorator != null) {
            schemaType.setDocumentation(this.decorator.getDocumentationForEntityType("com.microsoft.schemas.ado._2008._09.edm", Edm.StructuralType.name()));
            schemaType.setAnnotations((List)this.decorator.getAnnotationsForEntityType("com.microsoft.schemas.ado._2008._09.edm", Edm.StructuralType.name()));
        }
        this.etypes.add(structuralType);
        props = Collections.emptyList();
        navprops = new ArrayList();
        EdmEntityType.Builder complexType = ((EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setNamespace("com.microsoft.schemas.ado._2008._09.edm")).setName(Edm.ComplexType.name())).setBaseType(structuralType).addProperties(props)).addNavigationProperties(navprops);
        if (this.decorator != null) {
            schemaType.setDocumentation(this.decorator.getDocumentationForEntityType("com.microsoft.schemas.ado._2008._09.edm", Edm.ComplexType.name()));
            schemaType.setAnnotations((List)this.decorator.getAnnotationsForEntityType("com.microsoft.schemas.ado._2008._09.edm", Edm.ComplexType.name()));
        }
        this.etypes.add(complexType);
        EdmEntitySet.Builder complexSet = EdmEntitySet.newBuilder().setName("ComplexTypes").setEntityType(complexType);
        this.esets.add(complexSet);
        EdmEntitySet.Builder rootComplexTypesSet = EdmEntitySet.newBuilder().setName("RootComplexTypes").setEntityType(complexType);
        this.esets.add(rootComplexTypesSet);
        props = new ArrayList();
        navprops = new ArrayList();
        ep = EdmProperty.newBuilder("Key").setType(this.entityKeyType).setNullable(true);
        props.add(ep);
        EdmEntityType.Builder entityType = ((EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setNamespace("com.microsoft.schemas.ado._2008._09.edm")).setName(Edm.EntityType.name())).setBaseType(structuralType).addProperties(props)).addNavigationProperties(navprops);
        if (this.decorator != null) {
            entityType.setDocumentation(this.decorator.getDocumentationForEntityType("com.microsoft.schemas.ado._2008._09.edm", Edm.EntityType.name()));
            entityType.setAnnotations((List)this.decorator.getAnnotationsForEntityType("com.microsoft.schemas.ado._2008._09.edm", Edm.EntityType.name()));
        }
        this.etypes.add(entityType);
        EdmEntitySet.Builder entitySet = EdmEntitySet.newBuilder().setName("EntityTypes").setEntityType(entityType);
        this.esets.add(entitySet);
        EdmEntitySet.Builder rootEntitiesSet = EdmEntitySet.newBuilder().setName("RootEntityTypes").setEntityType(entityType);
        this.esets.add(rootEntitiesSet);
        props = new ArrayList();
        navprops = new ArrayList();
        ep = EdmProperty.newBuilder("Namespace").setType(EdmSimpleType.STRING);
        props.add(ep);
        ep = EdmProperty.newBuilder("EntityTypeName").setType(EdmSimpleType.STRING);
        props.add(ep);
        ep = EdmProperty.newBuilder("Name").setType(EdmSimpleType.STRING);
        props.add(ep);
        ep = EdmProperty.newBuilder("Type").setType(EdmSimpleType.STRING);
        props.add(ep);
        ep = EdmProperty.newBuilder("Nullable").setType(EdmSimpleType.BOOLEAN).setNullable(true);
        props.add(ep);
        ep = EdmProperty.newBuilder("DefaultValue").setType(EdmSimpleType.STRING).setNullable(true);
        props.add(ep);
        ep = EdmProperty.newBuilder("MaxLength").setType(EdmSimpleType.INT32).setNullable(true);
        props.add(ep);
        ep = EdmProperty.newBuilder("FixedLength").setType(EdmSimpleType.BOOLEAN).setNullable(true);
        props.add(ep);
        ep = EdmProperty.newBuilder("Precision").setType(EdmSimpleType.INT16).setNullable(true);
        props.add(ep);
        ep = EdmProperty.newBuilder("Scale").setType(EdmSimpleType.INT16).setNullable(true);
        props.add(ep);
        ep = EdmProperty.newBuilder("Unicode").setType(EdmSimpleType.BOOLEAN).setNullable(true);
        props.add(ep);
        ep = EdmProperty.newBuilder("Collation").setType(EdmSimpleType.STRING).setNullable(true);
        props.add(ep);
        ep = EdmProperty.newBuilder("ConcurrencyMode").setType(EdmSimpleType.STRING).setNullable(true);
        props.add(ep);
        keys = new ArrayList();
        keys.add("Namespace");
        keys.add("EntityTypeName");
        keys.add("Name");
        EdmEntityType.Builder propertyType = ((EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setNamespace("com.microsoft.schemas.ado._2008._09.edm")).setName(Edm.Property.name())).addKeys(keys).addProperties(props)).addNavigationProperties(navprops);
        if (this.decorator != null) {
            propertyType.setDocumentation(this.decorator.getDocumentationForEntityType("com.microsoft.schemas.ado._2008._09.edm", Edm.Property.name()));
            propertyType.setAnnotations((List)this.decorator.getAnnotationsForEntityType("com.microsoft.schemas.ado._2008._09.edm", Edm.Property.name()));
        }
        this.etypes.add(propertyType);
        EdmEntitySet.Builder propertySet = EdmEntitySet.newBuilder().setName("Properties").setEntityType(propertyType);
        this.esets.add(propertySet);
        EdmAssociation.Builder assoc = this.defineAssociation("EntityTypes", EdmMultiplicity.ONE, EdmMultiplicity.MANY, schemaType, schemaSet, structuralType, entitySet);
        EdmNavigationProperty.Builder navigationProperty = EdmNavigationProperty.newBuilder(assoc.getName()).setRelationship(assoc).setFromTo(assoc.getEnd1(), assoc.getEnd2());
        schemaType.addNavigationProperties(navigationProperty);
        assoc = this.defineAssociation("ComplexTypes", EdmMultiplicity.ONE, EdmMultiplicity.MANY, schemaType, schemaSet, complexType, complexSet);
        navigationProperty = EdmNavigationProperty.newBuilder(assoc.getName()).setRelationship(assoc).setFromTo(assoc.getEnd1(), assoc.getEnd2());
        schemaType.addNavigationProperties(navigationProperty);
        assoc = this.defineAssociation("Properties", EdmMultiplicity.ONE, EdmMultiplicity.MANY, structuralType, entitySet, propertyType, propertySet);
        navigationProperty = EdmNavigationProperty.newBuilder(assoc.getName()).setRelationship(assoc).setFromTo(assoc.getEnd1(), assoc.getEnd2());
        structuralType.addNavigationProperties(navigationProperty);
        assoc = this.defineAssociation("SubTypes", EdmMultiplicity.ONE, EdmMultiplicity.MANY, structuralType, entitySet, structuralType, entitySet);
        navigationProperty = EdmNavigationProperty.newBuilder(assoc.getName()).setRelationship(assoc).setFromTo(assoc.getEnd1(), assoc.getEnd2());
        structuralType.addNavigationProperties(navigationProperty);
        assoc = this.defineAssociation("SuperType", EdmMultiplicity.ONE, EdmMultiplicity.ZERO_TO_ONE, structuralType, entitySet, structuralType, entitySet);
        navigationProperty = EdmNavigationProperty.newBuilder(assoc.getName()).setRelationship(assoc).setFromTo(assoc.getEnd1(), assoc.getEnd2());
        structuralType.addNavigationProperties(navigationProperty);
    }

    private EdmAssociation.Builder defineAssociation(String assocName, EdmMultiplicity fromMult, EdmMultiplicity toMult, EdmEntityType.Builder fromEntityType, EdmEntitySet.Builder fromEntitySet, EdmEntityType.Builder toEntityType, EdmEntitySet.Builder toEntitySet) {
        EdmAssociationEnd.Builder fromAssociationEnd = EdmAssociationEnd.newBuilder().setRole(fromEntityType.getName()).setType(fromEntityType).setMultiplicity(fromMult);
        String toAssociationRole = toEntityType.getName();
        if (toAssociationRole.equals(fromEntityType.getName())) {
            toAssociationRole = toAssociationRole + "1";
        }
        EdmAssociationEnd.Builder toAssociationEnd = EdmAssociationEnd.newBuilder().setRole(toAssociationRole).setType(toEntityType).setMultiplicity(toMult);
        EdmAssociation.Builder association = EdmAssociation.newBuilder().setNamespace("com.microsoft.schemas.ado._2008._09.edm").setName(assocName).setEnds(fromAssociationEnd, toAssociationEnd);
        EdmAssociationSet.Builder associationSet = EdmAssociationSet.newBuilder().setName(assocName).setAssociation(association).setEnds(EdmAssociationSetEnd.newBuilder().setRole(fromAssociationEnd).setEntitySet(fromEntitySet), EdmAssociationSetEnd.newBuilder().setRole(toAssociationEnd).setEntitySet(toEntitySet));
        this.asets.add(associationSet);
        this.assocs.add(association);
        return association;
    }
}

