/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.edm;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.core4j.Enumerable;
import org.odata4j.core.NamespacedAnnotation;
import org.odata4j.core.OCollection;
import org.odata4j.core.OCollections;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.OComplexObjects;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityId;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OFunctionParameter;
import org.odata4j.core.OLink;
import org.odata4j.core.OLinks;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmAnnotationAttribute;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmDecorator;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmItem;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmStructuralType;
import org.odata4j.edm.EdmType;
import org.odata4j.format.xml.EdmxFormatWriter;
import org.odata4j.producer.BaseResponse;
import org.odata4j.producer.CountResponse;
import org.odata4j.producer.EntitiesResponse;
import org.odata4j.producer.EntityIdResponse;
import org.odata4j.producer.EntityQueryInfo;
import org.odata4j.producer.EntityResponse;
import org.odata4j.producer.ExpressionEvaluator;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.PropertyPath;
import org.odata4j.producer.PropertyPathHelper;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.Responses;
import org.odata4j.producer.edm.Edm;
import org.odata4j.producer.edm.MetadataEdmGenerator;
import org.odata4j.producer.exceptions.NotFoundException;
import org.odata4j.producer.exceptions.NotImplementedException;

public class MetadataProducer
implements ODataProducer {
    public static final Object REMOVE_ANNOTATION_OVERRIDE = new Object();
    private final ODataProducer dataProducer;
    private final EdmDataServices edm;
    private final EdmDecorator decorator;

    public MetadataProducer(ODataProducer dataProducer, EdmDecorator edmDecorator) {
        this.dataProducer = dataProducer;
        this.decorator = edmDecorator;
        this.edm = new MetadataEdmGenerator().generateEdm(edmDecorator).build();
    }

    public EdmDataServices getModel() {
        return this.dataProducer.getMetadata();
    }

    @Override
    public EdmDataServices getMetadata() {
        return this.edm;
    }

    @Override
    public EntitiesResponse getEntities(String entitySetName, QueryInfo queryInfo) {
        Context c = new Context(entitySetName, queryInfo);
        if (entitySetName.equals("Schemas")) {
            this.getSchemas(c);
        } else if (entitySetName.equals("EntityTypes")) {
            this.getEntityTypes(c, false);
        } else if (entitySetName.equals("RootEntityTypes")) {
            this.getEntityTypes(c, true);
        } else if (entitySetName.equals("ComplexTypes")) {
            this.getComplexTypes(c, false);
        } else if (entitySetName.equals("RootComplexTypes")) {
            this.getComplexTypes(c, true);
        } else if (entitySetName.equals("Properties")) {
            this.getProperties(c);
        } else {
            throw new NotFoundException("EntitySet " + entitySetName + " not found");
        }
        return Responses.entities(c.entities, c.entitySet, null, null);
    }

    protected void getSchemas(Context c) {
        EdmDataServices ds = this.dataProducer.getMetadata();
        ExpressionEvaluator f = null;
        if (null != c.queryInfo && null != c.queryInfo.filter) {
            f = new ExpressionEvaluator(c);
        }
        for (EdmSchema schema : ds.getSchemas()) {
            boolean add = true;
            if (null != f) {
                c.pushResolver(schema);
                add = f.evaluate(c.queryInfo.filter);
            }
            if (add) {
                c.addEntity(this.getSchema(c, schema));
            }
            if (null == f) continue;
            c.popResolver();
        }
    }

    protected OEntity getSchema(Context c, EdmSchema schema) {
        ArrayList props = new ArrayList();
        if (c.pathHelper.isSelected("Namespace")) {
            props.add(OProperties.string("Namespace", schema.getNamespace()));
        }
        if (null != schema.getAlias() && c.pathHelper.isSelected("Alias")) {
            props.add(OProperties.string("Alias", schema.getAlias()));
        }
        LinkedList<OLink> links = new LinkedList<OLink>();
        if (c.pathHelper.isSelected("ComplexTypes")) {
            if (c.pathHelper.isExpanded("ComplexTypes")) {
                c.pathHelper.navigate("ComplexTypes");
                ArrayList<OEntity> complexTypes = new ArrayList<OEntity>(schema.getComplexTypes().size());
                for (EdmComplexType ct : schema.getComplexTypes()) {
                    complexTypes.add(this.getStructuralType(c, ct));
                }
                c.pathHelper.popPath();
                links.add(OLinks.relatedEntitiesInline(null, "ComplexTypes", null, complexTypes));
            } else {
                links.add(OLinks.relatedEntities(null, "ComplexTypes", null));
            }
        }
        if (c.pathHelper.isSelected("EntityTypes")) {
            if (c.pathHelper.isExpanded("EntityTypes")) {
                c.pathHelper.navigate("EntityTypes");
                ArrayList<OEntity> etypes = new ArrayList<OEntity>(schema.getEntityTypes().size());
                for (EdmEntityType et : schema.getEntityTypes()) {
                    etypes.add(this.getStructuralType(c, et));
                }
                c.pathHelper.popPath();
                links.add(OLinks.relatedEntitiesInline(null, "EntityTypes", null, etypes));
            } else {
                links.add(OLinks.relatedEntities(null, "EntityTypes", null));
            }
        }
        this.addAnnotationProperties(c, schema, props);
        return OEntities.create(c.entitySet, OEntityKey.create("Namespace", schema.getNamespace()), props, links);
    }

    protected void getEntityTypes(Context c, boolean isRoot) {
        EdmDataServices ds = this.dataProducer.getMetadata();
        ExpressionEvaluator f = null;
        if (null != c.queryInfo && null != c.queryInfo.filter) {
            f = new ExpressionEvaluator(c);
        }
        for (EdmEntityType et : ds.getEntityTypes()) {
            if ((!isRoot || !et.isRootType()) && isRoot) continue;
            boolean add = true;
            if (null != f) {
                c.pushResolver(et);
                add = f.evaluate(c.queryInfo.filter);
            }
            if (add) {
                c.addEntity(this.getStructuralType(c, et));
            }
            if (null == f) continue;
            c.popResolver();
        }
    }

    private OEntity getStructuralType(Context c, EdmStructuralType st) {
        ArrayList props = new ArrayList();
        if (c.pathHelper.isSelected("Name")) {
            props.add(OProperties.string("Name", st.getName()));
        }
        if (c.pathHelper.isSelected("Namespace")) {
            props.add(OProperties.string("Namespace", st.getNamespace()));
        }
        if (null != st.getIsAbstract() && c.pathHelper.isSelected("Abstract")) {
            props.add(OProperties.boolean_("Abstract", st.getIsAbstract()));
        }
        if (null != st.getBaseType()) {
            if (c.pathHelper.isSelected("BaseType")) {
                props.add(OProperties.string("BaseType", st.getBaseType().getFullyQualifiedTypeName()));
            }
        } else if (st instanceof EdmEntityType && c.pathHelper.isSelected("Key")) {
            EdmComplexType propRefType = this.edm.findEdmComplexType(Edm.PropertyRef.fqName());
            EdmComplexType entityKeyType = this.edm.findEdmComplexType(Edm.EntityKey.fqName());
            OCollection.Builder<OComplexObject> builder = OCollections.newBuilder(propRefType);
            for (String key : ((EdmEntityType)st).getKeys()) {
                ArrayList refProps = new ArrayList();
                refProps.add(OProperties.string("Name", key));
                builder.add(OComplexObjects.create(propRefType, refProps));
            }
            ArrayList keyProps = new ArrayList();
            EdmProperty keysProp = entityKeyType.findProperty("Keys");
            EdmType collectionItemType = entityKeyType.findProperty("Keys").getType();
            keyProps.add(OProperties.collection("Keys", new EdmCollectionType(keysProp.getCollectionKind(), collectionItemType), builder.build()));
            OComplexObject key = OComplexObjects.create(entityKeyType, keyProps);
            props.add(OProperties.complex("Key", entityKeyType, key.getProperties()));
        }
        LinkedList<OLink> links = new LinkedList<OLink>();
        if (c.pathHelper.isSelected("Properties")) {
            if (c.pathHelper.isExpanded("Properties")) {
                c.pathHelper.navigate("Properties");
                ArrayList<OEntity> properties = new ArrayList<OEntity>(st.getDeclaredProperties().count());
                this.addProperties(st, st, properties, c);
                c.pathHelper.popPath();
                links.add(OLinks.relatedEntitiesInline(null, "Properties", null, properties));
            } else {
                links.add(OLinks.relatedEntities(null, "Properties", null));
            }
        }
        if (c.pathHelper.isSelected("SuperType")) {
            if (c.pathHelper.isExpanded("SuperType")) {
                OEntity superType = null;
                if (null != st.getBaseType()) {
                    c.pathHelper.navigate("SuperType");
                    superType = this.getStructuralType(c, st.getBaseType());
                    c.pathHelper.popPath();
                }
                links.add(OLinks.relatedEntityInline(null, "SuperType", null, superType));
            } else {
                links.add(OLinks.relatedEntities(null, "SuperType", null));
            }
        }
        if (c.pathHelper.isSelected("SubTypes")) {
            if (c.pathHelper.isExpanded("SubTypes")) {
                List<EdmStructuralType> stypes = Enumerable.create(this.dataProducer.getMetadata().getSubTypes(st)).toList();
                ArrayList<OEntity> subtypes = new ArrayList<OEntity>(stypes.size());
                EdmEntitySet baseSet = c.entitySet;
                if (baseSet.getName().equals("RootEntityTypes")) {
                    c.entitySet = this.edm.findEdmEntitySet("EntityTypes");
                } else if (baseSet.getName().equals("RootComplexTypes")) {
                    c.entitySet = this.edm.findEdmEntitySet("ComplexTypes");
                }
                c.pathHelper.navigate("SubTypes");
                for (EdmStructuralType subtype : stypes) {
                    subtypes.add(this.getStructuralType(c, subtype));
                }
                c.pathHelper.popPath();
                links.add(OLinks.relatedEntitiesInline(null, "SubTypes", null, subtypes));
                c.entitySet = baseSet;
            } else {
                links.add(OLinks.relatedEntities(null, "SubTypes", null));
            }
        }
        this.addDocumenation(c, st, props);
        this.addAnnotationProperties(c, st, props);
        return OEntities.create(c.entitySet, OEntityKey.create("Namespace", st.getNamespace(), "Name", st.getName()), props, links);
    }

    private void addProperties(EdmStructuralType queryType, EdmStructuralType st, List<OEntity> props, Context c) {
        for (EdmProperty p : st.getDeclaredProperties()) {
            props.add(this.getProperty(queryType, st, p, c));
        }
        if (c.flatten && st.getBaseType() != null) {
            this.addProperties(queryType, st.getBaseType(), props, c);
        }
    }

    private void addDocumenation(Context c, EdmItem item, List<OProperty<?>> props) {
        if (null != item.getDocumentation() && (null != item.getDocumentation().getSummary() || null != item.getDocumentation().getLongDescription()) && c.pathHelper.isSelected(Edm.Documentation.name())) {
            ArrayList docProps = new ArrayList();
            EdmComplexType docType = this.edm.findEdmComplexType(Edm.Documentation.fqName());
            if (null != item.getDocumentation().getSummary()) {
                docProps.add(OProperties.string("Summary", item.getDocumentation().getSummary()));
            }
            if (null != item.getDocumentation().getLongDescription()) {
                docProps.add(OProperties.string("LongDescription", item.getDocumentation().getLongDescription()));
            }
            props.add(OProperties.complex(Edm.Documentation.class.getSimpleName(), docType, docProps));
        }
    }

    private void addAnnotationProperties(Context c, EdmItem item, List<OProperty<?>> props) {
        if (null != item.getAnnotations()) {
            for (NamespacedAnnotation<?> a : item.getAnnotations()) {
                OObject co;
                Object ov;
                Object override;
                String propName;
                if (a.getValue() == null || !c.pathHelper.isSelected(propName = a.getNamespace().getPrefix() + "_" + a.getName()) || (override = null != this.decorator ? this.decorator.getAnnotationValueOverride(item, a, c.flatten, c.locale, c.queryInfo == null ? null : c.queryInfo.customOptions) : null) == REMOVE_ANNOTATION_OVERRIDE) continue;
                Object object = ov = override == null ? (Object)a.getValue() : override;
                if (a instanceof EdmAnnotationAttribute) {
                    props.add(OProperties.string(propName, ov.toString()));
                    continue;
                }
                if (ov instanceof OComplexObject) {
                    co = (OComplexObject)ov;
                    props.add(OProperties.complex(propName, (EdmComplexType)co.getType(), co.getProperties()));
                    continue;
                }
                if (!(ov instanceof OCollection)) continue;
                co = (OCollection)ov;
                props.add(OProperties.collection(propName, new EdmCollectionType(EdmProperty.CollectionKind.Bag, co.getType()), (OCollection<? extends OObject>)co));
            }
        }
    }

    private OEntity getProperty(EdmStructuralType queryType, EdmStructuralType et, EdmProperty p, Context c) {
        ArrayList props = new ArrayList();
        if (c.pathHelper.isSelected("Namespace")) {
            props.add(OProperties.string("Namespace", et.getNamespace()));
        }
        if (c.pathHelper.isSelected("EntityTypeName")) {
            props.add(OProperties.string("EntityTypeName", et.getName()));
        }
        if (c.pathHelper.isSelected("Name")) {
            props.add(OProperties.string("Name", p.getName()));
        }
        if (c.pathHelper.isSelected("Type")) {
            props.add(OProperties.string("Type", p.getType().getFullyQualifiedTypeName()));
        }
        if (c.pathHelper.isSelected("Nullable")) {
            props.add(OProperties.boolean_("Nullable", p.isNullable()));
        }
        if (null != p.getDefaultValue() && c.pathHelper.isSelected("DefaultValue")) {
            props.add(OProperties.string("DefaultValue", p.getDefaultValue()));
        }
        if (null != p.getMaxLength() && c.pathHelper.isSelected("MaxLength")) {
            props.add(OProperties.int32("MaxLength", p.getMaxLength()));
        }
        if (null != p.getFixedLength() && c.pathHelper.isSelected("FixedLength")) {
            props.add(OProperties.boolean_("FixedLength", p.getFixedLength()));
        }
        if (null != p.getPrecision() && c.pathHelper.isSelected("Precision")) {
            props.add(OProperties.int32("Precision", p.getPrecision()));
        }
        if (null != p.getScale() && c.pathHelper.isSelected("Scale")) {
            props.add(OProperties.int32("Scale", p.getScale()));
        }
        if (null != p.getUnicode() && c.pathHelper.isSelected("Unicode")) {
            props.add(OProperties.boolean_("Unicode", p.getUnicode()));
        }
        if (p.getCollectionKind() != EdmProperty.CollectionKind.NONE) {
            props.add(OProperties.string("CollectionKind", p.getCollectionKind().toString()));
        }
        this.addDocumenation(c, p, props);
        this.addAnnotationProperties(c, p, props);
        EdmEntitySet entitySet = this.edm.findEdmEntitySet("Properties");
        if (null != this.decorator) {
            this.decorator.decorateEntity(entitySet, p, queryType, props, c.flatten, c.locale, null != c.queryInfo ? c.queryInfo.customOptions : null);
        }
        return OEntities.create(entitySet, OEntityKey.create("Namespace", et.getNamespace(), "EntityTypeName", et.getName(), "Name", p.getName()), props, Collections.<OLink>emptyList());
    }

    protected void getComplexTypes(Context c, boolean isRoot) {
        EdmDataServices ds = this.dataProducer.getMetadata();
        ExpressionEvaluator f = null;
        if (null != c.queryInfo && null != c.queryInfo.filter) {
            f = new ExpressionEvaluator(c);
        }
        for (EdmComplexType ct : ds.getComplexTypes()) {
            if ((!isRoot || !ct.isRootType()) && isRoot) continue;
            boolean add = true;
            if (null != f) {
                c.pushResolver(ct);
                add = f.evaluate(c.queryInfo.filter);
            }
            if (add) {
                c.addEntity(this.getStructuralType(c, ct));
            }
            if (null == f) continue;
            c.popResolver();
        }
    }

    protected void getProperties(Context c) {
        EdmDataServices ds = this.dataProducer.getMetadata();
        ExpressionEvaluator f = null;
        if (null != c.queryInfo && null != c.queryInfo.filter) {
            f = new ExpressionEvaluator(c);
        }
        for (EdmComplexType edmComplexType : ds.getComplexTypes()) {
            if (!edmComplexType.isRootType()) continue;
            this.addStructuralTypeProperties(c, edmComplexType, f);
        }
        for (EdmEntityType edmEntityType : ds.getEntityTypes()) {
            if (!edmEntityType.isRootType()) continue;
            this.addStructuralTypeProperties(c, edmEntityType, f);
        }
    }

    protected void addStructuralTypeProperties(Context c, EdmStructuralType st, ExpressionEvaluator ev) {
        Iterator<EdmStructuralType> candidates;
        for (EdmProperty prop : st.getProperties()) {
            boolean add = true;
            if (null != ev) {
                c.pushResolver(prop);
                add = ev.evaluate(c.queryInfo.filter);
            }
            if (add) {
                c.addEntity(this.getProperty(st, st, prop, c));
            }
            if (null == ev) continue;
            c.popResolver();
        }
        EdmDataServices ds = this.dataProducer.getMetadata();
        Iterator<EdmStructuralType> iterator = candidates = st instanceof EdmComplexType ? ds.getComplexTypes().iterator() : ds.getEntityTypes().iterator();
        while (candidates.hasNext()) {
            EdmStructuralType item = candidates.next();
            if (null == item.getBaseType() || !item.getBaseType().equals(st)) continue;
            this.addStructuralTypeProperties(c, item, ev);
        }
    }

    @Override
    public EntityResponse getEntity(String entitySetName, OEntityKey entityKey, EntityQueryInfo queryInfo) {
        Context c = new Context(entitySetName, queryInfo, entityKey);
        if (entitySetName.equals("Schemas")) {
            this.findSchema(c);
        } else if (entitySetName.equals("EntityTypes") || entitySetName.equals("RootEntityTypes")) {
            this.findStructuralType(c, true, entitySetName.equals("RootEntityTypes"));
        } else if (entitySetName.equals("ComplexTypes") || entitySetName.equals("RootComplexTypes")) {
            this.findStructuralType(c, false, entitySetName.equals("RootComplexTypes"));
        } else {
            throw new NotFoundException("EntitySet " + entitySetName + " not found");
        }
        if (c.entities.isEmpty()) {
            throw new NotFoundException(entitySetName + entityKey.toKeyString() + " not found");
        }
        return Responses.entity(c.entities.get(0));
    }

    protected void findSchema(Context c) {
        EdmDataServices ds = this.dataProducer.getMetadata();
        String nm = (String)c.entityKey.asSingleValue();
        for (EdmSchema s : ds.getSchemas()) {
            if (!nm.equals(s.getNamespace())) continue;
            c.entities.add(this.getSchema(c, s));
        }
    }

    protected void findStructuralType(Context c, boolean isEntity, boolean root) {
        EdmDataServices ds = this.dataProducer.getMetadata();
        Iterable<EdmStructuralType> candidates = isEntity ? ds.getEntityTypes() : ds.getComplexTypes();
        Iterator<EdmStructuralType> i$ = candidates.iterator();
        while (i$.hasNext()) {
            EdmStructuralType eto;
            EdmStructuralType st = eto = i$.next();
            if (root && st.getBaseType() != null) continue;
            boolean matchedAll = true;
            for (OProperty<?> keyprop : c.entityKey.asComplexProperties()) {
                String val = null;
                if (keyprop.getName().equals("Namespace")) {
                    val = st.getNamespace();
                } else if (keyprop.getName().equals("Name")) {
                    val = st.getName();
                } else {
                    throw new RuntimeException(keyprop.getName() + " is not a key property of " + c.entitySet.getName());
                }
                if (keyprop.getValue().toString().equals(val)) continue;
                matchedAll = false;
                break;
            }
            if (!matchedAll) continue;
            c.entities.add(this.getStructuralType(c, st));
        }
    }

    public void log() {
        StringWriter sw = new StringWriter();
        EdmxFormatWriter.write(this.edm, sw);
        System.out.println(sw.toString());
    }

    @Override
    public BaseResponse getNavProperty(String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CountResponse getEntitiesCount(String entitySetName, QueryInfo queryInfo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CountResponse getNavPropertyCount(String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EntityResponse createEntity(String entitySetName, OEntity entity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EntityResponse createEntity(String entitySetName, OEntityKey entityKey, String navProp, OEntity entity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void deleteEntity(String entitySetName, OEntityKey entityKey) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void mergeEntity(String entitySetName, OEntity entity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateEntity(String entitySetName, OEntity entity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EntityIdResponse getLinks(OEntityId sourceEntity, String targetNavProp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void createLink(OEntityId sourceEntity, String targetNavProp, OEntityId targetEntity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateLink(OEntityId sourceEntity, String targetNavProp, OEntityKey oldTargetEntityKey, OEntityId newTargetEntity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void deleteLink(OEntityId sourceEntity, String targetNavProp, OEntityKey targetEntityKey) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BaseResponse callFunction(EdmFunctionImport name, Map<String, OFunctionParameter> params, QueryInfo queryInfo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MetadataProducer getMetadataProducer() {
        return null;
    }

    protected class Context
    implements ExpressionEvaluator.VariableResolver {
        EdmEntitySet entitySet;
        QueryInfo queryInfo;
        OEntityKey entityKey;
        Locale locale = Locale.ENGLISH;
        PropertyPathHelper pathHelper;
        List<OEntity> entities = new LinkedList<OEntity>();
        boolean flatten = false;
        private Stack<EdmItem> resolverContext = new Stack();

        public Context(String entitySetName, QueryInfo queryInfo) {
            this(entitySetName, queryInfo, null);
        }

        public Context(String entitySetName, QueryInfo queryInfo, OEntityKey key) {
            this.entitySet = MetadataProducer.this.edm.findEdmEntitySet(entitySetName);
            this.queryInfo = queryInfo;
            this.entityKey = key;
            this.setLocale();
            this.pathHelper = new PropertyPathHelper(queryInfo.select, queryInfo.expand, this.getCustomOption("selectR"), this.getCustomOption("expandR"));
            this.flatten = this.getCustomBoolean("flatten", false);
        }

        protected final String getCustomOption(String key) {
            if (null != this.queryInfo && null != this.queryInfo.customOptions) {
                return this.queryInfo.customOptions.get(key);
            }
            return null;
        }

        protected final boolean getCustomBoolean(String key, boolean fallback) {
            String s = this.getCustomOption(key);
            return s == null ? fallback : Boolean.parseBoolean(s);
        }

        protected final void setLocale() {
            Locale l;
            String lc = this.getCustomOption("locale");
            if (null != lc && null != (l = this.parseLocale(lc))) {
                this.locale = l;
            }
        }

        public Locale parseLocale(String lstring) {
            String[] s = lstring.split("_", 3);
            if (1 == s.length) {
                return new Locale(s[0]);
            }
            if (2 == s.length) {
                return new Locale(s[0], s[1]);
            }
            if (3 == s.length) {
                return new Locale(s[0], s[1], s[2]);
            }
            return null;
        }

        public void addEntity(OEntity e) {
            this.entities.add(e);
        }

        @Override
        public Object resolveVariable(String path) {
            EdmItem i;
            PropertyPath p = new PropertyPath(path);
            EdmItem edmItem = i = this.resolverContext.isEmpty() ? null : this.peekResolver();
            if (null != i) {
                if (i instanceof EdmStructuralType) {
                    return this.resolveStructuralTypeVariable((EdmStructuralType)i, p);
                }
                if (i instanceof EdmProperty) {
                    return this.resolvePropertyVariable((EdmProperty)i, p);
                }
            }
            throw new NotImplementedException("unhandled EdmItem type in resolveVariable: " + (i == null ? "null" : i.getClass().getName()));
        }

        private Object resolveStructuralTypeVariable(EdmStructuralType et, PropertyPath path) {
            if (path.getNComponents() == 1) {
                String name = path.getLastComponent();
                if ("Abstract".equals(name)) {
                    return et.getIsAbstract() == null ? false : et.getIsAbstract();
                }
                if ("BaseType".equals(name)) {
                    return et.getBaseType() == null ? null : et.getBaseType().getFullyQualifiedTypeName();
                }
                if ("Name".equals(name)) {
                    return et.getName();
                }
                if ("Namespace".equals(name)) {
                    return et.getNamespace();
                }
                try {
                    return MetadataProducer.this.decorator.resolveStructuralTypeProperty(et, path);
                }
                catch (Exception ex) {
                    throw new RuntimeException("EdmEntityType property " + name + " not found");
                }
            }
            String navProp = path.getFirstComponent();
            throw new RuntimeException("EdmEntityType navigation property " + navProp + " not found or not supported");
        }

        private Object resolvePropertyVariable(EdmProperty prop, PropertyPath path) {
            if (path.getNComponents() == 1) {
                String name = path.getLastComponent();
                if ("DefaultValue".equals(name)) {
                    return prop.getDefaultValue();
                }
                if ("CollectionKind".equals(name)) {
                    return prop.getCollectionKind().toString();
                }
                if ("EntityTypeName".equals(name)) {
                    return prop.getDeclaringType().getName();
                }
                if ("FixedLength".equals(name)) {
                    return null != prop.getFixedLength() ? prop.getFixedLength().toString() : null;
                }
                if ("MaxLength".equals(name)) {
                    return null != prop.getMaxLength() ? prop.getMaxLength().toString() : null;
                }
                if ("Name".equals(name)) {
                    return prop.getName();
                }
                if ("Namespace".equals(name)) {
                    return prop.getDeclaringType().getNamespace();
                }
                if ("Nullable".equals(name)) {
                    return prop.isNullable() ? "true" : "false";
                }
                if ("Type".equals(name)) {
                    return prop.getType().getFullyQualifiedTypeName();
                }
                if ("Precision".equals(name)) {
                    return prop.getPrecision() == null ? null : prop.getPrecision().toString();
                }
                if ("Scale".equals(name)) {
                    return prop.getScale() == null ? null : prop.getScale().toString();
                }
                if (null != MetadataProducer.this.decorator) {
                    try {
                        return MetadataProducer.this.decorator.resolvePropertyProperty(prop, path);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("EdmProperty property path " + path + " not found");
                    }
                }
                throw new RuntimeException("EdmProperty property " + name + " not found");
            }
            String navProp = path.getFirstComponent();
            throw new RuntimeException("EdmProperty navigation property " + navProp + " not found or not supported");
        }

        private void pushResolver(EdmItem item) {
            this.resolverContext.push(item);
        }

        private EdmItem peekResolver() {
            return this.resolverContext.peek();
        }

        private void popResolver() {
            this.resolverContext.pop();
        }
    }

    public static class CustomOptions {
        public static final String Locale = "locale";
        public static final String Flatten = "flatten";
    }
}

