/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.inmemory;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.core4j.Enumerable;
import org.odata4j.core.Throwables;

public class BeanModel {
    private final Class<?> beanClass;
    private final Map<String, Method> getters;
    private final Map<String, Method> setters;
    private final Map<String, Class<?>> types;
    private final Map<String, Class<?>> collections;

    public BeanModel(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.getters = BeanModel.getBeanGetters(beanClass);
        this.setters = BeanModel.getBeanSetters(beanClass);
        this.types = BeanModel.computeTypes(this.getters, this.setters);
        this.collections = this.computeCollections(this.getters, this.setters);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Iterable<String> getPropertyNames() {
        return this.types.keySet();
    }

    public Class<?> getPropertyType(String propertyName) {
        return this.types.get(propertyName);
    }

    public Iterable<String> getCollectionNames() {
        return this.collections.keySet();
    }

    public Class<?> getCollectionElementType(String collectionName) {
        return this.collections.get(collectionName);
    }

    public boolean canRead(String propertyName) {
        return this.getters.containsKey(propertyName);
    }

    public boolean canWrite(String propertyName) {
        return this.setters.containsKey(propertyName);
    }

    public Object getPropertyValue(Object target, String propertyName) {
        Method method = this.getGetter(propertyName);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return method.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public void setPropertyValue(Object target, String propertyName, Object propertyValue) {
        Method method = this.getSetter(propertyName);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            method.invoke(target, propertyValue);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public Iterable<?> getCollectionValue(Object target, String collectionName) {
        Method method = this.getGetter(collectionName);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            Object obj = method.invoke(target, new Object[0]);
            if (obj == null) {
                return null;
            }
            return obj.getClass().isArray() ? Enumerable.create((Object[])obj) : (Enumerable<Object>)obj;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public <T> void setCollectionValue(Object target, String collectionName, Collection<T> collectionValue) {
        Method method = this.getSetter(collectionName);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            Collection<Object> value = null;
            if (collectionValue != null) {
                Class<?> clazz = method.getParameterTypes()[0];
                if (List.class.isAssignableFrom(clazz)) {
                    value = collectionValue instanceof List ? (List<Object>)collectionValue : new ArrayList<T>(collectionValue);
                } else if (Set.class.isAssignableFrom(clazz)) {
                    value = collectionValue instanceof Set ? (Set<Object>)collectionValue : new HashSet<T>(collectionValue);
                } else {
                    throw new RuntimeException("Unsupported collection type " + collectionValue.getClass());
                }
            }
            method.invoke(target, value);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    private Method getGetter(String propertyName) {
        Method method = this.getters.get(propertyName);
        if (method == null) {
            throw new IllegalArgumentException("No getter found for propertyName " + propertyName);
        }
        return method;
    }

    private Method getSetter(String propertyName) {
        Method method = this.setters.get(propertyName);
        if (method == null) {
            throw new IllegalArgumentException("No setter found for propertyName " + propertyName);
        }
        return method;
    }

    private static Map<String, Class<?>> computeTypes(Map<String, Method> getters, Map<String, Method> setters) {
        HashMap rt = new HashMap();
        for (Map.Entry<String, Method> getter : getters.entrySet()) {
            Class<?> getterType = getter.getValue().getReturnType();
            if (BeanModel.isIterable(getterType)) continue;
            rt.put(getter.getKey(), getterType);
        }
        for (Map.Entry<String, Method> setter : setters.entrySet()) {
            String propertyName = setter.getKey();
            Class getterType = (Class)rt.get(propertyName);
            if (getterType == null) continue;
            Class<?> setterType = setter.getValue().getParameterTypes()[0];
            if (getterType != null && !getterType.equals(setterType)) {
                throw new RuntimeException(String.format("Inconsistent types for property %s.%s: getter type %s, setter type %s", setters.get(propertyName).getDeclaringClass().getName(), propertyName, getterType.getName(), setterType.getName()));
            }
            rt.put(propertyName, setterType);
        }
        return rt;
    }

    private Map<String, Class<?>> computeCollections(Map<String, Method> getters2, Map<String, Method> setters2) {
        HashMap rt = new HashMap();
        for (Map.Entry<String, Method> getter : this.getters.entrySet()) {
            Type[] actualTypes;
            Class<?> setterType;
            String propertyName = getter.getKey();
            Method method = getter.getValue();
            Class<?> getterType = method.getReturnType();
            if (!BeanModel.isIterable(getterType) || (setterType = this.setters.containsKey(propertyName) ? this.setters.get(propertyName).getParameterTypes()[0] : null) == null) continue;
            if (!getterType.equals(setterType)) {
                throw new RuntimeException(String.format("Inconsistent types for association %s.%s: getter type %s, setter type %s", this.setters.get(propertyName).getDeclaringClass().getName(), propertyName, getterType.getName(), setterType.getName()));
            }
            Type type = method.getGenericReturnType();
            Class<Object> elementClass = type instanceof ParameterizedType ? ((actualTypes = ((ParameterizedType)type).getActualTypeArguments()).length > 0 ? (Class)actualTypes[0] : Object.class) : Object.class;
            rt.put(propertyName, elementClass);
        }
        return rt;
    }

    private static boolean isIterable(Class<?> clazz) {
        return clazz.isArray() || Iterable.class.isAssignableFrom(clazz);
    }

    private static Map<String, Method> getBeanGetters(Class<?> clazz) {
        HashMap<String, Method> rt = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            String name;
            String methodName = method.getName();
            if (methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE) && !Modifier.isStatic(method.getModifiers())) {
                name = methodName.substring(3);
                rt.put(name, method);
            }
            if (!methodName.startsWith("is") || methodName.length() <= 2 || !Character.isUpperCase(methodName.charAt(2)) || method.getParameterTypes().length != 0 || !method.getReturnType().equals(Boolean.class) && !method.getReturnType().equals(Boolean.TYPE) || Modifier.isStatic(method.getModifiers())) continue;
            name = methodName.substring(2);
            rt.put(name, method);
        }
        return rt;
    }

    private static Map<String, Method> getBeanSetters(Class<?> clazz) {
        HashMap<String, Method> rt = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("set") || methodName.length() <= 3 || !Character.isUpperCase(methodName.charAt(3)) || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.TYPE) || Modifier.isStatic(method.getModifiers())) continue;
            String name = methodName.substring(3);
            rt.put(name, method);
        }
        return rt;
    }
}

