/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.inmemory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.core4j.Enumerable;
import org.core4j.Func1;
import org.core4j.Predicate1;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmAssociationSet;
import org.odata4j.edm.EdmAssociationSetEnd;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmDecorator;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmGenerator;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.producer.inmemory.InMemoryEntityInfo;
import org.odata4j.producer.inmemory.InMemoryTypeMapping;
import org.odata4j.producer.inmemory.PropertyModel;

public class InMemoryEdmGenerator
implements EdmGenerator {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final String namespace;
    private final String containerName;
    private final InMemoryTypeMapping typeMapping;
    private final Map<String, InMemoryEntityInfo<?>> eis;

    public InMemoryEdmGenerator(String namespace, String containerName, InMemoryTypeMapping typeMapping, String idPropertyName, Map<String, InMemoryEntityInfo<?>> eis) {
        this.namespace = namespace;
        this.containerName = containerName;
        this.typeMapping = typeMapping;
        this.eis = eis;
    }

    @Override
    public EdmDataServices.Builder generateEdm(EdmDecorator decorator) {
        ArrayList<EdmSchema.Builder> schemas = new ArrayList<EdmSchema.Builder>();
        ArrayList<EdmEntityContainer.Builder> containers = new ArrayList<EdmEntityContainer.Builder>();
        ArrayList<EdmEntitySet.Builder> entitySets = new ArrayList<EdmEntitySet.Builder>();
        ArrayList<EdmEntityType.Builder> entityTypes = new ArrayList<EdmEntityType.Builder>();
        ArrayList<EdmAssociation.Builder> associations = new ArrayList<EdmAssociation.Builder>();
        ArrayList<EdmAssociationSet.Builder> associationSets = new ArrayList<EdmAssociationSet.Builder>();
        this.createStructuralEntities(decorator, entitySets, entityTypes);
        Map<String, EdmEntityType.Builder> entityTypesByName = Enumerable.create(entityTypes).toMap(new Func1<EdmEntityType.Builder, String>(){

            @Override
            public String apply(EdmEntityType.Builder input) {
                return input.getName();
            }
        });
        Map<String, EdmEntitySet.Builder> entitySetByName = Enumerable.create(entitySets).toMap(new Func1<EdmEntitySet.Builder, String>(){

            @Override
            public String apply(EdmEntitySet.Builder input) {
                return input.getName();
            }
        });
        HashMap entityNameByClass = new HashMap();
        for (Map.Entry<String, InMemoryEntityInfo<?>> e : this.eis.entrySet()) {
            entityNameByClass.put(e.getValue().entityClass, e.getKey());
        }
        this.createNavigationProperties(associations, associationSets, entityTypesByName, entitySetByName, entityNameByClass);
        EdmEntityContainer.Builder container = EdmEntityContainer.newBuilder().setName(this.containerName).setIsDefault(true).addEntitySets(entitySets).addAssociationSets(associationSets);
        containers.add(container);
        EdmSchema.Builder schema = EdmSchema.newBuilder().setNamespace(this.namespace).addEntityTypes(entityTypes).addAssociations(associations).addEntityContainers(containers);
        if (decorator != null) {
            schema.setDocumentation(decorator.getDocumentationForSchema(this.namespace));
            schema.setAnnotations(decorator.getAnnotationsForSchema(this.namespace));
        }
        schemas.add(schema);
        EdmDataServices.Builder rt = EdmDataServices.newBuilder().addSchemas(schemas);
        if (decorator != null) {
            rt.addNamespaces(decorator.getNamespaces());
        }
        return rt;
    }

    private void createStructuralEntities(EdmDecorator decorator, List<EdmEntitySet.Builder> entitySets, List<EdmEntityType.Builder> entityTypes) {
        for (String entitySetName : this.eis.keySet()) {
            InMemoryEntityInfo<?> entityInfo = this.eis.get(entitySetName);
            ArrayList<EdmProperty.Builder> properties = new ArrayList<EdmProperty.Builder>();
            properties.addAll(this.toEdmProperties(decorator, entityInfo.properties, entityInfo.keys, entitySetName));
            EdmEntityType.Builder eet = (EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setNamespace(this.namespace)).setName(entityInfo.entityTypeName)).addKeys(entityInfo.keys).setHasStream(entityInfo.hasStream).addProperties(properties);
            if (decorator != null) {
                eet.setDocumentation(decorator.getDocumentationForEntityType(this.namespace, entitySetName));
                eet.setAnnotations((List)decorator.getAnnotationsForEntityType(this.namespace, entitySetName));
            }
            EdmEntitySet.Builder ees = EdmEntitySet.newBuilder().setName(entitySetName).setEntityType(eet);
            entitySets.add(ees);
            entityTypes.add(eet);
        }
    }

    private void createNavigationProperties(List<EdmAssociation.Builder> associations, List<EdmAssociationSet.Builder> associationSets, Map<String, EdmEntityType.Builder> entityTypesByName, Map<String, EdmEntitySet.Builder> entitySetByName, Map<Class<?>, String> entityNameByClass) {
        for (String entitySetName : this.eis.keySet()) {
            InMemoryEntityInfo<?> ei = this.eis.get(entitySetName);
            Class clazz1 = ei.entityClass;
            this.generateToOneNavProperties(associations, associationSets, entityTypesByName, entitySetByName, entityNameByClass, ei.entityTypeName, ei);
            this.generateToManyNavProperties(associations, associationSets, entityTypesByName, entitySetByName, entityNameByClass, ei.entityTypeName, ei, clazz1);
        }
    }

    private void generateToOneNavProperties(List<EdmAssociation.Builder> associations, List<EdmAssociationSet.Builder> associationSets, Map<String, EdmEntityType.Builder> entityTypesByName, Map<String, EdmEntitySet.Builder> entitySetByName, Map<Class<?>, String> entityNameByClass, String entityTypeName, InMemoryEntityInfo<?> ei) {
        for (String assocProp : ei.properties.getPropertyNames()) {
            EdmEntityType.Builder eet1 = entityTypesByName.get(entityTypeName);
            Class<?> clazz2 = ei.properties.getPropertyType(assocProp);
            String eetName2 = entityNameByClass.get(clazz2);
            if (eet1.findProperty(assocProp) != null || eetName2 == null) continue;
            EdmEntityType.Builder eet2 = entityTypesByName.get(eetName2);
            EdmMultiplicity m1 = EdmMultiplicity.MANY;
            EdmMultiplicity m2 = EdmMultiplicity.ONE;
            String assocName = String.format("FK_%s_%s", eet1.getName(), eet2.getName());
            EdmAssociationEnd.Builder assocEnd1 = EdmAssociationEnd.newBuilder().setRole(eet1.getName()).setType(eet1).setMultiplicity(m1);
            String assocEnd2Name = eet2.getName();
            if (assocEnd2Name.equals(eet1.getName())) {
                assocEnd2Name = assocEnd2Name + "1";
            }
            EdmAssociationEnd.Builder assocEnd2 = EdmAssociationEnd.newBuilder().setRole(assocEnd2Name).setType(eet2).setMultiplicity(m2);
            EdmAssociation.Builder assoc = EdmAssociation.newBuilder().setNamespace(this.namespace).setName(assocName).setEnds(assocEnd1, assocEnd2);
            associations.add(assoc);
            EdmEntitySet.Builder ees1 = entitySetByName.get(eet1.getName());
            EdmEntitySet.Builder ees2 = entitySetByName.get(eet2.getName());
            EdmAssociationSet.Builder eas = EdmAssociationSet.newBuilder().setName(assocName).setAssociation(assoc).setEnds(EdmAssociationSetEnd.newBuilder().setRole(assocEnd1).setEntitySet(ees1), EdmAssociationSetEnd.newBuilder().setRole(assocEnd2).setEntitySet(ees2));
            associationSets.add(eas);
            EdmNavigationProperty.Builder np = EdmNavigationProperty.newBuilder(assocProp).setRelationship(assoc).setFromTo(assoc.getEnd1(), assoc.getEnd2());
            eet1.addNavigationProperties(np);
        }
    }

    private void generateToManyNavProperties(List<EdmAssociation.Builder> associations, List<EdmAssociationSet.Builder> associationSets, Map<String, EdmEntityType.Builder> entityTypesByName, Map<String, EdmEntitySet.Builder> entitySetByName, Map<Class<?>, String> entityNameByClass, String entityTypeName, InMemoryEntityInfo<?> ei, Class<?> clazz1) {
        for (String assocProp : ei.properties.getCollectionNames()) {
            final EdmEntityType.Builder eet1 = entityTypesByName.get(entityTypeName);
            Class<?> clazz2 = ei.properties.getCollectionElementType(assocProp);
            String eetName2 = entityNameByClass.get(clazz2);
            if (eetName2 == null) continue;
            final EdmEntityType.Builder eet2 = entityTypesByName.get(eetName2);
            try {
                EdmAssociationEnd.Builder toRole;
                EdmAssociationEnd.Builder fromRole;
                EdmAssociation.Builder assoc = Enumerable.create(associations).firstOrNull(new Predicate1<EdmAssociation.Builder>(){

                    @Override
                    public boolean apply(EdmAssociation.Builder input) {
                        return input.getEnd1().getType().equals(eet2) && input.getEnd2().getType().equals(eet1);
                    }
                });
                if (assoc == null) {
                    EdmMultiplicity m1 = EdmMultiplicity.ZERO_TO_ONE;
                    EdmMultiplicity m2 = EdmMultiplicity.MANY;
                    InMemoryEntityInfo<?> class2eiInfo = this.eis.get(eetName2);
                    for (String tmp : class2eiInfo.properties.getCollectionNames()) {
                        if (clazz1 != class2eiInfo.properties.getCollectionElementType(tmp)) continue;
                        m1 = EdmMultiplicity.MANY;
                        m2 = EdmMultiplicity.MANY;
                        break;
                    }
                    String assocName = String.format("FK_%s_%s", eet1.getName(), eet2.getName());
                    EdmAssociationEnd.Builder assocEnd1 = EdmAssociationEnd.newBuilder().setRole(eet1.getName()).setType(eet1).setMultiplicity(m1);
                    String assocEnd2Name = eet2.getName();
                    if (assocEnd2Name.equals(eet1.getName())) {
                        assocEnd2Name = assocEnd2Name + "1";
                    }
                    EdmAssociationEnd.Builder assocEnd2 = EdmAssociationEnd.newBuilder().setRole(assocEnd2Name).setType(eet2).setMultiplicity(m2);
                    assoc = EdmAssociation.newBuilder().setNamespace(this.namespace).setName(assocName).setEnds(assocEnd1, assocEnd2);
                    associations.add(assoc);
                    EdmEntitySet.Builder ees1 = entitySetByName.get(eet1.getName());
                    EdmEntitySet.Builder ees2 = entitySetByName.get(eet2.getName());
                    EdmAssociationSet.Builder eas = EdmAssociationSet.newBuilder().setName(assocName).setAssociation(assoc).setEnds(EdmAssociationSetEnd.newBuilder().setRole(assocEnd1).setEntitySet(ees1), EdmAssociationSetEnd.newBuilder().setRole(assocEnd2).setEntitySet(ees2));
                    associationSets.add(eas);
                    fromRole = assoc.getEnd1();
                    toRole = assoc.getEnd2();
                } else {
                    fromRole = assoc.getEnd2();
                    toRole = assoc.getEnd1();
                }
                EdmNavigationProperty.Builder np = EdmNavigationProperty.newBuilder(assocProp).setRelationship(assoc).setFromTo(fromRole, toRole);
                eet1.addNavigationProperties(np);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Exception building Edm associations: " + e.getMessage(), e);
            }
        }
    }

    private Collection<EdmProperty.Builder> toEdmProperties(EdmDecorator decorator, PropertyModel model, String[] keys, String structuralTypename) {
        ArrayList<EdmProperty.Builder> rt = new ArrayList<EdmProperty.Builder>();
        Set<String> keySet = Enumerable.create(keys).toSet();
        for (String propName : model.getPropertyNames()) {
            Class<?> propType = model.getPropertyType(propName);
            EdmSimpleType<?> type = this.typeMapping.findEdmType(propType);
            if (type == null) continue;
            EdmProperty.Builder ep = EdmProperty.newBuilder(propName).setType(type).setNullable(!keySet.contains(propName));
            if (decorator != null) {
                ep.setDocumentation(decorator.getDocumentationForProperty(this.namespace, structuralTypename, propName));
                ep.setAnnotations((List)decorator.getAnnotationsForProperty(this.namespace, structuralTypename, propName));
            }
            rt.add(ep);
        }
        return rt;
    }
}

