/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.inmemory;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.core4j.Enumerable;
import org.core4j.Func;
import org.core4j.Func1;
import org.core4j.Predicate1;
import org.odata4j.core.OAtomStreamEntity;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityId;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OFunctionParameter;
import org.odata4j.core.OLink;
import org.odata4j.core.OLinks;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmDecorator;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.expression.BoolCommonExpression;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.Expression;
import org.odata4j.expression.OrderByExpression;
import org.odata4j.producer.BaseResponse;
import org.odata4j.producer.CountResponse;
import org.odata4j.producer.EntitiesResponse;
import org.odata4j.producer.EntityIdResponse;
import org.odata4j.producer.EntityQueryInfo;
import org.odata4j.producer.EntityResponse;
import org.odata4j.producer.InlineCount;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.Responses;
import org.odata4j.producer.edm.MetadataProducer;
import org.odata4j.producer.exceptions.NotFoundException;
import org.odata4j.producer.exceptions.NotImplementedException;
import org.odata4j.producer.inmemory.BeanBasedPropertyModel;
import org.odata4j.producer.inmemory.EntityIdFunctionPropertyModelDelegate;
import org.odata4j.producer.inmemory.EnumsAsStringsPropertyModelDelegate;
import org.odata4j.producer.inmemory.InMemoryEdmGenerator;
import org.odata4j.producer.inmemory.InMemoryEntityInfo;
import org.odata4j.producer.inmemory.InMemoryEvaluation;
import org.odata4j.producer.inmemory.InMemoryTypeMapping;
import org.odata4j.producer.inmemory.PropertyModel;

public class InMemoryProducer
implements ODataProducer {
    private static final String ID_PROPNAME = "EntityId";
    private final String namespace;
    private final String containerName;
    private final int maxResults;
    private final Map<String, InMemoryEntityInfo<?>> eis = new HashMap();
    private EdmDataServices metadata;
    private final EdmDecorator decorator;
    private final MetadataProducer metadataProducer;
    private final InMemoryTypeMapping typeMapping;
    private static final int DEFAULT_MAX_RESULTS = 100;

    public InMemoryProducer(String namespace) {
        this(namespace, 100);
    }

    public InMemoryProducer(String namespace, int maxResults) {
        this(namespace, null, maxResults, null, null);
    }

    public InMemoryProducer(String namespace, String containerName, int maxResults, EdmDecorator decorator, InMemoryTypeMapping typeMapping) {
        this.namespace = namespace;
        this.containerName = containerName != null && !containerName.isEmpty() ? containerName : "Container";
        this.maxResults = maxResults;
        this.decorator = decorator;
        this.metadataProducer = new MetadataProducer(this, decorator);
        this.typeMapping = typeMapping == null ? InMemoryTypeMapping.DEFAULT : typeMapping;
    }

    @Override
    public EdmDataServices getMetadata() {
        if (this.metadata == null) {
            this.metadata = this.newEdmGenerator(this.namespace, this.typeMapping, ID_PROPNAME, this.eis).generateEdm(this.decorator).build();
        }
        return this.metadata;
    }

    protected InMemoryEdmGenerator newEdmGenerator(String namespace, InMemoryTypeMapping typeMapping, String idPropName, Map<String, InMemoryEntityInfo<?>> eis) {
        return new InMemoryEdmGenerator(namespace, this.containerName, typeMapping, ID_PROPNAME, eis);
    }

    @Override
    public MetadataProducer getMetadataProducer() {
        return this.metadataProducer;
    }

    @Override
    public void close() {
    }

    public <TEntity> void register(Class<TEntity> entityClass, String entitySetName, Func<Iterable<TEntity>> get, String ... keys) {
        this.register(entityClass, entitySetName, entitySetName, get, keys);
    }

    public <TEntity> void register(Class<TEntity> entityClass, String entitySetName, String entityTypeName, Func<Iterable<TEntity>> get, String ... keys) {
        PropertyModel model = new BeanBasedPropertyModel(entityClass);
        model = new EnumsAsStringsPropertyModelDelegate(model);
        this.register(entityClass, model, entitySetName, entityTypeName, get, keys);
    }

    public <TEntity, TKey> void register(Class<TEntity> entityClass, Class<TKey> keyClass, String entitySetName, Func<Iterable<TEntity>> get, Func1<TEntity, TKey> id) {
        PropertyModel model = new BeanBasedPropertyModel(entityClass);
        model = new EnumsAsStringsPropertyModelDelegate(model);
        model = new EntityIdFunctionPropertyModelDelegate<TEntity, TKey>(model, ID_PROPNAME, keyClass, id);
        this.register(entityClass, model, entitySetName, get, ID_PROPNAME);
    }

    public <TEntity, TKey> void register(Class<TEntity> entityClass, PropertyModel propertyModel, String entitySetName, Func<Iterable<TEntity>> get, String ... keys) {
        this.register(entityClass, propertyModel, entitySetName, entitySetName, get, keys);
    }

    public <TEntity> void register(Class<TEntity> entityClass, PropertyModel propertyModel, final String entitySetName, String entityTypeName, Func<Iterable<TEntity>> get, final String ... keys) {
        InMemoryEntityInfo ei = new InMemoryEntityInfo();
        ei.entitySetName = entitySetName;
        ei.entityTypeName = entityTypeName;
        ei.properties = propertyModel;
        ei.get = get;
        ei.keys = keys;
        ei.entityClass = entityClass;
        ei.hasStream = OAtomStreamEntity.class.isAssignableFrom(entityClass);
        ei.id = new Func1<Object, HashMap<String, Object>>(){

            @Override
            public HashMap<String, Object> apply(Object input) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                for (String key : keys) {
                    values.put(key, ((InMemoryEntityInfo)((InMemoryProducer)InMemoryProducer.this).eis.get((Object)entitySetName)).properties.getPropertyValue(input, key));
                }
                return values;
            }
        };
        this.eis.put(entitySetName, ei);
        this.metadata = null;
    }

    protected OEntity toOEntity(EdmEntitySet ees, Object obj, List<EntitySimpleProperty> expand) {
        InMemoryEntityInfo<?> ei = this.eis.get(ees.getName());
        ArrayList<OLink> links = new ArrayList<OLink>();
        ArrayList properties = new ArrayList();
        HashMap<String, Object> keyKVPair = new HashMap<String, Object>();
        for (String key : ei.keys) {
            Object keyValue = ei.properties.getPropertyValue(obj, key);
            keyKVPair.put(key, keyValue);
        }
        for (String propName : ei.properties.getPropertyNames()) {
            Object value = ei.properties.getPropertyValue(obj, propName);
            Class<?> propType = ei.properties.getPropertyType(propName);
            EdmSimpleType<?> type = this.typeMapping.findEdmType(propType);
            if (type == null) continue;
            properties.add(OProperties.simple(propName, type, value));
        }
        if (expand != null && !expand.isEmpty()) {
            EdmEntityType edmEntityType = ees.getType();
            HashMap expandedProps = new HashMap();
            for (EntitySimpleProperty propPath : expand) {
                List<EntitySimpleProperty> remainingPropPaths;
                String remainingPropPath;
                String[] props = propPath.getPropertyName().split("/", 2);
                String prop = props[0];
                String string = remainingPropPath = props.length > 1 ? props[1] : null;
                if (expandedProps.containsKey(prop)) {
                    if (remainingPropPath == null) continue;
                    remainingPropPaths = (List)expandedProps.get(prop);
                    remainingPropPaths.add(Expression.simpleProperty(remainingPropPath));
                    continue;
                }
                remainingPropPaths = new ArrayList();
                if (remainingPropPath != null) {
                    remainingPropPaths.add(Expression.simpleProperty(remainingPropPath));
                }
                expandedProps.put(prop, remainingPropPaths);
            }
            for (String prop : expandedProps.keySet()) {
                List remainingPropPath = (List)expandedProps.get(prop);
                EdmNavigationProperty edmNavProperty = edmEntityType.findNavigationProperty(prop);
                if (edmNavProperty == null) continue;
                if (edmNavProperty.getToRole().getMultiplicity() == EdmMultiplicity.MANY) {
                    ArrayList<OEntity> relatedEntities = new ArrayList<OEntity>();
                    Iterable<?> values = ei.properties.getCollectionValue(obj, prop);
                    if (values != null) {
                        EdmEntitySet relEntitySet = null;
                        for (final Object entity : values) {
                            if (relEntitySet == null) {
                                InMemoryEntityInfo<?> oei = Enumerable.create(this.eis.values()).firstOrNull(new Predicate1<InMemoryEntityInfo<?>>(){

                                    @Override
                                    public boolean apply(InMemoryEntityInfo<?> input) {
                                        return entity.getClass().equals(input.entityClass);
                                    }
                                });
                                relEntitySet = this.getMetadata().getEdmEntitySet(oei.entitySetName);
                            }
                            relatedEntities.add(this.toOEntity(relEntitySet, entity, remainingPropPath));
                        }
                    }
                    links.add(OLinks.relatedEntitiesInline(null, edmNavProperty.getName(), null, relatedEntities));
                    continue;
                }
                final Object entity = ei.properties.getPropertyValue(obj, prop);
                OEntity relatedEntity = null;
                if (entity != null) {
                    InMemoryEntityInfo<?> oei = Enumerable.create(this.eis.values()).firstOrNull(new Predicate1<InMemoryEntityInfo<?>>(){

                        @Override
                        public boolean apply(InMemoryEntityInfo<?> input) {
                            return entity.getClass().equals(input.entityClass);
                        }
                    });
                    EdmEntitySet relEntitySet = this.getMetadata().getEdmEntitySet(oei.entitySetName);
                    relatedEntity = this.toOEntity(relEntitySet, entity, remainingPropPath);
                }
                links.add(OLinks.relatedEntityInline(null, edmNavProperty.getName(), null, relatedEntity));
            }
        }
        for (final EdmNavigationProperty ep : ees.getType().getNavigationProperties()) {
            boolean expanded = null != Enumerable.create(links).firstOrNull(new Predicate1<OLink>(){

                @Override
                public boolean apply(OLink t) {
                    return t.getTitle().equals(ep.getName());
                }
            });
            if (expanded) continue;
            if (ep.getToRole().getMultiplicity() == EdmMultiplicity.MANY) {
                links.add(OLinks.relatedEntities(null, ep.getName(), null));
                continue;
            }
            links.add(OLinks.relatedEntity(null, ep.getName(), null));
        }
        return OEntities.create(ees, OEntityKey.create(keyKVPair), properties, links, obj);
    }

    private static Predicate1<Object> filterToPredicate(final BoolCommonExpression filter, final PropertyModel properties) {
        return new Predicate1<Object>(){

            @Override
            public boolean apply(Object input) {
                return InMemoryEvaluation.evaluate(filter, input, properties);
            }
        };
    }

    @Override
    public EntitiesResponse getEntities(String entitySetName, final QueryInfo queryInfo) {
        final EdmEntitySet ees = this.getMetadata().getEdmEntitySet(entitySetName);
        InMemoryEntityInfo<?> ei = this.eis.get(entitySetName);
        Enumerable<Object> objects = Enumerable.create(ei.get.apply()).cast(Object.class);
        if (queryInfo != null && queryInfo.filter != null) {
            objects = objects.where(InMemoryProducer.filterToPredicate(queryInfo.filter, ei.properties));
        }
        Integer inlineCount = null;
        if (queryInfo != null && queryInfo.inlineCount == InlineCount.ALLPAGES) {
            objects = Enumerable.create(objects.toList());
            inlineCount = objects.count();
        }
        if (queryInfo != null && queryInfo.orderBy != null) {
            objects = this.orderBy(objects, queryInfo.orderBy, ei.properties);
        }
        Enumerable<OEntity> entities = objects.select(new Func1<Object, OEntity>(){

            @Override
            public OEntity apply(Object input) {
                return InMemoryProducer.this.toOEntity(ees, input, queryInfo != null ? queryInfo.expand : null);
            }
        });
        if (queryInfo != null && queryInfo.skipToken != null) {
            final Boolean[] skipping = new Boolean[]{true};
            entities = entities.skipWhile(new Predicate1<OEntity>(){

                @Override
                public boolean apply(OEntity input) {
                    if (skipping[0].booleanValue()) {
                        String inputKey = input.getEntityKey().toKeyString();
                        if (queryInfo.skipToken.equals(inputKey)) {
                            skipping[0] = false;
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        if (queryInfo != null && queryInfo.skip != null) {
            entities = entities.skip(queryInfo.skip);
        }
        int limit = this.maxResults;
        if (queryInfo != null && queryInfo.top != null && queryInfo.top < limit) {
            limit = queryInfo.top;
        }
        entities = entities.take(limit + 1);
        List<OEntity> entitiesList = entities.toList();
        String skipToken = null;
        if (entitiesList.size() > limit) {
            skipToken = (entitiesList = Enumerable.create(entitiesList).take(limit).toList()).size() == 0 ? null : Enumerable.create(entitiesList).last().getEntityKey().toKeyString();
        }
        return Responses.entities(entitiesList, ees, inlineCount, skipToken);
    }

    @Override
    public CountResponse getEntitiesCount(String entitySetName, final QueryInfo queryInfo) {
        final EdmEntitySet ees = this.getMetadata().getEdmEntitySet(entitySetName);
        InMemoryEntityInfo<?> ei = this.eis.get(entitySetName);
        Enumerable<Object> objects = Enumerable.create(ei.get.apply()).cast(Object.class);
        if (queryInfo != null && queryInfo.filter != null) {
            objects = objects.where(InMemoryProducer.filterToPredicate(queryInfo.filter, ei.properties));
        }
        if (queryInfo != null && queryInfo.inlineCount == InlineCount.ALLPAGES) {
            throw new UnsupportedOperationException("$inlinecount cannot be applied to the resource segment '$count'");
        }
        Enumerable<OEntity> entities = objects.select(new Func1<Object, OEntity>(){

            @Override
            public OEntity apply(Object input) {
                return InMemoryProducer.this.toOEntity(ees, input, queryInfo != null ? queryInfo.expand : null);
            }
        });
        if (queryInfo != null && queryInfo.skipToken != null) {
            throw new UnsupportedOperationException("Skip tokens can only be provided for requests that return collections of entities.");
        }
        if (queryInfo != null && queryInfo.skip != null) {
            entities = entities.skip(queryInfo.skip);
        }
        int limit = Integer.MAX_VALUE;
        if (queryInfo != null && queryInfo.top != null && queryInfo.top < limit) {
            limit = queryInfo.top;
        }
        entities = entities.take(limit);
        return Responses.count(entities.count());
    }

    private Enumerable<Object> orderBy(Enumerable<Object> iter, List<OrderByExpression> orderBys, final PropertyModel properties) {
        for (final OrderByExpression orderBy : Enumerable.create(orderBys).reverse()) {
            iter = iter.orderBy(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Comparable lhs = (Comparable)InMemoryEvaluation.evaluate(orderBy.getExpression(), o1, properties);
                    Comparable rhs = (Comparable)InMemoryEvaluation.evaluate(orderBy.getExpression(), o2, properties);
                    return (orderBy.getDirection() == OrderByExpression.Direction.ASCENDING ? 1 : -1) * lhs.compareTo(rhs);
                }
            });
        }
        return iter;
    }

    @Override
    public EntityResponse getEntity(String entitySetName, final OEntityKey entityKey, EntityQueryInfo queryInfo) {
        EdmEntitySet ees = this.getMetadata().getEdmEntitySet(entitySetName);
        final InMemoryEntityInfo<?> ei = this.eis.get(entitySetName);
        final String[] keyList = ei.keys;
        Iterable iter = ei.get.apply();
        Object rt = Enumerable.create(iter).firstOrNull(new Predicate1<Object>(){

            @Override
            public boolean apply(Object input) {
                HashMap<String, Object> idObjectMap = ei.id.apply(input);
                if (keyList.length == 1) {
                    Object idValue = entityKey.asSingleValue();
                    return idObjectMap.get(keyList[0]).equals(idValue);
                }
                if (keyList.length > 1) {
                    for (String key : keyList) {
                        Object curValue = null;
                        for (OProperty<?> keyProp : entityKey.asComplexProperties()) {
                            if (!keyProp.getName().equalsIgnoreCase(key)) continue;
                            curValue = keyProp.getValue();
                        }
                        if (curValue == null) {
                            return false;
                        }
                        if (idObjectMap.get(key).equals(curValue)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
        if (rt == null) {
            throw new NotFoundException();
        }
        OEntity oe = this.toOEntity(ees, rt, queryInfo.expand);
        return Responses.entity(oe);
    }

    @Override
    public void mergeEntity(String entitySetName, OEntity entity) {
        throw new NotImplementedException();
    }

    @Override
    public void updateEntity(String entitySetName, OEntity entity) {
        throw new NotImplementedException();
    }

    @Override
    public void deleteEntity(String entitySetName, OEntityKey entityKey) {
        throw new NotImplementedException();
    }

    @Override
    public EntityResponse createEntity(String entitySetName, OEntity entity) {
        throw new NotImplementedException();
    }

    @Override
    public EntityResponse createEntity(String entitySetName, OEntityKey entityKey, String navProp, OEntity entity) {
        throw new NotImplementedException();
    }

    @Override
    public BaseResponse getNavProperty(String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        throw new NotImplementedException();
    }

    @Override
    public CountResponse getNavPropertyCount(String entitySetName, OEntityKey entityKey, String navProp, QueryInfo queryInfo) {
        throw new NotImplementedException();
    }

    @Override
    public EntityIdResponse getLinks(OEntityId sourceEntity, String targetNavProp) {
        throw new NotImplementedException();
    }

    @Override
    public void createLink(OEntityId sourceEntity, String targetNavProp, OEntityId targetEntity) {
        throw new NotImplementedException();
    }

    @Override
    public void updateLink(OEntityId sourceEntity, String targetNavProp, OEntityKey oldTargetEntityKey, OEntityId newTargetEntity) {
        throw new NotImplementedException();
    }

    @Override
    public void deleteLink(OEntityId sourceEntity, String targetNavProp, OEntityKey targetEntityKey) {
        throw new NotImplementedException();
    }

    @Override
    public BaseResponse callFunction(EdmFunctionImport name, Map<String, OFunctionParameter> params, QueryInfo queryInfo) {
        throw new NotImplementedException();
    }
}

