/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.core4j.Enumerable;
import org.core4j.Func1;
import org.core4j.Predicate1;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OLink;
import org.odata4j.core.OLinks;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.core.Throwables;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.Expression;
import org.odata4j.producer.Responses;
import org.odata4j.producer.jpa.Command;
import org.odata4j.producer.jpa.CountResult;
import org.odata4j.producer.jpa.EntitiesResult;
import org.odata4j.producer.jpa.EntityResult;
import org.odata4j.producer.jpa.JPAContext;
import org.odata4j.producer.jpa.JPAEdmGenerator;
import org.odata4j.producer.jpa.JPAMember;
import org.odata4j.producer.jpa.JPAProducer;
import org.odata4j.producer.jpa.JPASkipToken;
import org.odata4j.producer.jpa.PropertyResult;

public class SetResponseCommand
implements Command {
    private JPAContext.EntityAccessor accessor;

    public SetResponseCommand() {
        this(JPAContext.EntityAccessor.ENTITY);
    }

    public SetResponseCommand(JPAContext.EntityAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public boolean execute(final JPAContext context) {
        if (context.getResult() instanceof EntityResult) {
            EntityResult result = (EntityResult)context.getResult();
            OEntity oentity = this.makeEntity(context, result.getEntity());
            context.setResponse(Responses.entity(oentity));
        } else if (context.getResult() instanceof EntitiesResult) {
            EntitiesResult result = (EntitiesResult)context.getResult();
            List<OEntity> entities = Enumerable.create(result.getEntities()).select(new Func1<Object, OEntity>(){

                @Override
                public OEntity apply(Object jpaEntity) {
                    return SetResponseCommand.this.makeEntity(context, jpaEntity);
                }
            }).toList();
            String skipToken = null;
            if (result.createSkipToken()) {
                skipToken = JPASkipToken.create(context.getQueryInfo() == null ? null : context.getQueryInfo().orderBy, Enumerable.create(entities).last());
            }
            context.setResponse(Responses.entities(entities, context.getEntity().getEdmEntitySet(), result.getInlineCount(), skipToken));
        } else if (context.getResult() instanceof PropertyResult) {
            PropertyResult result = (PropertyResult)context.getResult();
            OProperty op = OProperties.simple(result.getName(), result.getType(), result.getValue());
            context.setResponse(Responses.property(op));
        } else if (context.getResult() instanceof CountResult) {
            CountResult result = (CountResult)context.getResult();
            context.setResponse(Responses.count(result.getCount()));
        }
        return false;
    }

    private OEntity makeEntity(JPAContext context, Object jpaEntity) {
        return this.jpaEntityToOEntity(context.getMetadata(), this.accessor.getEntity(context).getEdmEntitySet(), this.accessor.getEntity(context).getJPAEntityType(), jpaEntity, context.getQueryInfo() == null ? null : context.getQueryInfo().expand, context.getQueryInfo() == null ? null : context.getQueryInfo().select);
    }

    private OEntity jpaEntityToOEntity(EdmDataServices metadata, EdmEntitySet ees, EntityType<?> entityType, Object jpaEntity, List<EntitySimpleProperty> expand, List<EntitySimpleProperty> select) {
        ArrayList properties = new ArrayList();
        ArrayList<OLink> links = new ArrayList<OLink>();
        try {
            SingularAttribute<?, ?> idAtt = JPAEdmGenerator.getIdAttribute(entityType);
            boolean hasEmbeddedCompositeKey = idAtt.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED;
            for (EdmProperty edmProperty : ees.getType().getProperties()) {
                if (!JPAProducer.isSelected(edmProperty.getName(), select)) continue;
                if (hasEmbeddedCompositeKey && ees.getType().getKeys().contains(edmProperty.getName())) {
                    Object value = SetResponseCommand.getIdValue(jpaEntity, idAtt, edmProperty.getName());
                    properties.add(OProperties.simple(edmProperty.getName(), (EdmSimpleType)edmProperty.getType(), value));
                    continue;
                }
                Attribute att = entityType.getAttribute(edmProperty.getName());
                JPAMember member = JPAMember.create(att, jpaEntity);
                Object value = member.get();
                if (!edmProperty.getType().isSimple()) continue;
                properties.add(OProperties.simple(edmProperty.getName(), (EdmSimpleType)edmProperty.getType(), value));
            }
            if (expand != null && !expand.isEmpty()) {
                HashMap expandedProps = new HashMap();
                for (EntitySimpleProperty propPath : expand) {
                    List<EntitySimpleProperty> remainingPropPaths;
                    String remainingPropPath;
                    String[] props = propPath.getPropertyName().split("/", 2);
                    String prop = props[0];
                    String string = remainingPropPath = props.length > 1 ? props[1] : null;
                    if (expandedProps.containsKey(prop)) {
                        if (remainingPropPath == null) continue;
                        remainingPropPaths = (List)expandedProps.get(prop);
                        remainingPropPaths.add(Expression.simpleProperty(remainingPropPath));
                        continue;
                    }
                    remainingPropPaths = new ArrayList();
                    if (remainingPropPath != null) {
                        remainingPropPaths.add(Expression.simpleProperty(remainingPropPath));
                    }
                    expandedProps.put(prop, remainingPropPaths);
                }
                for (String prop : expandedProps.keySet()) {
                    List remainingPropPath = (List)expandedProps.get(prop);
                    Attribute att = entityType.getAttribute(prop);
                    if (att.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_MANY || att.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_MANY) {
                        Collection value = (Collection)JPAMember.create(att, jpaEntity).get();
                        ArrayList<OEntity> relatedEntities = new ArrayList<OEntity>();
                        for (Object relatedEntity : value) {
                            EntityType elementEntityType = (EntityType)((PluralAttribute)att).getElementType();
                            EdmEntitySet elementEntitySet = metadata.getEdmEntitySet(JPAEdmGenerator.getEntitySetName(elementEntityType));
                            relatedEntities.add(this.jpaEntityToOEntity(metadata, elementEntitySet, elementEntityType, relatedEntity, remainingPropPath, null));
                        }
                        links.add(OLinks.relatedEntitiesInline(null, prop, null, relatedEntities));
                        continue;
                    }
                    if (att.getPersistentAttributeType() != Attribute.PersistentAttributeType.ONE_TO_ONE && att.getPersistentAttributeType() != Attribute.PersistentAttributeType.MANY_TO_ONE) continue;
                    EntityType relatedEntityType = (EntityType)((SingularAttribute)att).getType();
                    EdmEntitySet relatedEntitySet = metadata.getEdmEntitySet(JPAEdmGenerator.getEntitySetName(relatedEntityType));
                    Object relatedEntity = JPAMember.create(att, jpaEntity).get();
                    if (relatedEntity == null) {
                        links.add(OLinks.relatedEntityInline(null, prop, null, null));
                        continue;
                    }
                    links.add(OLinks.relatedEntityInline(null, prop, null, this.jpaEntityToOEntity(metadata, relatedEntitySet, relatedEntityType, relatedEntity, remainingPropPath, null)));
                }
            }
            for (final EdmNavigationProperty edmNavigationProperty : ees.getType().getNavigationProperties()) {
                boolean expanded;
                if (!JPAProducer.isSelected(edmNavigationProperty.getName(), select) || (expanded = null != Enumerable.create(links).firstOrNull(new Predicate1<OLink>(){

                    @Override
                    public boolean apply(OLink t) {
                        return t.getTitle().equals(edmNavigationProperty.getName());
                    }
                }))) continue;
                if (edmNavigationProperty.getToRole().getMultiplicity() == EdmMultiplicity.MANY) {
                    links.add(OLinks.relatedEntities(null, edmNavigationProperty.getName(), null));
                    continue;
                }
                links.add(OLinks.relatedEntity(null, edmNavigationProperty.getName(), null));
            }
            return OEntities.create(ees, SetResponseCommand.toOEntityKey(jpaEntity, idAtt), properties, links);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    static Object getIdValue(Object jpaEntity, SingularAttribute<?, ?> idAtt, String propName) {
        try {
            Object keyValue = JPAMember.create(idAtt, jpaEntity).get();
            if (propName == null) {
                return keyValue;
            }
            ManagedType keyType = (ManagedType)idAtt.getType();
            Attribute att = keyType.getAttribute(propName);
            return JPAMember.create(att, keyValue).get();
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    static OEntityKey toOEntityKey(Object jpaEntity, SingularAttribute<?, ?> idAtt) {
        boolean hasEmbeddedCompositeKey;
        boolean bl = hasEmbeddedCompositeKey = idAtt.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED;
        if (!hasEmbeddedCompositeKey) {
            Object id = SetResponseCommand.getIdValue(jpaEntity, idAtt, null);
            return OEntityKey.create(id);
        }
        ManagedType keyType = (ManagedType)idAtt.getType();
        HashMap<String, Object> nameValues = new HashMap<String, Object>();
        for (Attribute att : keyType.getAttributes()) {
            nameValues.put(att.getName(), SetResponseCommand.getIdValue(jpaEntity, idAtt, att.getName()));
        }
        return OEntityKey.create(nameValues);
    }
}

