/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.resources;

import java.io.StringWriter;
import java.util.logging.Logger;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import org.odata4j.core.ODataConstants;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityIds;
import org.odata4j.core.OEntityKey;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.FormatWriterFactory;
import org.odata4j.producer.EntityQueryInfo;
import org.odata4j.producer.EntityResponse;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.resources.BaseResource;
import org.odata4j.producer.resources.LinksRequestResource;
import org.odata4j.producer.resources.OptionsQueryParser;
import org.odata4j.producer.resources.PropertyRequestResource;

@Path(value="{entitySetName}{id: \\(.+?\\)}")
public class EntityRequestResource
extends BaseResource {
    private static final Logger log = Logger.getLogger(EntityRequestResource.class.getName());

    @PUT
    public Response updateEntity(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context ContextResolver<ODataProducer> producerResolver, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id, String payload) {
        log.info(String.format("updateEntity(%s,%s)", entitySetName, id));
        ODataProducer producer = producerResolver.getContext(ODataProducer.class);
        OEntity entity = this.getRequestEntity(httpHeaders, uriInfo, payload, producer.getMetadata(), entitySetName, OEntityKey.parse(id));
        producer.updateEntity(entitySetName, entity);
        return Response.ok().header("DataServiceVersion", ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
    }

    @POST
    public Response mergeEntity(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context ContextResolver<ODataProducer> producerResolver, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id, String payload) {
        log.info(String.format("mergeEntity(%s,%s)", entitySetName, id));
        ODataProducer producer = producerResolver.getContext(ODataProducer.class);
        OEntityKey entityKey = OEntityKey.parse(id);
        String method = httpHeaders.getRequestHeaders().getFirst("X-HTTP-METHOD");
        if ("MERGE".equals(method)) {
            OEntity entity = this.getRequestEntity(httpHeaders, uriInfo, payload, producer.getMetadata(), entitySetName, entityKey);
            producer.mergeEntity(entitySetName, entity);
            return Response.ok().header("DataServiceVersion", ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
        }
        if ("DELETE".equals(method)) {
            producer.deleteEntity(entitySetName, entityKey);
            return Response.ok().header("DataServiceVersion", ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
        }
        if ("PUT".equals(method)) {
            OEntity entity = this.getRequestEntity(httpHeaders, uriInfo, payload, producer.getMetadata(), entitySetName, OEntityKey.parse(id));
            producer.updateEntity(entitySetName, entity);
            return Response.ok().header("DataServiceVersion", ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
        }
        throw new RuntimeException("Expected a tunnelled PUT, MERGE or DELETE");
    }

    @DELETE
    public Response deleteEntity(@Context ContextResolver<ODataProducer> producerResolver, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id) {
        log.info(String.format("getEntity(%s,%s)", entitySetName, id));
        ODataProducer producer = producerResolver.getContext(ODataProducer.class);
        OEntityKey entityKey = OEntityKey.parse(id);
        producer.deleteEntity(entitySetName, entityKey);
        return Response.ok().header("DataServiceVersion", ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
    }

    @GET
    @Produces(value={"application/atom+xml;charset=utf-8", "text/javascript;charset=utf-8", "application/json;charset=utf-8"})
    public Response getEntity(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context ContextResolver<ODataProducer> producerResolver, @PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id, @QueryParam(value="$format") String format, @QueryParam(value="$callback") String callback, @QueryParam(value="$expand") String expand, @QueryParam(value="$select") String select) {
        ODataProducer producer = producerResolver.getContext(ODataProducer.class);
        return this.getEntityImpl(httpHeaders, uriInfo, producer, entitySetName, id, format, callback, expand, select);
    }

    protected Response getEntityImpl(HttpHeaders httpHeaders, UriInfo uriInfo, ODataProducer producer, String entitySetName, String id, String format, String callback, String expand, String select) {
        EntityQueryInfo query = new EntityQueryInfo(null, OptionsQueryParser.parseCustomOptions(uriInfo), OptionsQueryParser.parseExpand(expand), OptionsQueryParser.parseSelect(select));
        log.info(String.format("getEntity(%s,%s,%s,%s)", entitySetName, id, expand, select));
        EntityResponse response = producer.getEntity(entitySetName, OEntityKey.parse(id), query);
        StringWriter sw = new StringWriter();
        FormatWriter<EntityResponse> fw = FormatWriterFactory.getFormatWriter(EntityResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
        fw.write(uriInfo, sw, response);
        String entity = sw.toString();
        return Response.ok((Object)entity, fw.getContentType()).header("DataServiceVersion", ODataConstants.DATA_SERVICE_VERSION_HEADER).build();
    }

    @Path(value="{first: \\$}links/{targetNavProp:.+?}{targetId: (\\(.+?\\))?}")
    public LinksRequestResource getLinks(@PathParam(value="entitySetName") String entitySetName, @PathParam(value="id") String id, @PathParam(value="targetNavProp") String targetNavProp, @PathParam(value="targetId") String targetId) {
        OEntityKey targetEntityKey = targetId == null || targetId.isEmpty() ? null : OEntityKey.parse(targetId);
        return new LinksRequestResource(OEntityIds.create(entitySetName, OEntityKey.parse(id)), targetNavProp, targetEntityKey);
    }

    @Path(value="{navProp: .+}")
    public PropertyRequestResource getNavProperty() {
        return new PropertyRequestResource();
    }

    @Path(value="{navProp: .+?}{optionalParens: ((\\(\\)))}")
    public PropertyRequestResource getSimpleNavProperty() {
        return new PropertyRequestResource();
    }
}

