/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.producer.resources;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.odata4j.core.ODataConstants;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OFunctionParameter;
import org.odata4j.core.OFunctionParameters;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmFunctionParameter;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.FormatWriterFactory;
import org.odata4j.producer.BaseResponse;
import org.odata4j.producer.CollectionResponse;
import org.odata4j.producer.ComplexObjectResponse;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.exceptions.NotImplementedException;
import org.odata4j.producer.resources.BaseResource;
import org.odata4j.producer.resources.OptionsQueryParser;

public class FunctionResource
extends BaseResource {
    public static Response callFunction(HttpHeaders httpHeaders, UriInfo uriInfo, ODataProducer producer, String functionName, String format, String callback, String skipToken) throws Exception {
        FormatWriter<BaseResponse> fwBase;
        FormatWriter<BaseResponse> fw;
        Map<String, String> opts = OptionsQueryParser.parseCustomOptions(uriInfo);
        EdmFunctionImport function = producer.getMetadata().findEdmFunctionImport(functionName);
        if (function == null) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        BaseResponse response = producer.callFunction(function, FunctionResource.getFunctionParameters(function, opts), null);
        if (response == null) {
            return Response.status(Response.Status.NO_CONTENT).build();
        }
        ODataVersion version = ODataConstants.DATA_SERVICE_VERSION;
        StringWriter sw = new StringWriter();
        if (response instanceof ComplexObjectResponse) {
            fw = FormatWriterFactory.getFormatWriter(ComplexObjectResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
            fw.write(uriInfo, sw, (ComplexObjectResponse)response);
            fwBase = fw;
        } else if (response instanceof CollectionResponse) {
            fw = FormatWriterFactory.getFormatWriter(CollectionResponse.class, httpHeaders.getAcceptableMediaTypes(), format, callback);
            fw.write(uriInfo, sw, (ComplexObjectResponse)((Object)((CollectionResponse)response)));
            fwBase = fw;
        } else {
            throw new NotImplementedException("Unknown BaseResponse type: " + response.getClass().getName());
        }
        String entity = sw.toString();
        return Response.ok((Object)entity, fwBase.getContentType()).header("DataServiceVersion", version.asString).build();
    }

    private static Map<String, OFunctionParameter> getFunctionParameters(EdmFunctionImport function, Map<String, String> opts) {
        HashMap<String, OFunctionParameter> m = new HashMap<String, OFunctionParameter>();
        for (EdmFunctionParameter p : function.getParameters()) {
            String val = opts.get(p.getName());
            m.put(p.getName(), val == null ? null : OFunctionParameters.parse(p.getName(), p.getType(), val));
        }
        return m;
    }
}

