/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl;

import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.core.header.AcceptableLanguageTag;
import com.sun.jersey.core.header.AcceptableMediaType;
import com.sun.jersey.core.header.AcceptableToken;
import com.sun.jersey.core.header.QualityFactor;
import com.sun.jersey.server.impl.model.HttpHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VariantSelector {
    private static final DimensionChecker<AcceptableMediaType, MediaType> MEDIA_TYPE_DC = new DimensionChecker<AcceptableMediaType, MediaType>(){

        @Override
        public MediaType getDimension(Variant v) {
            return v.getMediaType();
        }

        @Override
        public boolean isCompatible(AcceptableMediaType t, MediaType u) {
            return t.isCompatible(u);
        }
    };
    private static final DimensionChecker<AcceptableLanguageTag, Locale> LANGUAGE_TAG_DC = new DimensionChecker<AcceptableLanguageTag, Locale>(){

        @Override
        public Locale getDimension(Variant v) {
            return v.getLanguage();
        }

        @Override
        public boolean isCompatible(AcceptableLanguageTag t, Locale u) {
            return t.isCompatible(u);
        }
    };
    private static final DimensionChecker<AcceptableToken, String> CHARSET_DC = new DimensionChecker<AcceptableToken, String>(){

        @Override
        public String getDimension(Variant v) {
            MediaType m = v.getMediaType();
            return m != null ? m.getParameters().get("charset") : null;
        }

        @Override
        public boolean isCompatible(AcceptableToken t, String u) {
            return t.isCompatible(u);
        }
    };
    private static final DimensionChecker<AcceptableToken, String> ENCODING_DC = new DimensionChecker<AcceptableToken, String>(){

        @Override
        public String getDimension(Variant v) {
            return v.getEncoding();
        }

        @Override
        public boolean isCompatible(AcceptableToken t, String u) {
            return t.isCompatible(u);
        }
    };

    private VariantSelector() {
    }

    private static <T extends QualityFactor, U> void selectVariants(ListEntry<Variant> head, List<T> as, DimensionChecker<T, U> dc) {
        QualityFactor a;
        int q = 0;
        Iterator<T> i$ = as.iterator();
        while (i$.hasNext() && (a = (QualityFactor)i$.next()).getQuality() >= q) {
            ListEntry<Variant> i = head.next();
            while (i != null) {
                ListEntry<Variant> i_next = i.next();
                U d = dc.getDimension(i.value());
                if (d != null && dc.isCompatible(a, d)) {
                    q = a.getQuality();
                    head.insertAfter(i);
                    head = i;
                }
                i = i_next;
            }
        }
        ListEntry<Variant> i = head.next();
        while (i != null) {
            ListEntry<Variant> i_next = i.next();
            if (dc.getDimension(i.value()) == null) {
                head.insertAfter(i);
                head = i;
            }
            i = i_next;
        }
        head.removeTail();
    }

    public static Variant selectVariant(HttpRequestContext r, List<Variant> variants) {
        ListEntry<Variant> vs = ListEntry.create(variants);
        VariantSelector.selectVariants(vs, HttpHelper.getAccept(r), MEDIA_TYPE_DC);
        VariantSelector.selectVariants(vs, HttpHelper.getAcceptLangauge(r), LANGUAGE_TAG_DC);
        VariantSelector.selectVariants(vs, HttpHelper.getAcceptCharset(r), CHARSET_DC);
        VariantSelector.selectVariants(vs, HttpHelper.getAcceptEncoding(r), ENCODING_DC);
        return vs.next() != null ? vs.next().value() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface DimensionChecker<T, U> {
        public U getDimension(Variant var1);

        public boolean isCompatible(T var1, U var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ListEntry<T> {
        private T t;
        private ListEntry<T> prev;
        private ListEntry<T> next;

        public ListEntry() {
        }

        public ListEntry(ListEntry<T> prev, T t) {
            this.t = t;
            prev.next = this;
            this.prev = prev;
        }

        public T value() {
            return this.t;
        }

        public ListEntry<T> next() {
            return this.next;
        }

        public void removeTail() {
            if (this.next != null) {
                this.next.prev = null;
                this.next = null;
            }
        }

        public void remove() {
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            this.next = null;
            this.prev = null;
        }

        public void insertAfter(ListEntry<T> e) {
            if (this.next == e) {
                return;
            }
            e.remove();
            e.prev = this;
            e.next = this.next;
            if (e.next != null) {
                e.next.prev = e;
            }
            this.next = e;
        }

        public static <T> ListEntry<T> create(Collection<T> l) {
            ListEntry<T> head;
            ListEntry<T> e = head = new ListEntry<T>();
            for (T t : l) {
                e = new ListEntry<T>(e, t);
            }
            return head;
        }
    }
}

