/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.core4j.Enumerable;
import org.core4j.Func;
import org.core4j.ReadOnlyIterator;
import org.joda.time.LocalDateTime;
import org.odata4j.consumer.AbstractConsumerQueryRequestBase;
import org.odata4j.consumer.ODataClient;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.consumer.ODataClientResponse;
import org.odata4j.core.Guid;
import org.odata4j.core.OCollection;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OFunctionParameter;
import org.odata4j.core.OFunctionParameters;
import org.odata4j.core.OFunctionRequest;
import org.odata4j.core.OObject;
import org.odata4j.core.OSimpleObject;
import org.odata4j.core.OSimpleObjects;
import org.odata4j.core.UnsignedByte;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.exceptions.ODataProducerException;
import org.odata4j.expression.Expression;
import org.odata4j.expression.LiteralExpression;
import org.odata4j.format.FormatParser;
import org.odata4j.format.FormatParserFactory;
import org.odata4j.format.Settings;
import org.odata4j.internal.InternalUtil;

public class ConsumerFunctionCallRequest<T extends OObject>
extends AbstractConsumerQueryRequestBase<T>
implements OFunctionRequest<T> {
    private final List<OFunctionParameter> params = new LinkedList<OFunctionParameter>();
    private final EdmFunctionImport function;

    public ConsumerFunctionCallRequest(ODataClient client, String serviceRootUri, EdmDataServices metadata, String lastSegment) {
        super(client, serviceRootUri, metadata, lastSegment);
        this.function = metadata.findEdmFunctionImport(lastSegment);
        if (this.function == null) {
            throw new IllegalArgumentException("Function Import " + lastSegment + " not defined");
        }
    }

    @Override
    public Enumerable<T> execute() throws ODataProducerException {
        Enumerable<Object> results;
        for (OFunctionParameter p : this.params) {
            this.custom(p.getName(), ConsumerFunctionCallRequest.toUriString(p));
        }
        final ODataClientRequest request = this.buildRequest(null);
        if (this.function.getReturnType() == null) {
            results = Enumerable.empty(null);
        } else if (this.function.getReturnType() instanceof EdmCollectionType) {
            final OCollection collection = (OCollection)this.doRequest(request);
            results = Enumerable.createFromIterator(new Func<Iterator<OObject>>(){

                @Override
                public Iterator<OObject> apply() {
                    return new FunctionResultsIterator(request, collection);
                }
            });
        } else {
            results = Enumerable.create(this.doRequest(request));
        }
        return results;
    }

    private static String toUriString(OFunctionParameter p) {
        OObject obj = (OObject)p.getValue();
        if (obj instanceof OSimpleObject) {
            OSimpleObject simple = (OSimpleObject)obj;
            LiteralExpression le = Expression.literal(simple.getType(), simple.getValue());
            return Expression.asFilterString(le);
        }
        throw new UnsupportedOperationException("type not supported: " + obj.getType().getFullyQualifiedTypeName());
    }

    @Override
    public ConsumerFunctionCallRequest<T> parameter(String name, OObject value) {
        this.params.add(OFunctionParameters.create(name, value));
        return this;
    }

    @Override
    public OFunctionRequest<T> pBoolean(String name, boolean value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.BOOLEAN, value));
    }

    @Override
    public OFunctionRequest<T> pByte(String name, UnsignedByte value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.BYTE, value));
    }

    @Override
    public OFunctionRequest<T> pSByte(String name, byte value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.SBYTE, value));
    }

    @Override
    public OFunctionRequest<T> pDateTime(String name, Calendar value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.DATETIME, value));
    }

    @Override
    public OFunctionRequest<T> pDateTime(String name, Date value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.DATETIME, value));
    }

    @Override
    public OFunctionRequest<T> pDateTime(String name, LocalDateTime value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.DATETIME, value));
    }

    @Override
    public OFunctionRequest<T> pDecimal(String name, BigDecimal value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.DECIMAL, value));
    }

    @Override
    public OFunctionRequest<T> pDouble(String name, double value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.DOUBLE, value));
    }

    @Override
    public OFunctionRequest<T> pGuid(String name, Guid value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.GUID, value));
    }

    @Override
    public OFunctionRequest<T> pInt16(String name, short value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.INT16, value));
    }

    @Override
    public OFunctionRequest<T> pInt32(String name, int value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.INT32, value));
    }

    @Override
    public OFunctionRequest<T> pInt64(String name, long value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.INT64, value));
    }

    @Override
    public OFunctionRequest<T> pSingle(String name, float value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.SINGLE, Float.valueOf(value)));
    }

    @Override
    public OFunctionRequest<T> pTime(String name, Calendar value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.TIME, value));
    }

    @Override
    public OFunctionRequest<T> pTime(String name, Date value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.TIME, value));
    }

    @Override
    public OFunctionRequest<T> pTime(String name, LocalDateTime value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.TIME, value));
    }

    @Override
    public OFunctionRequest<T> pString(String name, String value) {
        return this.parameter(name, OSimpleObjects.create(EdmSimpleType.STRING, value));
    }

    private OObject doRequest(ODataClientRequest request) throws ODataProducerException {
        ODataClientResponse response = this.getClient().callFunction(request);
        ODataVersion version = InternalUtil.getDataServiceVersion(response.getHeaders().getFirst("DataServiceVersion"));
        FormatParser<OSimpleObject> parser = FormatParserFactory.getParser(this.function.getReturnType().isSimple() ? OSimpleObject.class : EdmType.getInstanceType(this.function.getReturnType()), this.getClient().getFormatType(), new Settings(version, this.getMetadata(), this.function.getName(), null, null, true, this.function.getReturnType()));
        OObject object = parser.parse(this.getClient().getFeedReader(response));
        response.close();
        return object;
    }

    private class FunctionResultsIterator
    extends ReadOnlyIterator<OObject> {
        private ODataClientRequest request;
        private OCollection<OObject> current = null;
        private Iterator<OObject> iter = null;
        private int count = 0;

        public FunctionResultsIterator(ODataClientRequest request, OCollection<OObject> current) {
            this.request = request;
            this.current = current;
            this.iter = current.iterator();
        }

        @Override
        protected ReadOnlyIterator.IterationResult<OObject> advance() throws Exception {
            if (this.current == null) {
                this.current = (OCollection)ConsumerFunctionCallRequest.this.doRequest(this.request);
                this.iter = this.current.iterator();
                this.count = 0;
            }
            if (this.iter != null && this.iter.hasNext()) {
                ++this.count;
                return ReadOnlyIterator.IterationResult.next(this.iter.next());
            }
            return ReadOnlyIterator.IterationResult.done();
        }
    }
}

