/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.core;

import org.odata4j.core.OFunctionParameter;
import org.odata4j.core.OObject;
import org.odata4j.core.OSimpleObjects;
import org.odata4j.core.UnsignedByte;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.exceptions.NotImplementedException;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.Expression;
import org.odata4j.expression.ExpressionParser;
import org.odata4j.expression.LiteralExpression;

public class OFunctionParameters {
    private OFunctionParameters() {
    }

    public static <T> OFunctionParameter create(String name, T value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot infer EdmType if value is null");
        }
        if (value instanceof OObject) {
            return new FunctionParameterImpl(name, (OObject)value);
        }
        EdmSimpleType type = EdmSimpleType.forJavaType(value.getClass());
        return new FunctionParameterImpl(name, OSimpleObjects.create(type, value));
    }

    public static OFunctionParameter parse(String name, EdmType type, String value) {
        CommonExpression ce;
        if (type instanceof EdmSimpleType && (ce = ExpressionParser.parse(value)) instanceof LiteralExpression) {
            Object val = OFunctionParameters.convert(Expression.literalValue((LiteralExpression)ce), (EdmSimpleType)type);
            return new FunctionParameterImpl(name, OSimpleObjects.create((EdmSimpleType)type, val));
        }
        throw new NotImplementedException();
    }

    private static Object convert(Object val, EdmSimpleType<?> type) {
        Object v = val;
        if (type.equals(EdmSimpleType.INT16) && !(val instanceof Short)) {
            v = ((Number)val).shortValue();
        } else if (type.equals(EdmSimpleType.SINGLE) && !(val instanceof Float)) {
            v = new Float(((Number)val).floatValue());
        } else if (type.equals(EdmSimpleType.BYTE) && !(val instanceof UnsignedByte)) {
            v = UnsignedByte.valueOf(((Number)val).intValue());
        } else if (type.equals(EdmSimpleType.SBYTE) && !(val instanceof Byte)) {
            v = ((Number)val).byteValue();
        }
        return v;
    }

    private static class FunctionParameterImpl
    implements OFunctionParameter {
        private final String name;
        private final OObject obj;

        public FunctionParameterImpl(String name, OObject obj) {
            this.name = name;
            this.obj = obj;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public EdmType getType() {
            return this.obj.getType();
        }

        @Override
        public OObject getValue() {
            return this.obj;
        }

        public String toString() {
            return String.format("OFunctionParameter[%s,%s,%s]", this.getName(), this.getType(), this.getValue());
        }
    }
}

