/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.cxf.consumer;

import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.jaxrs.impl.RuntimeDelegateImpl;
import org.odata4j.consumer.AbstractODataConsumer;
import org.odata4j.consumer.ODataClient;
import org.odata4j.consumer.ODataConsumer;
import org.odata4j.consumer.behaviors.OClientBehavior;
import org.odata4j.cxf.consumer.ODataCxfClient;
import org.odata4j.format.FormatType;

public class ODataCxfConsumer
extends AbstractODataConsumer {
    private ODataCxfClient client;

    private ODataCxfConsumer(FormatType type, String serviceRootUri, OClientBehavior ... behaviors) {
        super(serviceRootUri);
        if (!(RuntimeDelegate.getInstance() instanceof RuntimeDelegateImpl)) {
            RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        }
        this.client = new ODataCxfClient(type, behaviors);
    }

    @Override
    protected ODataClient getClient() {
        return this.client;
    }

    public static Builder newBuilder(String serviceRootUri) {
        return new Builder(serviceRootUri);
    }

    public static ODataCxfConsumer create(String serviceRootUri) {
        return ODataCxfConsumer.newBuilder(serviceRootUri).build();
    }

    public static class Builder
    implements ODataConsumer.Builder {
        private FormatType formatType;
        private String serviceRootUri;
        private OClientBehavior[] clientBehaviors;

        private Builder(String serviceRootUri) {
            this.serviceRootUri = serviceRootUri;
            this.formatType = FormatType.ATOM;
        }

        @Override
        public Builder setFormatType(FormatType formatType) {
            this.formatType = formatType;
            return this;
        }

        @Override
        public Builder setClientBehaviors(OClientBehavior ... clientBehaviors) {
            this.clientBehaviors = clientBehaviors;
            return this;
        }

        @Override
        public ODataCxfConsumer build() {
            if (this.clientBehaviors != null) {
                return new ODataCxfConsumer(this.formatType, this.serviceRootUri, this.clientBehaviors);
            }
            return new ODataCxfConsumer(this.formatType, this.serviceRootUri, new OClientBehavior[0]);
        }
    }
}

