/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import java.util.ArrayList;
import java.util.List;
import org.odata4j.core.ImmutableList;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmDocumentation;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmFunctionParameter;
import org.odata4j.edm.EdmItem;
import org.odata4j.edm.EdmType;

public class EdmFunctionImport
extends EdmItem {
    private final String name;
    private final EdmEntitySet entitySet;
    private final EdmType returnType;
    private final String httpMethod;
    private final ImmutableList<EdmFunctionParameter> parameters;

    private EdmFunctionImport(String name, EdmEntitySet entitySet, EdmType returnType, String httpMethod, ImmutableList<EdmFunctionParameter> parameters, EdmDocumentation doc, ImmutableList<EdmAnnotation<?>> annots) {
        super(doc, annots);
        this.name = name;
        this.entitySet = entitySet;
        this.returnType = returnType;
        this.httpMethod = httpMethod;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public EdmEntitySet getEntitySet() {
        return this.entitySet;
    }

    public EdmType getReturnType() {
        return this.returnType;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public List<EdmFunctionParameter> getParameters() {
        return this.parameters;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static Builder newBuilder(EdmFunctionImport functionImport, EdmItem.BuilderContext context) {
        return context.newBuilder(functionImport, new Builder());
    }

    public static class Builder
    extends EdmItem.Builder<EdmFunctionImport, Builder> {
        private String name;
        private EdmEntitySet.Builder entitySet;
        private String entitySetName;
        private EdmType returnType;
        private EdmType.Builder<?, ?> returnTypeBuilder;
        private String returnTypeName;
        private String httpMethod;
        private final List<EdmFunctionParameter.Builder> parameters = new ArrayList<EdmFunctionParameter.Builder>();
        private boolean isCollection;

        @Override
        Builder newBuilder(EdmFunctionImport functionImport, EdmItem.BuilderContext context) {
            ArrayList<EdmFunctionParameter.Builder> functionParameters = new ArrayList<EdmFunctionParameter.Builder>();
            for (EdmFunctionParameter functionParameter : functionImport.parameters) {
                functionParameters.add(EdmFunctionParameter.newBuilder(functionParameter, context));
            }
            return new Builder().setName(functionImport.name).setEntitySet(functionImport.entitySet != null ? EdmEntitySet.newBuilder(functionImport.entitySet, context) : null).setReturnType(functionImport.returnType).setHttpMethod(functionImport.httpMethod).addParameters(functionParameters);
        }

        public EdmFunctionImport build() {
            ArrayList<EdmFunctionParameter> parameters = new ArrayList<EdmFunctionParameter>();
            for (EdmFunctionParameter.Builder parameter : this.parameters) {
                parameters.add(parameter.build());
            }
            EdmType returnType = this.returnType != null ? this.returnType : (this.returnTypeBuilder != null ? this.returnTypeBuilder.build() : null);
            return new EdmFunctionImport(this.name, this.entitySet == null ? null : this.entitySet.build(), returnType, this.httpMethod, ImmutableList.copyOf(parameters), this.getDocumentation(), ImmutableList.copyOf(this.getAnnotations()));
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEntitySet(EdmEntitySet.Builder entitySet) {
            this.entitySet = entitySet;
            return this;
        }

        public Builder setReturnType(EdmType returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder setReturnType(EdmType.Builder<?, ?> returnType) {
            this.returnTypeBuilder = returnType;
            return this;
        }

        public Builder setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder addParameters(EdmFunctionParameter.Builder ... parameters) {
            for (EdmFunctionParameter.Builder parameter : parameters) {
                this.parameters.add(parameter);
            }
            return this;
        }

        public Builder addParameters(List<EdmFunctionParameter.Builder> parameters) {
            this.parameters.addAll(parameters);
            return this;
        }

        public String getEntitySetName() {
            return this.entitySetName;
        }

        public Builder setEntitySetName(String entitySetName) {
            this.entitySetName = entitySetName;
            return this;
        }

        public String getReturnTypeName() {
            return this.returnTypeName;
        }

        public boolean isCollection() {
            return this.isCollection;
        }

        public String getName() {
            return this.name;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public List<EdmFunctionParameter.Builder> getParameters() {
            return this.parameters;
        }

        public Builder setReturnTypeName(String returnTypeName) {
            this.returnTypeName = returnTypeName;
            return this;
        }

        public Builder setIsCollection(boolean isCollection) {
            this.isCollection = isCollection;
            return this;
        }
    }
}

