/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.edm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.core4j.Enumerable;
import org.odata4j.core.ImmutableList;
import org.odata4j.core.Named;
import org.odata4j.core.OPredicates;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmDocumentation;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmItem;
import org.odata4j.edm.EdmNonSimpleType;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmType;

public abstract class EdmStructuralType
extends EdmNonSimpleType
implements Named {
    private final String namespace;
    private final String name;
    private final List<EdmProperty> declaredProperties;
    private final Boolean isAbstract;
    private EdmEntityType baseType;

    protected EdmStructuralType(EdmEntityType baseType, String namespace, String name, List<EdmProperty.Builder> declaredProperties, EdmDocumentation doc, ImmutableList<EdmAnnotation<?>> annotations, Boolean isAbstract) {
        super(namespace + "." + name, doc, annotations);
        this.baseType = baseType;
        this.namespace = namespace;
        this.name = name;
        this.isAbstract = isAbstract;
        this.declaredProperties = new ArrayList<EdmProperty>();
        if (declaredProperties != null) {
            for (EdmProperty.Builder declaredProperty : declaredProperties) {
                this.declaredProperties.add(declaredProperty.setDeclaringType(this).build());
            }
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    public EdmEntityType getBaseType() {
        return this.baseType;
    }

    public EdmProperty findProperty(String name) {
        return this.getProperties().firstOrNull(OPredicates.edmPropertyNameEquals(name));
    }

    public Enumerable<EdmProperty> getDeclaredProperties() {
        return Enumerable.create(this.declaredProperties);
    }

    public EdmProperty findDeclaredProperty(String name) {
        return this.getDeclaredProperties().firstOrNull(OPredicates.edmPropertyNameEquals(name));
    }

    public Enumerable<EdmProperty> getProperties() {
        return this.isRootType() ? this.getDeclaredProperties() : this.baseType.getProperties().union(this.getDeclaredProperties());
    }

    public boolean isRootType() {
        return this.baseType == null;
    }

    public static abstract class Builder<T, TBuilder>
    extends EdmType.Builder<T, TBuilder> {
        protected String namespace;
        protected String name;
        protected final List<EdmProperty.Builder> properties = new ArrayList<EdmProperty.Builder>();
        protected Boolean isAbstract;
        protected EdmEntityType baseType;

        protected void fillBuilder(EdmStructuralType structuralType, EdmItem.BuilderContext context) {
            ArrayList<EdmProperty.Builder> properties = new ArrayList<EdmProperty.Builder>();
            for (EdmProperty property : structuralType.declaredProperties) {
                properties.add(EdmProperty.newBuilder(property, context));
            }
            this.namespace = structuralType.namespace;
            this.name = structuralType.name;
            this.properties.addAll(properties);
            this.isAbstract = structuralType.isAbstract;
            this.baseType = structuralType.baseType;
        }

        public TBuilder setNamespace(String namespace) {
            this.namespace = namespace;
            return (TBuilder)this;
        }

        public TBuilder setName(String name) {
            this.name = name;
            return (TBuilder)this;
        }

        public TBuilder addProperties(List<EdmProperty.Builder> properties) {
            this.properties.addAll(properties);
            return (TBuilder)this;
        }

        public TBuilder addProperties(EdmProperty.Builder ... properties) {
            return this.addProperties(Arrays.asList(properties));
        }

        public TBuilder setIsAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
            return (TBuilder)this;
        }

        public String getFullyQualifiedTypeName() {
            return this.namespace + "." + this.name;
        }

        public EdmProperty.Builder findProperty(String name) {
            return Enumerable.create(this.properties).firstOrNull(OPredicates.nameEquals(EdmProperty.Builder.class, name));
        }
    }
}

