/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format;

import javax.ws.rs.core.MediaType;
import org.odata4j.core.OCollection;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.OError;
import org.odata4j.core.OObject;
import org.odata4j.core.OSimpleObject;
import org.odata4j.exceptions.UnsupportedMediaTypeException;
import org.odata4j.format.Entry;
import org.odata4j.format.Feed;
import org.odata4j.format.FormatParser;
import org.odata4j.format.FormatType;
import org.odata4j.format.Settings;
import org.odata4j.format.SingleLink;
import org.odata4j.format.json.JsonCollectionFormatParser;
import org.odata4j.format.json.JsonComplexObjectFormatParser;
import org.odata4j.format.json.JsonEntryFormatParser;
import org.odata4j.format.json.JsonErrorFormatParser;
import org.odata4j.format.json.JsonFeedFormatParser;
import org.odata4j.format.json.JsonSimpleObjectFormatParser;
import org.odata4j.format.json.JsonSingleLinkFormatParser;
import org.odata4j.format.xml.AtomEntryFormatParser;
import org.odata4j.format.xml.AtomErrorFormatParser;
import org.odata4j.format.xml.AtomFeedFormatParser;
import org.odata4j.format.xml.AtomSimpleObjectFormatParser;
import org.odata4j.format.xml.AtomSingleLinkFormatParser;

public class FormatParserFactory {
    private FormatParserFactory() {
    }

    public static <T> FormatParser<T> getParser(Class<T> targetType, FormatType type, Settings settings) {
        FormatParsers formatParsers;
        FormatParsers formatParsers2 = formatParsers = type.equals((Object)FormatType.JSON) ? new JsonParsers() : new AtomParsers();
        if (Feed.class.isAssignableFrom(targetType)) {
            return formatParsers.getFeedFormatParser(settings);
        }
        if (Entry.class.isAssignableFrom(targetType)) {
            return formatParsers.getEntryFormatParser(settings);
        }
        if (SingleLink.class.isAssignableFrom(targetType)) {
            return formatParsers.getSingleLinkFormatParser(settings);
        }
        if (OComplexObject.class.isAssignableFrom(targetType)) {
            return formatParsers.getComplexObjectFormatParser(settings);
        }
        if (OCollection.class.isAssignableFrom(targetType)) {
            return formatParsers.getCollectionFormatParser(settings);
        }
        if (OSimpleObject.class.isAssignableFrom(targetType)) {
            return formatParsers.getSimpleObjectFormatParser(settings);
        }
        if (OError.class.isAssignableFrom(targetType)) {
            return formatParsers.getErrorFormatParser(settings);
        }
        throw new IllegalArgumentException("Unable to locate format parser for " + targetType.getName() + " and format " + (Object)((Object)type));
    }

    public static <T> FormatParser<T> getParser(Class<T> targetType, MediaType contentType, Settings settings) {
        FormatType type;
        if (contentType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            type = FormatType.JSON;
        } else if (contentType.isCompatible(MediaType.APPLICATION_ATOM_XML_TYPE) && (Feed.class.isAssignableFrom(targetType) || Entry.class.isAssignableFrom(targetType)) || contentType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            type = FormatType.ATOM;
        } else {
            throw new UnsupportedMediaTypeException("Unknown content type " + contentType);
        }
        return FormatParserFactory.getParser(targetType, type, settings);
    }

    public static class AtomParsers
    implements FormatParsers {
        @Override
        public FormatParser<Feed> getFeedFormatParser(Settings settings) {
            return new AtomFeedFormatParser(settings.metadata, settings.entitySetName, settings.entityKey, settings.fcMapping);
        }

        @Override
        public FormatParser<Entry> getEntryFormatParser(Settings settings) {
            return new AtomEntryFormatParser(settings.metadata, settings.entitySetName, settings.entityKey, settings.fcMapping);
        }

        @Override
        public FormatParser<SingleLink> getSingleLinkFormatParser(Settings settings) {
            return new AtomSingleLinkFormatParser();
        }

        @Override
        public FormatParser<OComplexObject> getComplexObjectFormatParser(Settings settings) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public FormatParser<OCollection<? extends OObject>> getCollectionFormatParser(Settings settings) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public FormatParser<OSimpleObject<?>> getSimpleObjectFormatParser(Settings settings) {
            return new AtomSimpleObjectFormatParser(settings);
        }

        @Override
        public FormatParser<OError> getErrorFormatParser(Settings settings) {
            return new AtomErrorFormatParser();
        }
    }

    public static class JsonParsers
    implements FormatParsers {
        @Override
        public FormatParser<Feed> getFeedFormatParser(Settings settings) {
            return new JsonFeedFormatParser(settings);
        }

        @Override
        public FormatParser<Entry> getEntryFormatParser(Settings settings) {
            return new JsonEntryFormatParser(settings);
        }

        @Override
        public FormatParser<SingleLink> getSingleLinkFormatParser(Settings settings) {
            return new JsonSingleLinkFormatParser(settings);
        }

        @Override
        public FormatParser<OComplexObject> getComplexObjectFormatParser(Settings settings) {
            return new JsonComplexObjectFormatParser(settings);
        }

        @Override
        public FormatParser<OCollection<? extends OObject>> getCollectionFormatParser(Settings settings) {
            return new JsonCollectionFormatParser(settings);
        }

        @Override
        public FormatParser<OSimpleObject<?>> getSimpleObjectFormatParser(Settings settings) {
            return new JsonSimpleObjectFormatParser(settings);
        }

        @Override
        public FormatParser<OError> getErrorFormatParser(Settings settings) {
            return new JsonErrorFormatParser(settings);
        }
    }

    private static interface FormatParsers {
        public FormatParser<Feed> getFeedFormatParser(Settings var1);

        public FormatParser<Entry> getEntryFormatParser(Settings var1);

        public FormatParser<SingleLink> getSingleLinkFormatParser(Settings var1);

        public FormatParser<OComplexObject> getComplexObjectFormatParser(Settings var1);

        public FormatParser<OCollection<? extends OObject>> getCollectionFormatParser(Settings var1);

        public FormatParser<OSimpleObject<?>> getSimpleObjectFormatParser(Settings var1);

        public FormatParser<OError> getErrorFormatParser(Settings var1);
    }
}

