/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.json;

import java.util.ArrayList;
import java.util.List;
import org.core4j.Enumerable;
import org.core4j.Func1;
import org.odata4j.core.OCollection;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OLink;
import org.odata4j.core.OLinks;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.format.Entry;
import org.odata4j.format.Settings;
import org.odata4j.format.json.JsonCollectionFormatParser;
import org.odata4j.format.json.JsonComplexObjectFormatParser;
import org.odata4j.format.json.JsonFeedFormatParser;
import org.odata4j.format.json.JsonStreamReaderFactory;
import org.odata4j.format.json.JsonTypeConverter;

public class JsonFormatParser {
    protected static final String METADATA_PROPERTY = "__metadata";
    protected static final String DEFERRED_PROPERTY = "__deferred";
    protected static final String NEXT_PROPERTY = "__next";
    protected static final String COUNT_PROPERTY = "__count";
    protected static final String URI_PROPERTY = "uri";
    protected static final String TYPE_PROPERTY = "type";
    protected static final String ETAG_PROPERTY = "etag";
    protected static final String RESULTS_PROPERTY = "results";
    protected static final String DATA_PROPERTY = "d";
    protected ODataVersion version;
    protected EdmDataServices metadata;
    protected String entitySetName;
    protected OEntityKey entityKey;
    protected boolean isResponse;
    protected EdmType parseType;

    protected JsonFormatParser(Settings settings) {
        this.version = settings == null ? null : settings.version;
        this.metadata = settings == null ? null : settings.metadata;
        this.entitySetName = settings == null ? null : settings.entitySetName;
        this.entityKey = settings == null ? null : settings.entityKey;
        this.isResponse = settings == null ? false : settings.isResponse;
        this.parseType = settings == null ? null : settings.parseType;
    }

    protected JsonFeedFormatParser.JsonFeed parseFeed(EdmEntitySet ees, JsonStreamReaderFactory.JsonStreamReader jsr) {
        JsonFeedFormatParser.JsonFeed feed = new JsonFeedFormatParser.JsonFeed();
        feed.entries = new ArrayList<Entry>();
        while (jsr.hasNext()) {
            JsonStreamReaderFactory.JsonStreamReader.JsonEvent event = jsr.nextEvent();
            if (event.isStartObject()) {
                JsonFeedFormatParser.JsonEntry entry = this.parseEntry(ees, jsr);
                feed.entries.add(entry);
                continue;
            }
            if (!event.isEndArray()) continue;
            break;
        }
        return feed;
    }

    protected void resolveEntityType(JsonFeedFormatParser.JsonEntry entry) {
        if (entry.jemd != null && entry.jemd.type != null && !entry.getEntitySet().getType().getFullyQualifiedTypeName().equals(entry.jemd.type)) {
            entry.setEntityType((EdmEntityType)this.metadata.findEdmEntityType(entry.jemd.type));
            if (entry.getEntityType() == null) {
                throw new IllegalArgumentException("failed resolving type: " + entry.jemd.type);
            }
        } else {
            entry.setEntityType(entry.getEntitySet().getType());
        }
    }

    protected JsonFeedFormatParser.JsonEntry parseEntry(JsonEntryMetaData jemd, EdmEntitySet ees, JsonStreamReaderFactory.JsonStreamReader jsr) {
        JsonFeedFormatParser.JsonEntry entry = new JsonFeedFormatParser.JsonEntry(ees, jemd);
        if (jemd != null) {
            this.resolveEntityType(entry);
        }
        entry.properties = new ArrayList();
        entry.links = new ArrayList<OLink>();
        while (jsr.hasNext()) {
            JsonStreamReaderFactory.JsonStreamReader.JsonEvent event = jsr.nextEvent();
            if (event.isStartProperty()) {
                this.addProperty(entry, ees, event.asStartProperty().getName(), jsr);
                continue;
            }
            if (!event.isEndObject()) continue;
            break;
        }
        entry.oentity = this.toOEntity(ees, entry.getEntityType(), entry.getEntityKey(), entry.getETag(), entry.properties, entry.links);
        return entry;
    }

    protected JsonFeedFormatParser.JsonEntry parseEntry(EdmEntitySet ees, JsonStreamReaderFactory.JsonStreamReader jsr) {
        return this.parseEntry(null, ees, jsr);
    }

    private OEntity toOEntity(EdmEntitySet entitySet, EdmEntityType entityType, OEntityKey key, String entityTag, List<OProperty<?>> properties, List<OLink> links) {
        if (key != null) {
            return OEntities.create(entitySet, entityType, key, entityTag, properties, links);
        }
        if (this.entityKey != null) {
            return OEntities.create(entitySet, entityType, this.entityKey, entityTag, properties, links);
        }
        return OEntities.createRequest(entitySet, properties, links);
    }

    protected JsonEntryMetaData parseMetadata(JsonStreamReaderFactory.JsonStreamReader jsr) {
        JsonEntryMetaData jemd = new JsonEntryMetaData();
        this.ensureStartObject(jsr.nextEvent());
        while (jsr.hasNext()) {
            JsonStreamReaderFactory.JsonStreamReader.JsonEvent event = jsr.nextEvent();
            this.ensureNext(jsr);
            if (event.isStartProperty() && URI_PROPERTY.equals(event.asStartProperty().getName())) {
                event = jsr.nextEvent();
                this.ensureEndProperty(event);
                jemd.uri = event.asEndProperty().getValue();
                continue;
            }
            if (event.isStartProperty() && TYPE_PROPERTY.equals(event.asStartProperty().getName())) {
                event = jsr.nextEvent();
                this.ensureEndProperty(event);
                jemd.type = event.asEndProperty().getValue();
                continue;
            }
            if (event.isStartProperty() && ETAG_PROPERTY.equals(event.asStartProperty().getName())) {
                event = jsr.nextEvent();
                this.ensureEndProperty(event);
                jemd.etag = event.asEndProperty().getValue();
                continue;
            }
            if (event.isStartProperty() || event.isStartObject() || event.isStartArray()) {
                jsr.skipNestedEvents();
                continue;
            }
            if (!event.isEndObject()) continue;
            break;
        }
        this.ensureEndProperty(jsr.nextEvent());
        return jemd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected EdmEntitySet addProperty(JsonFeedFormatParser.JsonEntry entry, EdmEntitySet ees, String name, JsonStreamReaderFactory.JsonStreamReader jsr) {
        JsonStreamReaderFactory.JsonStreamReader.JsonEvent event;
        if (METADATA_PROPERTY.equals(name)) {
            JsonEntryMetaData jemd;
            entry.jemd = jemd = this.parseMetadata(jsr);
            JsonStreamReaderFactory.JsonStreamReader.JsonEvent event2 = jsr.nextEvent();
            this.ensureStartProperty(event2);
            name = event2.asStartProperty().getName();
            this.resolveEntityType(entry);
        }
        if ((event = jsr.nextEvent()).isEndProperty()) {
            EdmProperty ep = entry.getEntityType().findProperty(name);
            if (ep == null) {
                EdmNavigationProperty navProp;
                if (event.asEndProperty().getValue() != null || (navProp = entry.getEntityType().findNavigationProperty(name)) == null) throw new IllegalArgumentException("unknown property " + name + " for " + entry.getEntityType().getName());
                entry.links.add(OLinks.relatedEntityInline(name, name, entry.getUri() + "/" + name, null));
                return ees;
            }
            if (!ep.getType().isSimple()) {
                if (event.asEndProperty().getValue() != null) throw new UnsupportedOperationException("complex property unknown parse state");
                entry.properties.add(OProperties.complex(name, (EdmComplexType)ep.getType(), null));
                return ees;
            } else {
                entry.properties.add(JsonTypeConverter.parse(name, (EdmSimpleType)ep.getType(), event.asEndProperty().getValue(), event.asEndProperty().getValueTokenType()));
            }
            return ees;
        } else if (event.isStartObject()) {
            JsonObjectPropertyValue val = this.getValue(event, ees, name, jsr, entry);
            if (val.uri != null) {
                EdmNavigationProperty navProp = entry.getEntityType().findNavigationProperty(name);
                if (navProp.getToRole().getMultiplicity() == EdmMultiplicity.MANY) {
                    entry.links.add(OLinks.relatedEntities(name, name, val.uri));
                    return ees;
                } else {
                    entry.links.add(OLinks.relatedEntity(name, name, val.uri));
                }
                return ees;
            } else if (val.entity != null) {
                entry.links.add(OLinks.relatedEntityInline(name, name, entry.getUri() + "/" + name, val.entity));
                return ees;
            } else if (val.entities != null) {
                entry.links.add(OLinks.relatedEntitiesInline(name, name, entry.getUri() + "/" + name, val.entities));
                return ees;
            } else if (val.collection != null) {
                entry.properties.add(OProperties.collection(name, val.collectionType, val.collection));
                return ees;
            } else {
                if (val.complexObject == null) return ees;
                entry.properties.add(OProperties.complex(name, (EdmComplexType)val.complexObject.getType(), val.complexObject.getProperties()));
            }
            return ees;
        } else {
            if (!event.isStartArray()) return ees;
            this.ensureNext(jsr);
            event = jsr.nextEvent();
            if (event.isValue()) {
                throw new IllegalArgumentException("arrays of primitive types not supported! property " + entry.getEntityType().getName() + "." + name);
            }
            if (!event.isStartObject()) throw new IllegalArgumentException("What's that?");
            EdmNavigationProperty navProp = entry.getEntityType().findNavigationProperty(name);
            ees = this.metadata.getEdmEntitySet(navProp.getToRole().getType());
            ArrayList<OEntity> entities = new ArrayList<OEntity>();
            do {
                entities.add(this.parseEntry(ees, jsr).getEntity());
            } while (!(event = jsr.nextEvent()).isEndArray());
            entry.links.add(OLinks.relatedEntitiesInline(name, name, entry.getUri() + "/" + name, entities));
            this.ensureEndProperty(jsr.nextEvent());
        }
        return ees;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JsonObjectPropertyValue getValue(JsonStreamReaderFactory.JsonStreamReader.JsonEvent event, EdmEntitySet ees, String name, JsonStreamReaderFactory.JsonStreamReader jsr, JsonFeedFormatParser.JsonEntry entry) {
        JsonObjectPropertyValue rt = new JsonObjectPropertyValue();
        this.ensureStartObject(event);
        event = jsr.nextEvent();
        this.ensureStartProperty(event);
        if (DEFERRED_PROPERTY.equals(event.asStartProperty().getName())) {
            String uri;
            this.ensureStartObject(jsr.nextEvent());
            this.ensureStartProperty(jsr.nextEvent(), URI_PROPERTY);
            rt.uri = uri = jsr.nextEvent().asEndProperty().getValue();
            this.ensureEndObject(jsr.nextEvent());
            this.ensureEndProperty(jsr.nextEvent());
            this.ensureEndObject(jsr.nextEvent());
        } else if (RESULTS_PROPERTY.equals(event.asStartProperty().getName())) {
            EdmNavigationProperty navProp = entry.getEntityType().findNavigationProperty(name);
            if (navProp != null) {
                this.ensureStartArray(jsr.nextEvent());
                JsonFeedFormatParser.JsonFeed feed = this.parseFeed(this.metadata.getEdmEntitySet(navProp.getToRole().getType()), jsr);
                rt.entities = Enumerable.create(feed.getEntries()).cast(JsonFeedFormatParser.JsonEntry.class).select(new Func1<JsonFeedFormatParser.JsonEntry, OEntity>(){

                    @Override
                    public OEntity apply(JsonFeedFormatParser.JsonEntry input) {
                        return input.getEntity();
                    }
                }).toList();
            } else {
                EdmProperty eprop = entry.getEntityType().findProperty(name);
                if (eprop == null || eprop.getCollectionKind() == EdmProperty.CollectionKind.NONE) throw new RuntimeException("unhandled property: " + name);
                rt.collectionType = new EdmCollectionType(eprop.getCollectionKind(), eprop.getType());
                JsonCollectionFormatParser cfp = new JsonCollectionFormatParser(rt.collectionType, this.metadata);
                rt.collection = cfp.parseCollection(jsr);
            }
            this.ensureEndProperty(jsr.nextEvent());
            this.ensureEndObject(jsr.nextEvent());
        } else if (METADATA_PROPERTY.equals(event.asStartProperty().getName())) {
            EdmNavigationProperty navProp = entry.getEntityType().findNavigationProperty(name);
            JsonEntryMetaData jemd = this.parseMetadata(jsr);
            JsonFeedFormatParser.JsonEntry refentry = this.parseEntry(jemd, this.metadata.getEdmEntitySet(navProp.getToRole().getType()), jsr);
            if (this.isResponse) {
                rt.entity = refentry.getEntity();
            } else {
                boolean isInlined;
                boolean bl = isInlined = !refentry.properties.isEmpty() || !refentry.links.isEmpty();
                if (isInlined) {
                    rt.entity = refentry.getEntity();
                } else {
                    rt.uri = jemd.uri;
                }
            }
        } else {
            if (!event.isStartProperty()) throw new IllegalArgumentException("What's that?");
            EdmNavigationProperty navProp = entry.getEntityType().findNavigationProperty(name);
            if (navProp != null) {
                ees = this.metadata.getEdmEntitySet(navProp.getToRole().getType());
                JsonFeedFormatParser.JsonEntry refEntry = new JsonFeedFormatParser.JsonEntry(ees, null);
                refEntry.properties = new ArrayList();
                refEntry.links = new ArrayList<OLink>();
                do {
                    this.addProperty(refEntry, ees, event.asStartProperty().getName(), jsr);
                } while (!(event = jsr.nextEvent()).isEndObject());
                rt.entity = this.toOEntity(ees, refEntry.getEntityType(), refEntry.getEntityKey(), refEntry.getETag(), refEntry.properties, refEntry.links);
            } else {
                EdmComplexType ct;
                EdmProperty prop = entry.getEntityType().findProperty(name);
                if (prop == null) {
                    throw new RuntimeException("can't find property: " + name + " on type: " + entry.getEntityType().getName());
                }
                EdmComplexType edmComplexType = ct = prop.getType() instanceof EdmComplexType ? (EdmComplexType)prop.getType() : this.metadata.findEdmComplexType(prop.getType().getFullyQualifiedTypeName());
                if (ct == null) throw new RuntimeException("unhandled property type: " + prop.getType().getFullyQualifiedTypeName());
                JsonComplexObjectFormatParser cofp = new JsonComplexObjectFormatParser(ct);
                rt.complexObject = cofp.parseSingleObject(jsr, event);
            }
        }
        this.ensureEndProperty(jsr.nextEvent());
        return rt;
    }

    protected void ensureNext(JsonStreamReaderFactory.JsonStreamReader jsr) {
        if (!jsr.hasNext()) {
            throw new IllegalArgumentException("no valid JSON format exepected at least one more event");
        }
    }

    protected void ensureStartProperty(JsonStreamReaderFactory.JsonStreamReader.JsonEvent event) {
        if (!event.isStartProperty()) {
            throw new IllegalArgumentException("no valid OData JSON format (expected StartProperty got " + event + ")");
        }
    }

    protected void ensureStartProperty(JsonStreamReaderFactory.JsonStreamReader.JsonEvent event, String name) {
        if (!event.isStartProperty() || !name.equals(event.asStartProperty().getName())) {
            throw new IllegalArgumentException("no valid OData JSON format (expected StartProperty " + name + " got " + event + ")");
        }
    }

    protected void ensureEndProperty(JsonStreamReaderFactory.JsonStreamReader.JsonEvent event) {
        if (!event.isEndProperty()) {
            throw new IllegalArgumentException("no valid OData JSON format (expected EndProperty got " + event + ")");
        }
    }

    protected void ensureStartObject(JsonStreamReaderFactory.JsonStreamReader.JsonEvent event) {
        if (!event.isStartObject()) {
            throw new IllegalArgumentException("no valid OData JSON format expected StartObject got " + event + ")");
        }
    }

    protected void ensureEndObject(JsonStreamReaderFactory.JsonStreamReader.JsonEvent event) {
        if (!event.isEndObject()) {
            throw new IllegalArgumentException("no valid OData JSON format expected EndObject got " + event + ")");
        }
    }

    protected void ensureStartArray(JsonStreamReaderFactory.JsonStreamReader.JsonEvent event) {
        if (!event.isStartArray()) {
            throw new IllegalArgumentException("no valid OData JSON format expected StartArray got " + event + ")");
        }
    }

    protected void ensureEndArray(JsonStreamReaderFactory.JsonStreamReader.JsonEvent event) {
        if (!event.isEndArray()) {
            throw new IllegalArgumentException("no valid OData JSON format expected EndArray got " + event + ")");
        }
    }

    static class JsonObjectPropertyValue {
        String uri;
        OEntity entity;
        List<OEntity> entities;
        OCollection<? extends OObject> collection;
        EdmCollectionType collectionType;
        OComplexObject complexObject;

        JsonObjectPropertyValue() {
        }
    }

    static class JsonEntryMetaData {
        String uri;
        String type;
        String etag;

        JsonEntryMetaData() {
        }
    }
}

