/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.xml;

import java.io.Writer;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.odata4j.core.OEntity;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.xml.XmlFormatWriter;
import org.odata4j.internal.InternalUtil;
import org.odata4j.producer.EntitiesResponse;
import org.odata4j.stax2.QName2;
import org.odata4j.stax2.XMLFactoryProvider2;
import org.odata4j.stax2.XMLWriter2;

public class AtomFeedFormatWriter
extends XmlFormatWriter
implements FormatWriter<EntitiesResponse> {
    @Override
    public String getContentType() {
        return "application/atom+xml;charset=utf-8";
    }

    @Override
    public void write(UriInfo uriInfo, Writer w, EntitiesResponse response) {
        String baseUri = uriInfo.getBaseUri().toString();
        EdmEntitySet ees = response.getEntitySet();
        String entitySetName = ees.getName();
        DateTime utc = new DateTime().withZone(DateTimeZone.UTC);
        String updated = InternalUtil.toString(utc);
        XMLWriter2 writer = XMLFactoryProvider2.getInstance().newXMLWriterFactory2().createXMLWriter(w);
        writer.startDocument();
        writer.startElement(new QName2("feed"), "http://www.w3.org/2005/Atom");
        writer.writeNamespace("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
        writer.writeNamespace("d", "http://schemas.microsoft.com/ado/2007/08/dataservices");
        writer.writeAttribute("xml:base", baseUri);
        this.writeElement(writer, "title", entitySetName, "type", "text");
        this.writeElement(writer, "id", baseUri + uriInfo.getPath(), new String[0]);
        this.writeElement(writer, "updated", updated, new String[0]);
        this.writeElement(writer, "link", null, "rel", "self", "title", entitySetName, "href", entitySetName);
        Integer inlineCount = response.getInlineCount();
        if (inlineCount != null) {
            this.writeElement(writer, "m:count", inlineCount.toString(), new String[0]);
        }
        for (OEntity entity : response.getEntities()) {
            writer.startElement("entry");
            this.writeEntry(writer, entity, entity.getProperties(), entity.getLinks(), baseUri, updated, ees, true);
            writer.endElement("entry");
        }
        if (response.getSkipToken() != null) {
            String nextHref = uriInfo.getRequestUriBuilder().replaceQueryParam("$skiptoken", response.getSkipToken()).build(new Object[0]).toString();
            this.writeElement(writer, "link", null, "rel", "next", "href", nextHref);
        }
        writer.endDocument();
    }
}

