/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.format.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.core4j.Enumerable;
import org.core4j.Func1;
import org.core4j.Predicate1;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OPredicates;
import org.odata4j.core.PrefixedNamespace;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmAssociationSet;
import org.odata4j.edm.EdmAssociationSetEnd;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmFunctionParameter;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmType;
import org.odata4j.format.xml.XmlFormatParser;
import org.odata4j.internal.AndroidCompat;
import org.odata4j.stax2.Attribute2;
import org.odata4j.stax2.Namespace2;
import org.odata4j.stax2.QName2;
import org.odata4j.stax2.StartElement2;
import org.odata4j.stax2.XMLEvent2;
import org.odata4j.stax2.XMLEventReader2;

public class EdmxFormatParser
extends XmlFormatParser {
    private final EdmDataServices.Builder dataServices = EdmDataServices.newBuilder();

    public EdmDataServices parseMetadata(XMLEventReader2 reader) {
        ArrayList<EdmSchema.Builder> schemas = new ArrayList<EdmSchema.Builder>();
        List<PrefixedNamespace> namespaces = null;
        ODataVersion version = null;
        boolean foundDataServices = false;
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            boolean shouldReturn = false;
            if (EdmxFormatParser.isStartElement(event, XmlFormatParser.EDMX_EDMX)) {
                namespaces = this.getExtensionNamespaces(event.asStartElement());
            }
            if (EdmxFormatParser.isStartElement(event, EDMX_DATASERVICES)) {
                foundDataServices = true;
                String str = EdmxFormatParser.getAttributeValueIfExists(event.asStartElement(), new QName2("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "DataServiceVersion"));
                ODataVersion oDataVersion = version = str != null ? ODataVersion.parse(str) : null;
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_SCHEMA, EDM2007_SCHEMA, EDM2008_1_SCHEMA, EDM2008_9_SCHEMA, EDM2009_SCHEMA)) {
                schemas.add(this.parseEdmSchema(reader, event.asStartElement()));
                if (!foundDataServices) {
                    shouldReturn = true;
                }
            }
            if (EdmxFormatParser.isEndElement(event, EDMX_DATASERVICES)) {
                shouldReturn = true;
            }
            if (!shouldReturn) continue;
            this.dataServices.setVersion(version).addSchemas(schemas).addNamespaces(namespaces);
            this.resolve();
            return this.dataServices.build();
        }
        throw new UnsupportedOperationException();
    }

    private void resolve() {
        Map<String, EdmEntityType.Builder> allEetsByFQName = Enumerable.create(this.dataServices.getEntityTypes()).toMap(EdmEntityType.Builder.func1_getFullyQualifiedTypeName());
        Map<String, EdmEntityType.Builder> allEetsByFQAliasName = Enumerable.create(this.dataServices.getEntityTypes()).where(EdmEntityType.Builder.pred1_hasAlias()).toMap(EdmEntityType.Builder.func1_getFQAliasName());
        Map<String, EdmAssociation.Builder> allEasByFQName = Enumerable.create(this.dataServices.getAssociations()).toMap(EdmAssociation.Builder.func1_getFQNamespaceName());
        for (EdmSchema.Builder edmSchema : this.dataServices.getSchemas()) {
            for (int i = 0; i < edmSchema.getAssociations().size(); ++i) {
                EdmAssociation.Builder builder = edmSchema.getAssociations().get(i);
                builder.getEnd1().setType(allEetsByFQName.get(builder.getEnd1().getTypeName()));
                builder.getEnd2().setType(allEetsByFQName.get(builder.getEnd2().getTypeName()));
            }
            for (EdmEntityType.Builder builder : edmSchema.getEntityTypes()) {
                List<EdmNavigationProperty.Builder> navProps = builder.getNavigationProperties();
                for (int i = 0; i < navProps.size(); ++i) {
                    EdmNavigationProperty.Builder tmp = navProps.get(i);
                    final EdmAssociation.Builder ea = allEasByFQName.get(tmp.getRelationshipName());
                    if (ea == null) {
                        throw new IllegalArgumentException("Invalid relationship name " + tmp.getRelationshipName());
                    }
                    List<EdmAssociationEnd.Builder> finalEnds = Enumerable.create(tmp.getFromRoleName(), tmp.getToRoleName()).select(new Func1<String, EdmAssociationEnd.Builder>(){

                        @Override
                        public EdmAssociationEnd.Builder apply(String input) {
                            if (ea.getEnd1().getRole().equals(input)) {
                                return ea.getEnd1();
                            }
                            if (ea.getEnd2().getRole().equals(input)) {
                                return ea.getEnd2();
                            }
                            throw new IllegalArgumentException("Invalid role name " + input);
                        }
                    }).toList();
                    tmp.setRelationship(ea).setFromTo(finalEnds.get(0), finalEnds.get(1));
                }
            }
            for (EdmEntityContainer.Builder builder : edmSchema.getEntityContainers()) {
                for (int i = 0; i < builder.getEntitySets().size(); ++i) {
                    EdmEntitySet.Builder tmpEes = builder.getEntitySets().get(i);
                    EdmEntityType.Builder eet = allEetsByFQName.get(tmpEes.getEntityTypeName());
                    if (eet == null) {
                        eet = allEetsByFQAliasName.get(tmpEes.getEntityTypeName());
                    }
                    if (eet == null) {
                        throw new IllegalArgumentException("Invalid entity type " + tmpEes.getEntityTypeName());
                    }
                    builder.getEntitySets().set(i, EdmEntitySet.newBuilder().setName(tmpEes.getName()).setEntityType(eet));
                }
            }
            for (final EdmEntityContainer.Builder builder : edmSchema.getEntityContainers()) {
                for (int i = 0; i < builder.getAssociationSets().size(); ++i) {
                    EdmAssociationSet.Builder tmpEas = builder.getAssociationSets().get(i);
                    final EdmAssociation.Builder ea = allEasByFQName.get(tmpEas.getAssociationName());
                    List<EdmAssociationSetEnd.Builder> finalEnds = Enumerable.create(tmpEas.getEnd1(), tmpEas.getEnd2()).select(new Func1<EdmAssociationSetEnd.Builder, EdmAssociationSetEnd.Builder>(){

                        @Override
                        public EdmAssociationSetEnd.Builder apply(EdmAssociationSetEnd.Builder input) {
                            EdmAssociationEnd.Builder eae;
                            EdmAssociationEnd.Builder builder2 = ea.getEnd1().getRole().equals(input.getRoleName()) ? ea.getEnd1() : (eae = ea.getEnd2().getRole().equals(input.getRoleName()) ? ea.getEnd2() : null);
                            if (eae == null) {
                                throw new IllegalArgumentException("Invalid role name " + input.getRoleName());
                            }
                            EdmEntitySet.Builder ees = Enumerable.create(builder.getEntitySets()).first(OPredicates.nameEquals(EdmEntitySet.Builder.class, input.getEntitySetName()));
                            return EdmAssociationSetEnd.newBuilder().setRole(eae).setEntitySet(ees);
                        }
                    }).toList();
                    tmpEas.setAssociation(ea).setEnds(finalEnds.get(0), finalEnds.get(1));
                }
            }
            for (EdmEntityContainer.Builder builder : edmSchema.getEntityContainers()) {
                for (int i = 0; i < builder.getFunctionImports().size(); ++i) {
                    final EdmFunctionImport.Builder tmpEfi = builder.getFunctionImports().get(i);
                    EdmEntitySet.Builder ees = Enumerable.create(builder.getEntitySets()).firstOrNull(new Predicate1<EdmEntitySet.Builder>(){

                        @Override
                        public boolean apply(EdmEntitySet.Builder input) {
                            return input.getName().equals(tmpEfi.getEntitySetName());
                        }
                    });
                    EdmCollectionType.Builder typeBuilder = null;
                    if (tmpEfi.getReturnTypeName() != null) {
                        typeBuilder = this.dataServices.resolveType(tmpEfi.getReturnTypeName());
                        if (typeBuilder == null) {
                            throw new RuntimeException("Edm-type not found: " + tmpEfi.getReturnTypeName());
                        }
                        if (tmpEfi.isCollection()) {
                            typeBuilder = EdmCollectionType.newBuilder().setKind(EdmProperty.CollectionKind.Collection).setCollectionType(typeBuilder);
                        }
                    }
                    builder.getFunctionImports().set(i, EdmFunctionImport.newBuilder().setName(tmpEfi.getName()).setEntitySet(ees).setReturnType(typeBuilder).setHttpMethod(tmpEfi.getHttpMethod()).addParameters(tmpEfi.getParameters()));
                }
            }
            for (Map.Entry entry : allEetsByFQName.entrySet()) {
                String baseTypeName = ((EdmEntityType.Builder)entry.getValue()).getFQBaseTypeName();
                if (baseTypeName == null) continue;
                EdmEntityType.Builder baseType = allEetsByFQName.get(baseTypeName);
                if (baseType == null) {
                    throw new IllegalArgumentException("Invalid baseType: " + baseTypeName);
                }
                ((EdmEntityType.Builder)entry.getValue()).setBaseType(baseType);
            }
        }
    }

    private EdmSchema.Builder parseEdmSchema(XMLEventReader2 reader, StartElement2 schemaElement) {
        String schemaNamespace = schemaElement.getAttributeByName(new QName2("Namespace")).getValue();
        String schemaAlias = EdmxFormatParser.getAttributeValueIfExists(schemaElement, new QName2("Alias"));
        ArrayList<EdmEntityType.Builder> edmEntityTypes = new ArrayList<EdmEntityType.Builder>();
        ArrayList<EdmComplexType.Builder> edmComplexTypes = new ArrayList<EdmComplexType.Builder>();
        ArrayList<EdmAssociation.Builder> edmAssociations = new ArrayList<EdmAssociation.Builder>();
        ArrayList<EdmEntityContainer.Builder> edmEntityContainers = new ArrayList<EdmEntityContainer.Builder>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_ENTITYTYPE, EDM2007_ENTITYTYPE, EDM2008_1_ENTITYTYPE, EDM2008_9_ENTITYTYPE, EDM2009_ENTITYTYPE)) {
                EdmEntityType.Builder edmEntityType = this.parseEdmEntityType(reader, schemaNamespace, schemaAlias, event.asStartElement());
                edmEntityTypes.add(edmEntityType);
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_ASSOCIATION, EDM2007_ASSOCIATION, EDM2008_1_ASSOCIATION, EDM2008_9_ASSOCIATION, EDM2009_ASSOCIATION)) {
                EdmAssociation.Builder edmAssociation = this.parseEdmAssociation(reader, schemaNamespace, schemaAlias, event.asStartElement());
                edmAssociations.add(edmAssociation);
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_COMPLEXTYPE, EDM2007_COMPLEXTYPE, EDM2008_1_COMPLEXTYPE, EDM2008_9_COMPLEXTYPE, EDM2009_COMPLEXTYPE)) {
                EdmComplexType.Builder edmComplexType = this.parseEdmComplexType(reader, schemaNamespace, event.asStartElement());
                edmComplexTypes.add(edmComplexType);
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_ENTITYCONTAINER, EDM2007_ENTITYCONTAINER, EDM2008_1_ENTITYCONTAINER, EDM2008_9_ENTITYCONTAINER, EDM2009_ENTITYCONTAINER)) {
                EdmEntityContainer.Builder edmEntityContainer = this.parseEdmEntityContainer(reader, schemaNamespace, event.asStartElement());
                edmEntityContainers.add(edmEntityContainer);
            }
            if (!EdmxFormatParser.isEndElement(event, schemaElement.getName())) continue;
            return (EdmSchema.Builder)EdmSchema.newBuilder().setNamespace(schemaNamespace).setAlias(schemaAlias).addEntityTypes(edmEntityTypes).addComplexTypes(edmComplexTypes).addAssociations(edmAssociations).addEntityContainers(edmEntityContainers).setAnnotations(this.getAnnotations(schemaElement));
        }
        throw new UnsupportedOperationException();
    }

    private EdmEntityContainer.Builder parseEdmEntityContainer(XMLEventReader2 reader, String schemaNamespace, StartElement2 entityContainerElement) {
        String name = entityContainerElement.getAttributeByName("Name").getValue();
        boolean isDefault = "true".equals(EdmxFormatParser.getAttributeValueIfExists(entityContainerElement, new QName2("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "IsDefaultEntityContainer")));
        String lazyLoadingEnabledValue = EdmxFormatParser.getAttributeValueIfExists(entityContainerElement, new QName2("http://schemas.microsoft.com/ado/2009/02/edm/annotation", "LazyLoadingEnabled"));
        Boolean lazyLoadingEnabled = lazyLoadingEnabledValue == null ? null : Boolean.valueOf(lazyLoadingEnabledValue.equals("true"));
        ArrayList<EdmEntitySet.Builder> edmEntitySets = new ArrayList<EdmEntitySet.Builder>();
        ArrayList<EdmAssociationSet.Builder> edmAssociationSets = new ArrayList<EdmAssociationSet.Builder>();
        ArrayList<EdmFunctionImport.Builder> edmFunctionImports = new ArrayList<EdmFunctionImport.Builder>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_ENTITYSET, EDM2007_ENTITYSET, EDM2008_1_ENTITYSET, EDM2008_9_ENTITYSET, EDM2009_ENTITYSET)) {
                StartElement2 entitySetStartElement = event.asStartElement();
                edmEntitySets.add((EdmEntitySet.Builder)EdmEntitySet.newBuilder().setName(EdmxFormatParser.getAttributeValueIfExists(entitySetStartElement, "Name")).setEntityTypeName(EdmxFormatParser.getAttributeValueIfExists(entitySetStartElement, "EntityType")).setAnnotations(this.getAnnotations(entitySetStartElement)));
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_ASSOCIATIONSET, EDM2007_ASSOCIATIONSET, EDM2008_1_ASSOCIATIONSET, EDM2008_9_ASSOCIATIONSET, EDM2009_ASSOCIATIONSET)) {
                edmAssociationSets.add(this.parseEdmAssociationSet(reader, schemaNamespace, event.asStartElement()));
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_FUNCTIONIMPORT, EDM2007_FUNCTIONIMPORT, EDM2008_1_FUNCTIONIMPORT, EDM2008_9_FUNCTIONIMPORT, EDM2009_FUNCTIONIMPORT)) {
                edmFunctionImports.add(this.parseEdmFunctionImport(reader, schemaNamespace, event.asStartElement()));
            }
            if (!EdmxFormatParser.isEndElement(event, entityContainerElement.getName())) continue;
            return (EdmEntityContainer.Builder)EdmEntityContainer.newBuilder().setName(name).setIsDefault(isDefault).setLazyLoadingEnabled(lazyLoadingEnabled).addEntitySets(edmEntitySets).addAssociationSets(edmAssociationSets).addFunctionImports(edmFunctionImports).setAnnotations(this.getAnnotations(entityContainerElement));
        }
        throw new UnsupportedOperationException();
    }

    private EdmFunctionImport.Builder parseEdmFunctionImport(XMLEventReader2 reader, String schemaNamespace, StartElement2 functionImportElement) {
        boolean isCollection;
        String name = functionImportElement.getAttributeByName("Name").getValue();
        String entitySet = EdmxFormatParser.getAttributeValueIfExists(functionImportElement, "EntitySet");
        Attribute2 returnTypeAttr = functionImportElement.getAttributeByName("ReturnType");
        String returnType = returnTypeAttr != null ? returnTypeAttr.getValue() : null;
        boolean bl = isCollection = returnType != null && returnType.matches("^Collection\\(.*\\)$");
        if (isCollection) {
            returnType = returnType.substring(11, returnType.length() - 1);
        }
        String httpMethod = EdmxFormatParser.getAttributeValueIfExists(functionImportElement, new QName2("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HttpMethod"));
        ArrayList<EdmFunctionParameter.Builder> parameters = new ArrayList<EdmFunctionParameter.Builder>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_PARAMETER, EDM2007_PARAMETER, EDM2008_1_PARAMETER, EDM2008_9_PARAMETER, EDM2009_PARAMETER)) {
                StartElement2 paramStartElement = event.asStartElement();
                Attribute2 modeAttribute = paramStartElement.getAttributeByName("Mode");
                parameters.add((EdmFunctionParameter.Builder)EdmFunctionParameter.newBuilder().setName(paramStartElement.getAttributeByName("Name").getValue()).setType(EdmType.newDeferredBuilder(paramStartElement.getAttributeByName("Type").getValue(), this.dataServices)).setMode(modeAttribute != null ? EdmFunctionParameter.Mode.valueOf(modeAttribute.getValue()) : null).setAnnotations(this.getAnnotations(paramStartElement)));
            }
            if (!EdmxFormatParser.isEndElement(event, functionImportElement.getName())) continue;
            return (EdmFunctionImport.Builder)EdmFunctionImport.newBuilder().setName(name).setEntitySetName(entitySet).setReturnTypeName(returnType).setIsCollection(isCollection).setHttpMethod(httpMethod).addParameters(parameters).setAnnotations(this.getAnnotations(functionImportElement));
        }
        throw new UnsupportedOperationException();
    }

    private EdmAssociationSet.Builder parseEdmAssociationSet(XMLEventReader2 reader, String schemaNamespace, StartElement2 associationSetElement) {
        String name = associationSetElement.getAttributeByName("Name").getValue();
        String associationName = associationSetElement.getAttributeByName("Association").getValue();
        ArrayList ends = new ArrayList();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_END, EDM2007_END, EDM2008_1_END, EDM2008_9_END, EDM2009_END)) {
                StartElement2 endStartElement = event.asStartElement();
                ends.add(EdmAssociationSetEnd.newBuilder().setRoleName(endStartElement.getAttributeByName("Role").getValue()).setEntitySetName(endStartElement.getAttributeByName("EntitySet").getValue()).setAnnotations(this.getAnnotations(endStartElement)));
            }
            if (!EdmxFormatParser.isEndElement(event, associationSetElement.getName())) continue;
            return (EdmAssociationSet.Builder)EdmAssociationSet.newBuilder().setName(name).setAssociationName(associationName).setEnds((EdmAssociationSetEnd.Builder)ends.get(0), (EdmAssociationSetEnd.Builder)ends.get(1)).setAnnotations(this.getAnnotations(associationSetElement));
        }
        throw new UnsupportedOperationException();
    }

    private EdmAssociation.Builder parseEdmAssociation(XMLEventReader2 reader, String schemaNamespace, String schemaAlias, StartElement2 associationElement) {
        String name = associationElement.getAttributeByName("Name").getValue();
        ArrayList ends = new ArrayList();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_END, EDM2007_END, EDM2008_1_END, EDM2008_9_END, EDM2009_END)) {
                StartElement2 endStartElement = event.asStartElement();
                ends.add(EdmAssociationEnd.newBuilder().setRole(endStartElement.getAttributeByName("Role").getValue()).setTypeName(endStartElement.getAttributeByName("Type").getValue()).setMultiplicity(EdmMultiplicity.fromSymbolString(endStartElement.getAttributeByName("Multiplicity").getValue())).setAnnotations(this.getAnnotations(endStartElement)));
            }
            if (!EdmxFormatParser.isEndElement(event, associationElement.getName())) continue;
            return (EdmAssociation.Builder)EdmAssociation.newBuilder().setNamespace(schemaNamespace).setAlias(schemaAlias).setName(name).setEnds((EdmAssociationEnd.Builder)ends.get(0), (EdmAssociationEnd.Builder)ends.get(1)).setAnnotations(this.getAnnotations(associationElement));
        }
        throw new UnsupportedOperationException();
    }

    private EdmProperty.Builder parseEdmProperty(XMLEvent2 event) {
        StartElement2 startElement = event.asStartElement();
        String propertyName = EdmxFormatParser.getAttributeValueIfExists(startElement, "Name");
        String propertyType = EdmxFormatParser.getAttributeValueIfExists(startElement, "Type");
        String propertyNullable = EdmxFormatParser.getAttributeValueIfExists(startElement, "Nullable");
        String maxLength = EdmxFormatParser.getAttributeValueIfExists(startElement, "MaxLength");
        String unicode = EdmxFormatParser.getAttributeValueIfExists(startElement, "Unicode");
        String fixedLength = EdmxFormatParser.getAttributeValueIfExists(startElement, "FixedLength");
        String collectionKindS = EdmxFormatParser.getAttributeValueIfExists(startElement, "CollectionKind");
        EdmProperty.CollectionKind ckind = EdmProperty.CollectionKind.NONE;
        if (collectionKindS != null) {
            ckind = Enum.valueOf(EdmProperty.CollectionKind.class, collectionKindS);
        }
        String defaultValue = EdmxFormatParser.getAttributeValueIfExists(startElement, "DefaultValue");
        String precision = EdmxFormatParser.getAttributeValueIfExists(startElement, "Precision");
        String scale = EdmxFormatParser.getAttributeValueIfExists(startElement, "Scale");
        String storeGeneratedPattern = EdmxFormatParser.getAttributeValueIfExists(startElement, new QName2("http://schemas.microsoft.com/ado/2009/02/edm/annotation", "StoreGeneratedPattern"));
        String concurrencyMode = EdmxFormatParser.getAttributeValueIfExists(startElement, "ConcurrencyMode");
        String fcTargetPath = EdmxFormatParser.getAttributeValueIfExists(startElement, M_FC_TARGETPATH);
        String fcContentKind = EdmxFormatParser.getAttributeValueIfExists(startElement, M_FC_CONTENTKIND);
        String fcKeepInContent = EdmxFormatParser.getAttributeValueIfExists(startElement, M_FC_KEEPINCONTENT);
        String fcEpmContentKind = EdmxFormatParser.getAttributeValueIfExists(startElement, M_FC_EPMCONTENTKIND);
        String fcEpmKeepInContent = EdmxFormatParser.getAttributeValueIfExists(startElement, M_FC_EPMKEEPINCONTENT);
        return (EdmProperty.Builder)EdmProperty.newBuilder(propertyName).setType(EdmType.newDeferredBuilder(propertyType, this.dataServices)).setNullable("true".equalsIgnoreCase(propertyNullable)).setMaxLength(maxLength == null ? null : Integer.valueOf(maxLength.equals("Max") ? Integer.MAX_VALUE : Integer.parseInt(maxLength))).setUnicode("true".equalsIgnoreCase(unicode)).setFixedLength("true".equalsIgnoreCase(fixedLength)).setStoreGeneratedPattern(storeGeneratedPattern).setConcurrencyMode(concurrencyMode).setFcTargetPath(fcTargetPath).setFcContentKind(fcContentKind).setFcKeepInContent(fcKeepInContent).setFcEpmContentKind(fcEpmContentKind).setFcEpmKeepInContent(fcEpmKeepInContent).setCollectionKind(ckind).setDefaultValue(defaultValue).setPrecision(precision == null ? null : Integer.valueOf(Integer.parseInt(precision))).setScale(scale == null ? null : Integer.valueOf(Integer.parseInt(scale))).setAnnotations(this.getAnnotations(startElement));
    }

    private EdmComplexType.Builder parseEdmComplexType(XMLEventReader2 reader, String schemaNamespace, StartElement2 complexTypeElement) {
        String name = complexTypeElement.getAttributeByName("Name").getValue();
        String isAbstractS = EdmxFormatParser.getAttributeValueIfExists(complexTypeElement, "Abstract");
        ArrayList<EdmProperty.Builder> edmProperties = new ArrayList<EdmProperty.Builder>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_PROPERTY, EDM2007_PROPERTY, EDM2008_1_PROPERTY, EDM2008_9_PROPERTY, EDM2009_PROPERTY)) {
                edmProperties.add(this.parseEdmProperty(event));
            }
            if (!EdmxFormatParser.isEndElement(event, complexTypeElement.getName())) continue;
            EdmComplexType.Builder complexType = (EdmComplexType.Builder)((EdmComplexType.Builder)((EdmComplexType.Builder)((EdmComplexType.Builder)EdmComplexType.newBuilder().setNamespace(schemaNamespace)).setName(name)).addProperties(edmProperties)).setAnnotations(this.getAnnotations(complexTypeElement));
            if (isAbstractS != null) {
                complexType.setIsAbstract("true".equals(isAbstractS));
            }
            return complexType;
        }
        throw new UnsupportedOperationException();
    }

    private EdmEntityType.Builder parseEdmEntityType(XMLEventReader2 reader, String schemaNamespace, String schemaAlias, StartElement2 entityTypeElement) {
        String name = entityTypeElement.getAttributeByName("Name").getValue();
        String hasStreamValue = EdmxFormatParser.getAttributeValueIfExists(entityTypeElement, new QName2("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HasStream"));
        Boolean hasStream = hasStreamValue == null ? null : Boolean.valueOf(hasStreamValue.equals("true"));
        String baseType = EdmxFormatParser.getAttributeValueIfExists(entityTypeElement, "BaseType");
        String isAbstractS = EdmxFormatParser.getAttributeValueIfExists(entityTypeElement, "Abstract");
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<EdmProperty.Builder> edmProperties = new ArrayList<EdmProperty.Builder>();
        ArrayList<EdmNavigationProperty.Builder> edmNavigationProperties = new ArrayList<EdmNavigationProperty.Builder>();
        while (reader.hasNext()) {
            XMLEvent2 event = reader.nextEvent();
            if (EdmxFormatParser.isStartElement(event, EDM2006_PROPERTYREF, EDM2007_PROPERTYREF, EDM2008_1_PROPERTYREF, EDM2008_9_PROPERTYREF, EDM2009_PROPERTYREF)) {
                keys.add(event.asStartElement().getAttributeByName("Name").getValue());
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_PROPERTY, EDM2007_PROPERTY, EDM2008_1_PROPERTY, EDM2008_9_PROPERTY, EDM2009_PROPERTY)) {
                edmProperties.add(this.parseEdmProperty(event));
            }
            if (EdmxFormatParser.isStartElement(event, EDM2006_NAVIGATIONPROPERTY, EDM2007_NAVIGATIONPROPERTY, EDM2008_1_NAVIGATIONPROPERTY, EDM2008_9_NAVIGATIONPROPERTY, EDM2009_NAVIGATIONPROPERTY)) {
                StartElement2 navPropStartElement = event.asStartElement();
                String associationName = navPropStartElement.getAttributeByName("Name").getValue();
                String relationshipName = navPropStartElement.getAttributeByName("Relationship").getValue();
                String fromRoleName = navPropStartElement.getAttributeByName("FromRole").getValue();
                String toRoleName = navPropStartElement.getAttributeByName("ToRole").getValue();
                edmNavigationProperties.add((EdmNavigationProperty.Builder)EdmNavigationProperty.newBuilder(associationName).setRelationshipName(relationshipName).setFromToName(fromRoleName, toRoleName).setAnnotations(this.getAnnotations(navPropStartElement)));
            }
            if (!EdmxFormatParser.isEndElement(event, entityTypeElement.getName())) continue;
            return (EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setNamespace(schemaNamespace)).setAlias(schemaAlias).setName(name)).setHasStream(hasStream).addKeys(keys).addProperties(edmProperties)).addNavigationProperties(edmNavigationProperties).setBaseType(baseType).setIsAbstract(isAbstractS == null ? null : Boolean.valueOf("true".equals(isAbstractS)))).setAnnotations(this.getAnnotations(entityTypeElement));
        }
        throw new UnsupportedOperationException();
    }

    protected boolean isExtensionNamespace(String namespaceUri) {
        return namespaceUri != null && !AndroidCompat.String_isEmpty(namespaceUri.trim()) && !namespaceUri.contains("schemas.microsoft.com");
    }

    protected List<EdmAnnotation<?>> getAnnotations(StartElement2 element) {
        try {
            Enumerable<Attribute2> atts = element.getAttributes();
            ArrayList annots = new ArrayList();
            for (Attribute2 att : atts) {
                QName2 q = att.getName();
                if (!this.isExtensionNamespace(q.getNamespaceUri())) continue;
                annots.add(EdmAnnotation.attribute(q.getNamespaceUri(), q.getPrefix(), q.getLocalPart(), att.getValue()));
            }
            return annots;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected List<PrefixedNamespace> getExtensionNamespaces(StartElement2 startElement) {
        try {
            Enumerable<Namespace2> nse = startElement.getNamespaces();
            ArrayList<PrefixedNamespace> nsl = new ArrayList<PrefixedNamespace>();
            for (Namespace2 ns : nse) {
                if (!this.isExtensionNamespace(ns.getNamespaceURI())) continue;
                nsl.add(new PrefixedNamespace(ns.getNamespaceURI(), ns.getPrefix()));
            }
            return nsl;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

