/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodInvocationInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfoStack;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.invoker.AbstractInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSInvoker
extends AbstractInvoker {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSInvoker.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInvoker.class);
    private static final String SERVICE_LOADER_AS_CONTEXT = "org.apache.cxf.serviceloader-context";
    private static final String SERVICE_OBJECT_SCOPE = "org.apache.cxf.service.scope";
    private static final String REQUEST_SCOPE = "request";
    private static final String LAST_SERVICE_OBJECT = "org.apache.cxf.service.object.last";
    private static final String REQUEST_WAS_SUSPENDED = "org.apache.cxf.service.request.suspended";
    private static final String PROXY_INVOCATION_ERROR_FRAGMENT = "object is not an instance of declaring class";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Exchange exchange, Object request) {
        boolean suspended2;
        Object object;
        Response response = (Response)exchange.get(Response.class);
        if (response != null) {
            return new MessageContentsList(new Object[]{response});
        }
        ResourceProvider provider = this.getResourceProvider(exchange);
        Object rootInstance = this.getServiceObject(exchange);
        Object serviceObject = this.getActualServiceObject(exchange, rootInstance);
        try {
            object = this.invoke(exchange, request, serviceObject);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            boolean suspended2;
            Object var9_9 = null;
            boolean bl = suspended2 = exchange.getInMessage().getInterceptorChain().getState() == InterceptorChain.State.SUSPENDED;
            if (!suspended2) {
                if (exchange.isOneWay()) {
                    ProviderFactory.getInstance(exchange.getInMessage()).clearThreadLocalProxies();
                }
                if (!this.isServiceObjectRequestScope(exchange.getInMessage())) {
                    provider.releaseInstance(exchange.getInMessage(), rootInstance);
                } else {
                    this.persistRoots(exchange, rootInstance, provider);
                }
            } else {
                this.persistRoots(exchange, rootInstance, provider);
                exchange.put((Object)REQUEST_WAS_SUSPENDED, (Object)true);
            }
            throw throwable;
        }
        boolean bl = suspended2 = exchange.getInMessage().getInterceptorChain().getState() == InterceptorChain.State.SUSPENDED;
        if (!suspended2) {
            if (exchange.isOneWay()) {
                ProviderFactory.getInstance(exchange.getInMessage()).clearThreadLocalProxies();
            }
            if (!this.isServiceObjectRequestScope(exchange.getInMessage())) {
                provider.releaseInstance(exchange.getInMessage(), rootInstance);
            } else {
                this.persistRoots(exchange, rootInstance, provider);
            }
        } else {
            this.persistRoots(exchange, rootInstance, provider);
            exchange.put((Object)REQUEST_WAS_SUSPENDED, (Object)true);
        }
        return object;
    }

    private void persistRoots(Exchange exchange, Object rootInstance, Object provider) {
        exchange.put((Object)"service.root.instance", rootInstance);
        exchange.put((Object)"service.root.provider", provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Exchange exchange, Object request, Object resourceObject) {
        boolean wasSuspended;
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        boolean bl = wasSuspended = exchange.remove((Object)REQUEST_WAS_SUSPENDED) != null;
        if (!wasSuspended) {
            this.pushOntoStack(ori, ClassHelper.getRealClass((Object)resourceObject), exchange.getInMessage());
            if (cri.isRoot()) {
                Object realResourceObject = ClassHelper.getRealObject((Object)resourceObject);
                JAXRSUtils.injectParameters(ori, realResourceObject, exchange.getInMessage());
                InjectionUtils.injectContexts(realResourceObject, ori.getClassResourceInfo(), exchange.getInMessage());
                ProviderInfo appProvider = (ProviderInfo)exchange.getEndpoint().get((Object)Application.class.getName());
                if (appProvider != null) {
                    InjectionUtils.injectContexts(appProvider.getProvider(), appProvider, exchange.getInMessage());
                }
            }
        }
        Method methodToInvoke = InjectionUtils.checkProxy(cri.getMethodDispatcher().getMethod(ori), resourceObject);
        List params = null;
        if (request instanceof List) {
            params = CastUtils.cast((List)((List)request));
        } else if (request != null) {
            params = new MessageContentsList(new Object[]{request});
        }
        Object result = null;
        ClassLoaderUtils.ClassLoaderHolder contextLoader = null;
        try {
            try {
                if (this.setServiceLoaderAsContextLoader(exchange.getInMessage())) {
                    contextLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)resourceObject.getClass().getClassLoader());
                }
                result = this.invoke(exchange, resourceObject, methodToInvoke, params);
            }
            catch (Fault ex) {
                Response excResponse;
                String errorMessage = ex.getCause().getMessage();
                if (errorMessage != null && errorMessage.contains(PROXY_INVOCATION_ERROR_FRAGMENT)) {
                    org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("PROXY_INVOCATION_FAILURE", BUNDLE, new Object[]{methodToInvoke, cri.getServiceClass().getName()});
                    LOG.severe(errorM.toString());
                }
                if ((excResponse = JAXRSUtils.convertFaultToResponse(ex.getCause(), exchange.getInMessage())) == null) {
                    ProviderFactory.getInstance(exchange.getInMessage()).clearThreadLocalProxies();
                    ClassResourceInfo criRoot = (ClassResourceInfo)exchange.get((Object)"root.resource.class");
                    if (criRoot != null) {
                        criRoot.clearThreadLocalProxies();
                    }
                    exchange.put((Object)Message.PROPOGATE_EXCEPTION, (Object)JAXRSUtils.propogateException(exchange.getInMessage()));
                    throw ex;
                }
                MessageContentsList criRoot = new MessageContentsList(new Object[]{excResponse});
                Object var16_12 = null;
                exchange.put((Object)LAST_SERVICE_OBJECT, resourceObject);
                if (contextLoader != null) {
                    contextLoader.reset();
                }
                return criRoot;
            }
            Object var16_11 = null;
        }
        catch (Throwable throwable) {
            Object var16_13 = null;
            exchange.put((Object)LAST_SERVICE_OBJECT, resourceObject);
            if (contextLoader != null) {
                contextLoader.reset();
            }
            throw throwable;
        }
        exchange.put((Object)LAST_SERVICE_OBJECT, resourceObject);
        if (contextLoader != null) {
            contextLoader.reset();
        }
        ClassResourceInfo subCri = null;
        if (!ori.isSubResourceLocator()) {
            return result;
        }
        try {
            Message msg = exchange.getInMessage();
            MultivaluedMap<String, String> values = this.getTemplateValues(msg);
            String subResourcePath = values.getFirst("FINAL_MATCH_GROUP");
            String httpMethod = (String)msg.get((Object)"org.apache.cxf.request.method");
            String contentType = (String)msg.get((Object)"Content-Type");
            if (contentType == null) {
                contentType = "*/*";
            }
            List acceptContentType = (List)msg.getExchange().get((Object)"Accept");
            result = JAXRSInvoker.checkResultObject(result, subResourcePath);
            subCri = cri.getSubResource(methodToInvoke.getReturnType(), ClassHelper.getRealClass((Object)result));
            if (subCri == null) {
                org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NO_SUBRESOURCE_FOUND", BUNDLE, new Object[]{subResourcePath});
                LOG.severe(errorM.toString());
                throw new WebApplicationException(404);
            }
            OperationResourceInfo subOri = JAXRSUtils.findTargetMethod(subCri, exchange.getInMessage(), httpMethod, values, contentType, acceptContentType, true);
            exchange.put(OperationResourceInfo.class, (Object)subOri);
            msg.put((Object)"jaxrs.template.parameters", values);
            List<Object> newParams = JAXRSUtils.processParameters(subOri, values, msg);
            msg.setContent(List.class, newParams);
            return this.invoke(exchange, newParams, result);
        }
        catch (IOException ex) {
            Response resp = JAXRSUtils.convertFaultToResponse(ex, exchange.getInMessage());
            if (resp == null) {
                resp = JAXRSUtils.convertFaultToResponse(new WebApplicationException(ex), exchange.getInMessage());
            }
            return new MessageContentsList(new Object[]{resp});
        }
        catch (WebApplicationException ex) {
            Response excResponse = JAXRSUtils.noResourceMethodForOptions(ex.getResponse(), (String)exchange.getInMessage().get((Object)"org.apache.cxf.request.method")) ? JAXRSUtils.createResponse(subCri, null, null, 200, true) : JAXRSUtils.convertFaultToResponse(ex, exchange.getInMessage());
            return new MessageContentsList(new Object[]{excResponse});
        }
    }

    protected MultivaluedMap<String, String> getTemplateValues(Message msg) {
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        MultivaluedMap oldValues = (MultivaluedMap)msg.get((Object)"jaxrs.template.parameters");
        if (oldValues != null) {
            values.putAll(oldValues);
        }
        return values;
    }

    private boolean setServiceLoaderAsContextLoader(Message inMessage) {
        Object en = inMessage.getContextualProperty(SERVICE_LOADER_AS_CONTEXT);
        return Boolean.TRUE.equals(en) || "true".equals(en);
    }

    private boolean isServiceObjectRequestScope(Message inMessage) {
        Object scope = inMessage.getContextualProperty(SERVICE_OBJECT_SCOPE);
        return REQUEST_SCOPE.equals(scope);
    }

    private ResourceProvider getResourceProvider(Exchange exchange) {
        Object provider = exchange.remove((Object)"service.root.provider");
        if (provider == null) {
            OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
            ClassResourceInfo cri = ori.getClassResourceInfo();
            return cri.getResourceProvider();
        }
        return (ResourceProvider)provider;
    }

    public Object getServiceObject(Exchange exchange) {
        Object root = exchange.remove((Object)"service.root.instance");
        if (root != null) {
            return root;
        }
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        return cri.getResourceProvider().getInstance(exchange.getInMessage());
    }

    protected Object getActualServiceObject(Exchange exchange, Object rootInstance) {
        Object last = exchange.get((Object)LAST_SERVICE_OBJECT);
        return last != null ? last : rootInstance;
    }

    private static Object checkResultObject(Object result, String subResourcePath) {
        if (result != null) {
            if (result instanceof MessageContentsList) {
                result = ((MessageContentsList)result).get(0);
            } else if (result instanceof List) {
                result = ((List)result).get(0);
            } else if (result.getClass().isArray()) {
                result = ((Object[])result)[0];
            }
        }
        if (result == null) {
            org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NULL_SUBRESOURCE", BUNDLE, new Object[]{subResourcePath});
            LOG.info(errorM.toString());
            throw new WebApplicationException(404);
        }
        return result;
    }

    private void pushOntoStack(OperationResourceInfo ori, Class<?> realClass, Message msg) {
        OperationResourceInfoStack stack = (OperationResourceInfoStack)msg.get(OperationResourceInfoStack.class);
        if (stack == null) {
            stack = new OperationResourceInfoStack();
            msg.put(OperationResourceInfoStack.class, (Object)stack);
        }
        MultivaluedMap params = (MultivaluedMap)msg.get((Object)"jaxrs.template.parameters");
        List<String> values = null;
        if (params == null || params.size() == 1) {
            values = Collections.emptyList();
        } else {
            values = new ArrayList<String>(params.size() - 1);
            for (Parameter pm : ori.getParameters()) {
                List paramValues;
                if (pm.getType() != ParameterType.PATH || (paramValues = (List)params.get(pm.getName())) == null) continue;
                values.addAll(paramValues);
            }
        }
        stack.push(new MethodInvocationInfo(ori, realClass, values));
    }
}

