/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.jaxrs.client.ClientWebApplicationException;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseReader
implements MessageBodyReader<Response> {
    @Context
    private MessageContext context;
    private Class<?> entityCls;
    private Type entityGenericType;

    public ResponseReader() {
    }

    public ResponseReader(Class<?> entityCls) {
        this.entityCls = entityCls;
    }

    @Override
    public boolean isReadable(Class<?> cls, Type genericType, Annotation[] anns, MediaType mt) {
        return cls.isAssignableFrom(Response.class);
    }

    @Override
    public Response readFrom(Class<Response> cls, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        int status = Integer.valueOf(this.getContext().get(Message.RESPONSE_CODE).toString());
        Response.ResponseBuilder rb = Response.status(status);
        for (String header : headers.keySet()) {
            List values = (List)headers.get(header);
            for (String value : values) {
                rb.header(header, value);
            }
        }
        if (this.entityCls != null) {
            Object entity = this.readFrom(this.entityCls, anns, mt, headers, is);
            rb.entity(entity);
        }
        return rb.build();
    }

    private <T> T readFrom(Class<T> type, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        Providers providers = this.getContext().getProviders();
        MessageBodyReader<T> reader = providers.getMessageBodyReader(type, this.getEntityGenericType(), anns, mt);
        if (reader == null) {
            throw new ClientWebApplicationException("No reader for Response entity " + this.entityCls.getName());
        }
        return reader.readFrom(type, this.getEntityGenericType(), anns, mt, headers, is);
    }

    public void setEntityClass(Class<?> cls) {
        this.entityCls = cls;
    }

    private Type getEntityGenericType() {
        return this.entityGenericType == null ? this.entityCls : this.entityGenericType;
    }

    protected MessageContext getContext() {
        return this.context;
    }
}

