/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.consumer;

import org.core4j.Enumerable;
import org.odata4j.consumer.AbstractConsumerEntityPayloadRequest;
import org.odata4j.consumer.ODataClient;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.consumer.ODataClientResponse;
import org.odata4j.core.OCreateRequest;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OEntities;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.exceptions.ODataProducerException;
import org.odata4j.format.Entry;
import org.odata4j.format.FormatParser;
import org.odata4j.format.FormatParserFactory;
import org.odata4j.format.Settings;
import org.odata4j.internal.FeedCustomizationMapping;
import org.odata4j.internal.InternalUtil;

public class ConsumerCreateEntityRequest<T>
extends AbstractConsumerEntityPayloadRequest
implements OCreateRequest<T> {
    private final ODataClient client;
    private OEntity parent;
    private String navProperty;
    private final FeedCustomizationMapping fcMapping;

    public ConsumerCreateEntityRequest(ODataClient client, String serviceRootUri, EdmDataServices metadata, String entitySetName, FeedCustomizationMapping fcMapping) {
        super(entitySetName, serviceRootUri, metadata);
        this.client = client;
        this.fcMapping = fcMapping;
    }

    @Override
    public T execute() throws ODataProducerException {
        EdmEntitySet ees = this.metadata.getEdmEntitySet(this.entitySetName);
        Entry entry = this.client.createRequestEntry(ees, null, this.props, this.links);
        StringBuilder url = new StringBuilder(this.serviceRootUri);
        if (this.parent != null) {
            url.append(InternalUtil.getEntityRelId(this.parent)).append("/").append(this.navProperty);
        } else {
            url.append(this.entitySetName);
        }
        ODataClientRequest request = ODataClientRequest.post(url.toString(), entry);
        ODataClientResponse response = this.client.createEntity(request);
        ODataVersion version = InternalUtil.getDataServiceVersion(response.getHeaders().getFirst("DataServiceVersion"));
        FormatParser<Entry> parser = FormatParserFactory.getParser(Entry.class, this.client.getFormatType(), new Settings(version, this.metadata, this.entitySetName, null, this.fcMapping));
        entry = parser.parse(this.client.getFeedReader(response));
        response.close();
        return (T)entry.getEntity();
    }

    @Override
    public T get() {
        EdmEntitySet entitySet = this.metadata.getEdmEntitySet(this.entitySetName);
        return (T)OEntities.createRequest(entitySet, this.props, this.links);
    }

    @Override
    public OCreateRequest<T> properties(OProperty<?> ... props) {
        return super.properties(this, props);
    }

    @Override
    public OCreateRequest<T> properties(Iterable<OProperty<?>> props) {
        return super.properties(this, props);
    }

    @Override
    public OCreateRequest<T> link(String navProperty, OEntity target) {
        return super.link(this, navProperty, target);
    }

    @Override
    public OCreateRequest<T> link(String navProperty, OEntityKey targetKey) {
        return super.link(this, navProperty, targetKey);
    }

    @Override
    public OCreateRequest<T> addToRelation(OEntity parent, String navProperty) {
        if (parent == null || navProperty == null) {
            throw new IllegalArgumentException("please provide the parent and the navProperty");
        }
        this.parent = parent;
        this.navProperty = navProperty;
        return this;
    }

    @Override
    public OCreateRequest<T> inline(String navProperty, OEntity ... entities) {
        return super.inline(this, navProperty, entities);
    }

    @Override
    public OCreateRequest<T> inline(String navProperty, Iterable<OEntity> entities) {
        return super.inline(this, navProperty, Enumerable.create(entities).toArray(OEntity.class));
    }
}

