/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.core4j.Enumerable;
import org.odata4j.core.OCollection;
import org.odata4j.core.OObject;
import org.odata4j.edm.EdmType;

public class OCollections {
    public static <T extends OObject> OCollection.Builder<T> newBuilder(EdmType type) {
        return new BuilderImpl(type);
    }

    private static class OCollectionImpl<T extends OObject>
    implements OCollection<T> {
        private final EdmType type;
        private final List<T> values;

        OCollectionImpl(EdmType type, List<T> values) {
            this.type = type;
            this.values = values;
        }

        @Override
        public EdmType getType() {
            return this.type;
        }

        @Override
        public Iterator<T> iterator() {
            return this.values.iterator();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        public String toString() {
            return String.format("OCollection[%s,%s]", this.type, Enumerable.create(this.values).join(","));
        }
    }

    private static class BuilderImpl<T extends OObject>
    implements OCollection.Builder<T> {
        private final EdmType type;
        private final List<T> values = new LinkedList<T>();

        BuilderImpl(EdmType type) {
            this.type = type;
        }

        @Override
        public OCollection.Builder<T> add(T value) {
            this.values.add(value);
            return this;
        }

        @Override
        public OCollection<T> build() {
            return new OCollectionImpl<T>(this.type, this.values);
        }
    }
}

